/*
 * ShowXMLStructureAction.java
 *
 * Created on July 1, 2005
 */

package org.myorg.xmltree;

import org.openide.util.*;
import org.openide.windows.*;
import org.openide.util.actions.CookieAction;
import org.openide.nodes.Node;
import org.openide.cookies.EditorCookie;
import org.openide.xml.XMLUtil;

import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;

/**
 *
 * @author User
 */

public class ShowXMLStructureAction extends CookieAction {
    
    private String[] tags;
    
    protected int mode() {
        return MODE_EXACTLY_ONE;
    }
    
    protected Class[] cookieClasses() {
        return new Class[] { EditorCookie.class };
    }
    
    public String getName() {
        return NbBundle.getMessage(ShowXMLStructureAction.class,"ACT_name");
    }
    
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    protected boolean enable(Node[] activatedNodes) {
        return true;
    }
    
    public void performAction(Node[] activatedNodes) {
        EditorCookie cookie = (EditorCookie)activatedNodes[0].getCookie(EditorCookie.class);
        javax.swing.text.StyledDocument doc = cookie.getDocument();
        String tabName = NbBundle.getMessage(ShowXMLStructureAction.class,"LBL_tabName");
        
        // "XML Tree" tab is created in output window for writing the list of tags
        InputOutput io = IOProvider.getDefault().getIO(tabName,false);
        io.select(); //XML Tree tab is selected
        OutputWriter writer = io.getOut();
        
        try {
            writer.reset(); //clean the output window
            java.io.InputStream is =  ((org.openide.text.CloneableEditorSupport)cookie).getInputStream();
            parse(new InputSource(is));
            is.close();
            for (int i=0;i<tags.length;i++) {
                writer.println(tags[i]); //write tag to output window
            }
        } catch (IOException ex) {
        } catch (SAXException ex){
            writer.println("Parse Error: "+ex.getMessage());
        }
        writer.flush();
        writer.close();
    }
    
    /** Parses XML document and creates the list of tags
     */
    private void parse(InputSource is) throws IOException, SAXException {
        XMLReader xmlReader = XMLUtil.createXMLReader();
        TagHandler handler = new TagHandler();
        xmlReader.setContentHandler(handler);
        xmlReader.parse(is);
        tags = handler.getTags(); 
    }

    protected boolean asynchronous() {
        return true;
    }
    
    /** Specific XML handler used for creating list of starting and ending tags, e.g. :
     * <AAA>
     *   <BBB>
     *     <CCC/>
     *   </BBB>
     * </AAA>
     */
    private class TagHandler extends org.xml.sax.helpers.DefaultHandler {
        private final int indentLength=2;
        
        private java.util.List tagList;
        private String indent;
        private String space;
        private String lastElement;
        
        TagHandler() {
            tagList = new java.util.ArrayList();
            StringBuffer indentBuf = new StringBuffer();
            for (int i=0;i<indentLength;i++) indentBuf.append(' ');
            space=indentBuf.toString();
            indent="";
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            tagList.add(indent+"<"+qName+">");
            indent+=space;
            lastElement=qName;
            
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            indent=indent.substring(indentLength);
            if (qName.equals(lastElement)) {
                int lastIndex = tagList.size()-1;
                String lastInList = (String)tagList.get(lastIndex);
                String replacedString = lastInList.replace(">","/>");
                tagList.set(lastIndex,replacedString);
            } else {     
                tagList.add(indent+"</"+qName+">");
            }
            lastElement=null;
        }
        
        String[] getTags() {
            String[] tags = new String[tagList.size()];
            tagList.toArray(tags);
            return tags;
        }
    } 
    
}