/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 */

/* This file has been modified by Open Source Strategies, Inc. */

import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcClient;

import java.util.Map;
import java.net.URL;


/**
 * TestXmlRpcClient is the simplest example of a Java XML RPC client to call OFBIZ 
 */
public class TestXmlRpcClient { 

    public static void main(String[] args) {
       try {
           XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
           config.setServerURL(new URL("http://localhost:8075/webtools/control/xmlrpc"));
           config.setBasicUserName("admin");
           config.setBasicPassword("ofbiz");

           XmlRpcClient client = new XmlRpcClient();
           client.setConfig(config);

// OFBIZ takes XML-RPC service parameters in order of service definitions as a vector, not a Map of pairs
           Object[] params = new Object[] { "DemoContact1" };
           Map result = (Map) client.execute("getPartyEmail", params);
           System.out.println("Result from XML RPC call is: " + result);
       } catch (Exception ex) {
           System.out.println(ex.getMessage());
       }
    }
}
