<?php
	require_once('xmlrpc-2.2/lib/xmlrpc.inc');
	
	$xmlrpcurl = "http://localhost:8080/catalogexport/xmlrpc";
	$serviceName = "catalogexport.getProductPrices";
	$userName = "admin";
	$password = "ofbiz";
	$inParamValues = array("productId" => "GZ-1000", "catalogId" => "DemoCatalog", "productStoreId" => "9000");
	
	$params = array();
	foreach ( $inParamValues as $inParamName => $inParamValue ) {
		$params[$inParamName] = new xmlrpcval( $inParamValue );
	}
	$val = new xmlrpcval();
	$val -> addStruct( $params );
	$allParams = array( $val );

	$client = new xmlrpc_client( $xmlrpcurl );
	$client -> setCredentials( $userName , $password );
	$msg = new xmlrpcmsg( $serviceName , $allParams );
	$response = $client -> send( $msg );

	if ( ! $response ) {
	     die( "Unable to contact XML-RPC Server" ); 
	}
	
	if ( ! $response -> faultCode() ) {
	     $responseData = php_xmlrpc_decode( $response -> value() );
	} else { 
		 print( "XML-RPC Fault Occurred\n" );
	     print( "Fault Code: " . $response->faultCode() . "\n" );
	     print( "Fault Desc: " . $response->faultString() . "\n" );
	     die();
	}

    print( $response -> serialize() );
    
?>
