/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.datafeed.StockEntry;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class Stock
extends AxesRenderer {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        if (cwa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.stock.dimension", new Object[]{cwa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (this.isTransposed()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.no.transposed.stock.chart", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)vex);
        }
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        logger.log(1, Messages.getString("info.render.series", new Object[]{((Object)((Object)this)).getClass().getName(), new Integer(this.iSeriesIndex + 1), new Integer(this.iSeriesCount)}, this.getRunTimeContext().getULocale()));
        StockSeries ss = (StockSeries)this.getSeries();
        if (!ss.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.series.visibility", new Object[]{ss}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!ss.isVisible()) {
            return;
        }
        double dSeriesThickness = srh.getSeriesThickness();
        DataPointHints[] dpha = srh.getDataPoints();
        LineAttributes lia = ss.getLineAttributes();
        double dUnitSpacing = !cwa.isSetUnitSpacing() ? 50.0 : cwa.getUnitSpacing();
        double dX = 0.0;
        double dY = 0.0;
        double dWidth = 0.0;
        double dHeight = 0.0;
        double dSpacing = 0.0;
        Location loStart = null;
        Location loEnd = null;
        Location loUpper = LocationImpl.create((double)0.0, (double)0.0);
        Location loLower = LocationImpl.create((double)0.0, (double)0.0);
        Location[] loaFrontFace = null;
        SeriesDefinition sd = this.getSeriesDefinition();
        EList elPalette = sd.getSeriesPalette().getEntries();
        int iPaletteSize = elPalette.size();
        if (iPaletteSize == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{ss}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bPaletteByCategory = this.isPaletteByCategory();
        int iThisSeriesIndex = -1;
        Fill fPaletteEntry = null;
        if (!bPaletteByCategory) {
            iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ss);
            if (iThisSeriesIndex < 0) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ss, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
            }
            fPaletteEntry = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
        }
        this.renderClipping(ipr, this.getPlotBounds());
        double[] faX = new double[dpha.length];
        double[] faY = new double[dpha.length];
        AutoScale scale = this.getInternalOrthogonalAxis().getScale();
        int i = 0;
        while (i < dpha.length) {
            block36: {
                StockEntry se = (StockEntry)dpha[i].getOrthogonalValue();
                if (this.isValidEntry(se)) {
                    EList elTriggers;
                    LineRenderEvent lre;
                    double dClose;
                    double dOpen;
                    double dHigh;
                    double dLow;
                    this.correctEntry(se);
                    if (this.checkEntryInRange(se, scale.getMinimum(), scale.getMaximum()) > 0) {
                        dpha[i].markOutside();
                    }
                    fPaletteEntry = bPaletteByCategory ? (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(i % iPaletteSize))) : (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
                    this.updateTranslucency(fPaletteEntry, (Series)ss);
                    Location lo = dpha[i].getLocation();
                    dX = lo.getX();
                    dY = lo.getY();
                    try {
                        dLow = srh.getLocationOnOrthogonal((Object)new Double(se.getLow()));
                        dHigh = srh.getLocationOnOrthogonal((Object)new Double(se.getHigh()));
                        dOpen = srh.getLocationOnOrthogonal((Object)new Double(se.getOpen()));
                        dClose = srh.getLocationOnOrthogonal((Object)new Double(se.getClose()));
                    }
                    catch (Exception ex) {
                        logger.log(ex);
                        break block36;
                    }
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i]);
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i]);
                    dSpacing = dpha[i].getSize() * dUnitSpacing / 200.0;
                    if (loStart == null) {
                        loStart = LocationImpl.create((double)0.0, (double)0.0);
                        loEnd = LocationImpl.create((double)0.0, (double)0.0);
                        loaFrontFace = new Location[4];
                        int j = 0;
                        while (j < 4) {
                            loaFrontFace[j] = LocationImpl.create((double)0.0, (double)0.0);
                            ++j;
                        }
                    }
                    if (ss.isShowAsBarStick()) {
                        int stickLength = ss.getStickLength();
                        Location loStart2 = LocationImpl.create((double)0.0, (double)0.0);
                        Location loEnd2 = LocationImpl.create((double)0.0, (double)0.0);
                        dWidth = dpha[i].getSize();
                        loStart.set((dX += dWidth / 2.0) - (double)stickLength, dOpen);
                        loEnd.set(dX + (double)stickLength, dClose);
                        loStart2.set(dX, dOpen);
                        loEnd2.set(dX, dClose);
                        loUpper.set(dX, dHigh > dLow ? dHigh : dLow);
                        loLower.set(dX, dHigh < dLow ? dHigh : dLow);
                        loaFrontFace[0].set(dX - (double)stickLength, dHigh);
                        loaFrontFace[1].set(dX - (double)stickLength, dLow);
                        loaFrontFace[2].set(dX + (double)stickLength, dLow);
                        loaFrontFace[3].set(dX + (double)stickLength, dHigh);
                        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                        StructureSource structureSource = WrappedStructureSource.createSeriesDataPoint((Series)ss, (DataPointHints)dpha[i]);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        lre = (LineRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
                        lre.setLineAttributes(lia);
                        lre.setStart(loUpper);
                        lre.setEnd(loLower);
                        ipr.drawLine(lre);
                        lre.setStart(loStart);
                        lre.setEnd(loStart2);
                        ipr.drawLine(lre);
                        lre.setStart(loEnd);
                        lre.setEnd(loEnd2);
                        ipr.drawLine(lre);
                    } else {
                        dWidth = dpha[i].getSize();
                        loStart.set(dX += dSpacing + (dWidth -= 2.0 * dSpacing) / 2.0, dLow);
                        loEnd.set(dX, dHigh);
                        loaFrontFace[0].set(dX - dWidth / 2.0, dOpen);
                        loaFrontFace[1].set(dX - dWidth / 2.0, dClose);
                        loaFrontFace[2].set(dX + dWidth / 2.0, dClose);
                        loaFrontFace[3].set(dX + dWidth / 2.0, dOpen);
                        loUpper.set(dX, dOpen > dClose ? dOpen : dClose);
                        loLower.set(dX, dOpen < dClose ? dOpen : dClose);
                        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                        StructureSource structureSource = WrappedStructureSource.createSeriesDataPoint((Series)ss, (DataPointHints)dpha[i]);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        lre = (LineRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
                        lre.setLineAttributes(lia);
                        lre.setStart(loStart);
                        lre.setEnd(loUpper);
                        ipr.drawLine(lre);
                        lre.setStart(loLower);
                        lre.setEnd(loEnd);
                        ipr.drawLine(lre);
                        this.renderPlane(ipr, WrappedStructureSource.createSeriesDataPoint((Series)ss, (DataPointHints)dpha[i]), loaFrontFace, Stock.convertFill(fPaletteEntry, se.getClose() > se.getOpen()), lia, cwa.getDimension(), dSeriesThickness, false);
                    }
                    if (cwa.isTransposed()) {
                        faX[i] = (loUpper.getX() + loLower.getX()) / 2.0;
                        faY[i] = loUpper.getY();
                    } else {
                        faX[i] = loLower.getX();
                        faY[i] = (loUpper.getY() + loLower.getY()) / 2.0;
                    }
                    if (this.isInteractivityEnabled() && !(elTriggers = ss.getTriggers()).isEmpty()) {
                        StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)ss, (DataPointHints)dpha[i]);
                        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        InteractionEvent iev = (InteractionEvent)eventObjectCache.getEventObject((Object)iSource, (Class)clazz);
                        int t = 0;
                        while (t < elTriggers.size()) {
                            Trigger tg = TriggerImpl.copyInstance((Trigger)((Trigger)elTriggers.get(t)));
                            this.processTrigger(tg, iSource);
                            iev.addTrigger(tg);
                            ++t;
                        }
                        EventObjectCache eventObjectCache2 = (EventObjectCache)ipr;
                        StructureSource structureSource = StructureSource.createSeries((Series)ss);
                        Class<?> clazz2 = class$2;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache2.getEventObject((Object)structureSource, (Class)clazz2);
                        pre.setPoints(loaFrontFace);
                        iev.setHotSpot((PrimitiveRenderEvent)pre);
                        ipr.enableInteraction(iev);
                    }
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i]);
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i]);
                    this.renderDataPointLabel(srh.getLabelAttributes(this.getSeries()), dpha[i], srh.getLabelPosition(this.getSeries()), loaFrontFace, p, sh, dX, dY, dWidth, dHeight, dHigh, dLow, dOpen, dClose);
                }
            }
            ++i;
        }
        if (this.getSeries().getCurveFitting() != null) {
            Location[] larray = new Location[faX.length];
            int i2 = 0;
            while (i2 < larray.length) {
                larray[i2] = LocationImpl.create((double)faX[i2], (double)faY[i2]);
                ++i2;
            }
            larray = this.filterNull(larray);
            this.renderFittingCurve(ipr, larray, this.getSeries().getCurveFitting(), false, true);
        }
        this.restoreClipping(ipr);
    }

    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        ClientArea ca = lg.getClientArea();
        StockSeries ss = (StockSeries)this.getSeries();
        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
        StructureSource structureSource = StructureSource.createLegend((Legend)lg);
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.RectangleRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RectangleRenderEvent rre = (RectangleRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
        rre.setBackground(ca.getBackground());
        rre.setBounds(bo);
        ipr.fillRectangle(rre);
        LineAttributes lia = ss.getLineAttributes();
        if (!lia.isSetVisible() || !lia.isVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.stock.lineattr.visibility", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        EventObjectCache eventObjectCache2 = (EventObjectCache)ipr;
        StructureSource structureSource2 = StructureSource.createLegend((Legend)lg);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LineRenderEvent lre = (LineRenderEvent)eventObjectCache2.getEventObject((Object)structureSource2, (Class)clazz2);
        EventObjectCache eventObjectCache3 = (EventObjectCache)ipr;
        StructureSource structureSource3 = StructureSource.createLegend((Legend)lg);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.birt.chart.event.RectangleRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        rre = (RectangleRenderEvent)eventObjectCache3.getEventObject((Object)structureSource3, (Class)clazz3);
        lre.setLineAttributes(lia);
        rre.setBackground(fPaletteEntry);
        rre.setOutline(lia);
        if (cwa.isTransposed()) {
            lre.setStart(LocationImpl.create((double)bo.getLeft(), (double)(bo.getTop() + bo.getHeight() / 2.0)));
            lre.setEnd(LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)(bo.getTop() + bo.getHeight() / 2.0)));
            rre.setBounds(BoundsImpl.create((double)(bo.getLeft() + bo.getWidth() / 4.0), (double)(bo.getTop() + 1.0), (double)(bo.getWidth() / 2.0), (double)(bo.getHeight() - 2.0)));
        } else {
            lre.setStart(LocationImpl.create((double)(bo.getLeft() + bo.getWidth() / 2.0), (double)(bo.getTop() + bo.getHeight())));
            lre.setEnd(LocationImpl.create((double)(bo.getLeft() + bo.getWidth() / 2.0), (double)bo.getTop()));
            rre.setBounds(BoundsImpl.create((double)(bo.getLeft() + 1.0), (double)(bo.getTop() + bo.getHeight() / 4.0), (double)(bo.getWidth() - 2.0), (double)(bo.getHeight() / 2.0)));
        }
        ipr.drawLine(lre);
        ipr.fillRectangle(rre);
        ipr.drawRectangle(rre);
    }

    private boolean isValidEntry(StockEntry entry) {
        return entry != null && !Double.isNaN(entry.getHigh()) && !Double.isNaN(entry.getLow()) && !Double.isNaN(entry.getClose()) && !Double.isNaN(entry.getOpen());
    }

    private void correctEntry(StockEntry entry) {
        double dLow;
        double dHigh;
        if (entry.getOpen() > entry.getClose()) {
            dHigh = entry.getOpen();
            dLow = entry.getClose();
        } else {
            dHigh = entry.getClose();
            dLow = entry.getOpen();
        }
        if (entry.getHigh() < entry.getLow()) {
            logger.log((Exception)((Object)new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.stock.entry.invalid.highlow", new Object[]{new Double(entry.getHigh()), new Double(entry.getLow())}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()))));
            entry.setHigh(dHigh);
            entry.setLow(dLow);
        }
        if (entry.getHigh() < dHigh) {
            logger.log((Exception)((Object)new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.stock.entry.invalid.high", new Object[]{new Double(entry.getHigh()), new Double(dHigh)}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()))));
            entry.setHigh(dHigh);
        }
        if (entry.getLow() > dLow) {
            logger.log((Exception)((Object)new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.stock.entry.invalid.low", new Object[]{new Double(entry.getLow()), new Double(dLow)}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()))));
            entry.setLow(dLow);
        }
    }

    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
    }

    protected void renderDataPointLabel(Label laDataPoint, DataPointHints dph, Position pDataPoint, Location[] loaFrontFace, Plot p, ScriptHandler sh, double dX, double dY, double dWidth, double dHeight, double dHigh, double dLow, double dOpen, double dClose) throws ChartException {
        if (laDataPoint.isVisible() && !dph.isOutside()) {
            laDataPoint.getCaption().setValue(dph.getDisplayValue());
            ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)dph, (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)laDataPoint);
            Location loDataPoint = LocationImpl.create((double)0.0, (double)0.0);
            if (((StockSeries)this.getSeries()).isShowAsBarStick()) {
                dWidth = ((StockSeries)this.getSeries()).getStickLength();
            }
            switch (pDataPoint.getValue()) {
                case 0: 
                case 4: 
                case 5: {
                    loDataPoint.set(dX, dHigh - (double)p.getVerticalSpacing());
                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dph), 2, laDataPoint, Position.ABOVE_LITERAL, loDataPoint, null);
                    break;
                }
                case 1: {
                    loDataPoint.set(dX, dLow + (double)p.getVerticalSpacing());
                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dph), 2, laDataPoint, Position.BELOW_LITERAL, loDataPoint, null);
                    break;
                }
                case 2: {
                    loDataPoint.set(dX - dWidth / 2.0 - (double)p.getHorizontalSpacing(), (dOpen + dClose) / 2.0);
                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dph), 2, laDataPoint, Position.LEFT_LITERAL, loDataPoint, null);
                    break;
                }
                case 3: {
                    loDataPoint.set(dX + dWidth / 2.0 + (double)p.getHorizontalSpacing(), (dOpen + dClose) / 2.0);
                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dph), 2, laDataPoint, Position.RIGHT_LITERAL, loDataPoint, null);
                    break;
                }
                default: {
                    logger.log((Exception)((Object)new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.stock", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()))));
                }
            }
            ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)dph, (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)laDataPoint);
        }
    }

    protected int checkEntryInRange(Object entry, Object min, Object max) {
        if (entry instanceof StockEntry) {
            StockEntry se = (StockEntry)entry;
            double dMin = Methods.asDouble((Object)min);
            double dMax = Methods.asDouble((Object)max);
            if (se.getLow() < dMin) {
                return 1;
            }
            if (se.getHigh() > dMax) {
                return 2;
            }
            return 0;
        }
        return super.checkEntryInRange(entry, min, max);
    }

    static Fill convertFill(Fill fill, boolean bIncrease) {
        if (bIncrease) {
            fill = fill instanceof MultipleFill ? ColorDefinitionImpl.copyInstance((ColorDefinition)((ColorDefinition)((MultipleFill)fill).getFills().get(0))) : ColorDefinitionImpl.WHITE();
        } else if (fill instanceof MultipleFill) {
            fill = ColorDefinitionImpl.copyInstance((ColorDefinition)((ColorDefinition)((MultipleFill)fill).getFills().get(1)));
        }
        return fill;
    }
}

