/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.util.Calendar;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.computation.UserDataSetHints;
import org.eclipse.birt.chart.computation.Vector;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints3D;
import org.eclipse.birt.chart.datafeed.IDataSetProcessor;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.Text3DRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.Location3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;

public class PlotWith3DAxes
extends PlotWithAxes {
    private final double SPACE_THRESHOLD;
    private Engine3D engine;
    private Bounds cachedAdjustedBounds;
    protected double dZAxisPlotSpacing = 0.0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.chart.computation.withaxes.PlotWith3DAxes");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PlotWith3DAxes(IDisplayServer _ids, ChartWithAxes _cwa, RunTimeContext _rtc) throws IllegalArgumentException, ChartException {
        this.cwa = _cwa;
        this.ids = _ids;
        this.rtc = _rtc;
        this.dPointToPixel = (double)this.ids.getDpiResolution() / 72.0;
        this.SPACE_THRESHOLD = 5.0 * this.dPointToPixel;
        if (this.cwa.isTransposed()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 15, "exception.no.transposed.3D.chart", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        this.buildAxes();
    }

    private Bounds getAdjustedPlotBounds(boolean refresh) {
        if (!refresh && this.cachedAdjustedBounds != null) {
            return this.cachedAdjustedBounds;
        }
        Bounds bo = this.getPlotBounds().adjustedInstance(this.getPlotInsets());
        Label la = LabelImpl.copyInstance(this.aax.getPrimaryBase().getLabel());
        la.getCaption().setValue("X");
        double h = PlotWith3DAxes.computeHeight(this.ids, la);
        la = LabelImpl.copyInstance(this.aax.getAncillaryBase().getLabel());
        la.getCaption().setValue("X");
        h = Math.max(h, PlotWith3DAxes.computeHeight(this.ids, la));
        la = LabelImpl.copyInstance(this.aax.getPrimaryOrthogonal().getLabel());
        la.getCaption().setValue("X");
        double w = PlotWith3DAxes.computeWidth(this.ids, la);
        bo.adjust(InsetsImpl.create(0.0, 0.0, h, w));
        this.cachedAdjustedBounds = bo;
        return bo;
    }

    public final Location getPanningOffset() {
        Bounds bo = this.getAdjustedPlotBounds(false);
        double xOff = bo.getLeft();
        double yOff = bo.getTop();
        return LocationImpl.create(xOff, yOff);
    }

    public final Engine3D get3DEngine() {
        if (this.engine == null) {
            Vector lightDirection = new Vector(-1.0, 1.0, -1.0, false);
            Bounds bo = this.getPlotBounds().adjustedInstance(this.getPlotInsets());
            double width = bo.getWidth();
            double height = bo.getHeight();
            this.engine = new Engine3D(this.cwa.getRotation(), lightDirection, width, height, 500.0 * this.dPointToPixel, 1500.0 * this.dPointToPixel, 10.0 * this.dPointToPixel, 10000.0 * this.dPointToPixel, 100.0);
        }
        return this.engine;
    }

    /*
     * Unable to fully structure code
     */
    private double detectZoomScale(Engine3D engine, double xdz, double xOff, double yOff, double width, double height) {
        zlen = 1.0 * this.dPointToPixel;
        xlen = xdz * this.dPointToPixel;
        ylen = (xdz + 1.0) * this.dPointToPixel / 2.0;
        vertexList = new ArrayList<Location3D>();
        bbl = Location3DImpl.create(-xlen / 2.0, -ylen / 2.0, -zlen / 2.0);
        bbr = Location3DImpl.create(xlen / 2.0, -ylen / 2.0, -zlen / 2.0);
        bfl = Location3DImpl.create(-xlen / 2.0, -ylen / 2.0, zlen / 2.0);
        bfr = Location3DImpl.create(xlen / 2.0, -ylen / 2.0, zlen / 2.0);
        tbl = Location3DImpl.create(-xlen / 2.0, ylen / 2.0, -zlen / 2.0);
        tbr = Location3DImpl.create(xlen / 2.0, ylen / 2.0, -zlen / 2.0);
        tfl = Location3DImpl.create(-xlen / 2.0, ylen / 2.0, zlen / 2.0);
        tfr = Location3DImpl.create(xlen / 2.0, ylen / 2.0, zlen / 2.0);
        vertexList.add(bbl);
        vertexList.add(bbr);
        vertexList.add(bfl);
        vertexList.add(bfr);
        vertexList.add(tbl);
        vertexList.add(tbr);
        vertexList.add(tfl);
        vertexList.add(tfr);
        event = new Text3DRenderEvent(this);
        maxLeft = 1.7976931348623157E308;
        maxRight = -1.7976931348623157E308;
        maxTop = 1.7976931348623157E308;
        maxBottom = -1.7976931348623157E308;
        itr = vertexList.iterator();
        while (itr.hasNext()) {
            p3d = (Location3D)itr.next();
            event.setLocation3D(Location3DImpl.create(p3d.getX(), p3d.getY(), p3d.getZ()));
            if (engine.processEvent(event, xOff, yOff) == null) continue;
            p2d = event.getLocation();
            x = p2d.getX();
            y = p2d.getY();
            if (x < maxLeft) {
                maxLeft = x;
            }
            if (x > maxRight) {
                maxRight = x;
            }
            if (y < maxTop) {
                maxTop = y;
            }
            if (!(y > maxBottom)) continue;
            maxBottom = y;
        }
        vSpace = maxTop - yOff;
        hSpace = maxLeft - xOff;
        if (yOff + height - maxBottom < maxTop - yOff) {
            vSpace = yOff + height - maxBottom;
        }
        if (xOff + width - maxRight < maxLeft - xOff) {
            hSpace = xOff + width - maxRight;
        }
        minSpace = Math.min(hSpace, vSpace);
        lastMinspace = 0.0;
        fit = hSpace > 0.0 && vSpace > 0.0;
        scale = lastScale = 1.0;
        iterateStarted = false;
        if (fit) ** GOTO lbl107
        return 1.0;
lbl-1000:
        // 1 sources

        {
            scale = fit != false && iterateStarted == false ? lastScale * 2.0 : (lastScale + scale) / 2.0;
            maxLeft = 1.7976931348623157E308;
            maxRight = -1.7976931348623157E308;
            maxTop = 1.7976931348623157E308;
            maxBottom = -1.7976931348623157E308;
            forceBreak = false;
            itr = vertexList.iterator();
            while (itr.hasNext()) {
                p3d = (Location3D)itr.next();
                event.setLocation3D(Location3DImpl.create(p3d.getX() * scale, p3d.getY() * scale, p3d.getZ() * scale));
                if (engine.processEvent(event, xOff, yOff) != null) {
                    p2d = event.getLocation();
                    x = p2d.getX();
                    y = p2d.getY();
                    if (x < maxLeft) {
                        maxLeft = x;
                    }
                    if (x > maxRight) {
                        maxRight = x;
                    }
                    if (y < maxTop) {
                        maxTop = y;
                    }
                    if (!(y > maxBottom)) continue;
                    maxBottom = y;
                    continue;
                }
                fit = false;
                forceBreak = true;
                break;
            }
            if (!forceBreak) {
                vSpace = maxTop - yOff;
                hSpace = maxLeft - xOff;
                if (yOff + height - maxBottom < maxTop - yOff) {
                    vSpace = yOff + height - maxBottom;
                }
                if (xOff + width - maxRight < maxLeft - xOff) {
                    hSpace = xOff + width - maxRight;
                }
                v0 = fit = vSpace > 0.0 && hSpace > 0.0;
            }
            if (fit) {
                lastMinspace = minSpace;
                minSpace = Math.min(hSpace, vSpace);
                nextScale = 2.0 * scale - lastScale;
                lastScale = scale;
                scale = nextScale;
                continue;
            }
            if (iterateStarted) continue;
            iterateStarted = true;
lbl107:
            // 4 sources

            ** while (ChartUtil.mathGT((double)Math.abs((double)(minSpace - lastMinspace)), (double)0.0) && (fit && minSpace > this.SPACE_THRESHOLD || !fit))
        }
lbl108:
        // 1 sources

        return lastScale;
    }

    private double computeAxisZoomFactor(Engine3D engine, double start, double end, Location3D startVertext, Location3D endVertext, double xOff, double yOff) {
        Text3DRenderEvent event = new Text3DRenderEvent(this);
        event.setLocation3D(startVertext);
        if (engine.processEvent(event, xOff, yOff) != null) {
            Location p2d = event.getLocation();
            double x1 = p2d.getX();
            double y1 = p2d.getY();
            event.setLocation3D(endVertext);
            if (engine.processEvent(event, xOff, yOff) != null) {
                p2d = event.getLocation();
                double x2 = p2d.getX();
                double y2 = p2d.getY();
                return Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1)) / (end - start);
            }
        }
        return 1.0;
    }

    public void compute(Bounds bo) throws ChartException, IllegalArgumentException {
        bo = bo.scaledInstance(this.dPointToPixel);
        this.boPlotBackground = BoundsImpl.copyInstance(bo);
        this.iDimension = PlotWith3DAxes.getDimension(this.cwa.getDimension());
        if (!$assertionsDisabled && this.iDimension != 2) {
            throw new AssertionError();
        }
        this.dXAxisPlotSpacing = (double)this.cwa.getPlot().getHorizontalSpacing() * this.dPointToPixel;
        this.dYAxisPlotSpacing = (double)this.cwa.getPlot().getVerticalSpacing() * this.dPointToPixel;
        this.dZAxisPlotSpacing = this.dXAxisPlotSpacing;
        Axis[] axa = this.cwa.getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        Axis axPrimaryOrthogonal = this.cwa.getPrimaryOrthogonalAxis(axPrimaryBase);
        Axis axAncillaryBase = this.cwa.getAncillaryBaseAxis(axPrimaryBase);
        Object oaData = null;
        OneAxis oaxPrimaryBase = this.aax.getPrimaryBase();
        int iPrimaryAxisType = PlotWith3DAxes.getAxisType(axPrimaryBase);
        if (iPrimaryAxisType == 16 || oaxPrimaryBase.isCategoryScale()) {
            oaData = this.getTypedDataSet(axPrimaryBase, iPrimaryAxisType, 0);
        } else if ((iPrimaryAxisType & 1) == 1) {
            oaData = this.getMinMax(axPrimaryBase, iPrimaryAxisType);
        } else if ((iPrimaryAxisType & 8) == 8) {
            oaData = this.getMinMax(axPrimaryBase, iPrimaryAxisType);
        }
        DataSetIterator dsiPrimaryBase = oaData instanceof DataSetIterator ? oaData : new DataSetIterator(oaData, iPrimaryAxisType);
        oaData = null;
        OneAxis oaxAncillaryBase = this.aax.getAncillaryBase();
        int iAncillaryAxisType = PlotWith3DAxes.getAxisType(axAncillaryBase);
        if (iAncillaryAxisType == 16 || oaxAncillaryBase.isCategoryScale()) {
            oaData = this.getAncillaryDataSet(axAncillaryBase, axPrimaryOrthogonal, iAncillaryAxisType);
        } else if ((iAncillaryAxisType & 1) == 1) {
            oaData = this.getMinMax(axAncillaryBase, iAncillaryAxisType);
        } else if ((iAncillaryAxisType & 8) == 8) {
            oaData = this.getMinMax(axAncillaryBase, iAncillaryAxisType);
        }
        DataSetIterator dsiAncillary = oaData instanceof DataSetIterator ? (DataSetIterator)oaData : new DataSetIterator(oaData, iAncillaryAxisType);
        oaData = null;
        OneAxis oaxPrimaryOrthogonal = this.aax.getPrimaryOrthogonal();
        int iOrthogonalAxisType = PlotWith3DAxes.getAxisType(axPrimaryOrthogonal);
        DataSetIterator dsiOrthogonal = null;
        if ((iOrthogonalAxisType & 1) != 1 && (iOrthogonalAxisType & 8) != 8) {
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.orthogonal.axis.numerical.datetime", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        dsiOrthogonal = new DataSetIterator(this.getMinMax(axPrimaryOrthogonal, iOrthogonalAxisType), iOrthogonalAxisType);
        double dXDZ = (double)dsiPrimaryBase.size() * 1.0 / (double)dsiAncillary.size();
        Bounds adjustedBounds = this.getAdjustedPlotBounds(true);
        double xOffset = adjustedBounds.getLeft();
        double yOffset = adjustedBounds.getTop();
        double zoomScale = this.detectZoomScale(this.get3DEngine(), dXDZ, xOffset, yOffset, adjustedBounds.getWidth(), adjustedBounds.getHeight());
        double dWZ = zoomScale * this.dPointToPixel;
        double dW = dXDZ * zoomScale * this.dPointToPixel;
        double dH = (dW + dWZ) / 2.0;
        double dX = -dW / 2.0;
        double dY = -dH / 2.0;
        double dZ = -dWZ / 2.0;
        Location panningOffset = this.getPanningOffset();
        double xZoom = this.computeAxisZoomFactor(this.get3DEngine(), dX, dX + dW, Location3DImpl.create(dX, dY, dZ), Location3DImpl.create(dX + dW, dY, dZ), panningOffset.getX(), panningOffset.getY());
        double yZoom = this.computeAxisZoomFactor(this.get3DEngine(), dY, dY + dH, Location3DImpl.create(dX, dY, dZ), Location3DImpl.create(dX, dY + dH, dZ), panningOffset.getX(), panningOffset.getY());
        double zZoom = this.computeAxisZoomFactor(this.get3DEngine(), dZ, dZ + dWZ, Location3DImpl.create(dX, dY, dZ), Location3DImpl.create(dX, dY, dZ + dWZ), panningOffset.getX(), panningOffset.getY());
        AutoScale scPrimaryBase = null;
        double dStart = dX;
        double dEnd = dX + dW;
        Scale sc = axPrimaryBase.getScale();
        scPrimaryBase = AutoScale.computeScale(this.ids, oaxPrimaryBase, dsiPrimaryBase, iPrimaryAxisType, dStart, dEnd, sc, axPrimaryBase.getFormatSpecifier(), this.rtc, 1, xZoom, 0);
        oaxPrimaryBase.set(scPrimaryBase);
        AutoScale scAncillaryBase = null;
        dStart = dZ;
        dEnd = dZ + dWZ;
        sc = axAncillaryBase.getScale();
        scAncillaryBase = AutoScale.computeScale(this.ids, oaxAncillaryBase, dsiAncillary, iAncillaryAxisType, dStart, dEnd, sc, axAncillaryBase.getFormatSpecifier(), this.rtc, 1, zZoom, 0);
        oaxAncillaryBase.set(scAncillaryBase);
        AutoScale scPrimaryOrthogonal = null;
        dStart = dY;
        dEnd = dY + dH;
        sc = axPrimaryOrthogonal.getScale();
        scPrimaryOrthogonal = AutoScale.computeScale(this.ids, oaxPrimaryOrthogonal, dsiOrthogonal, iOrthogonalAxisType, dStart, dEnd, sc, axPrimaryOrthogonal.getFormatSpecifier(), this.rtc, 1, yZoom, 0);
        oaxPrimaryOrthogonal.set(scPrimaryOrthogonal);
        double dYAxisLocationOnX = dX;
        double dYAxisLocationOnZ = dZ;
        double dXAxisLocation = dY;
        double dZAxisLocation = dY;
        iOrthogonalAxisType = PlotWith3DAxes.getAxisType(axPrimaryOrthogonal);
        oaData = this.getTypedDataSet(axPrimaryOrthogonal, iOrthogonalAxisType, 0);
        scPrimaryOrthogonal.setData(dsiOrthogonal);
        iAncillaryAxisType = PlotWith3DAxes.getAxisType(axAncillaryBase);
        if (iAncillaryAxisType != 16) {
            scAncillaryBase.setData(this.getTypedDataSet(axAncillaryBase, iAncillaryAxisType, 0));
        }
        if ((iPrimaryAxisType = PlotWith3DAxes.getAxisType(axPrimaryBase)) != 16) {
            scPrimaryBase.setData(this.getTypedDataSet(axPrimaryBase, iPrimaryAxisType, 0));
        }
        scPrimaryBase.resetShifts();
        scAncillaryBase.resetShifts();
        scPrimaryOrthogonal.resetShifts();
        OneAxis axPH = this.aax.getPrimaryBase();
        OneAxis axPV = this.aax.getPrimaryOrthogonal();
        OneAxis axAB = this.aax.getAncillaryBase();
        axPH.setAxisCoordinate(dXAxisLocation);
        axPV.setAxisCoordinate(dYAxisLocationOnX);
        axAB.setAxisCoordinate(dZAxisLocation);
        axPH.setAxisCoordinate3D(Location3DImpl.create(0.0, dXAxisLocation, dYAxisLocationOnZ));
        axPV.setAxisCoordinate3D(Location3DImpl.create(dYAxisLocationOnX, 0.0, dYAxisLocationOnZ));
        axAB.setAxisCoordinate3D(Location3DImpl.create(dYAxisLocationOnX, dZAxisLocation, 0.0));
    }

    protected final DataSetIterator getAncillaryDataSet(Axis ax, Axis orthogonalAxis, int iType) throws ChartException, IllegalArgumentException {
        Series[] sea = ax.getRuntimeSeries();
        Series[] osea = orthogonalAxis.getRuntimeSeries();
        if (sea.length == 0 || osea.length == 0) {
            if ((iType & 1) == 1) {
                return new DataSetIterator(new Double[]{new Double(1.0), new Double(2.0)});
            }
            if ((iType & 8) == 8) {
                return new DataSetIterator(new Calendar[]{new CDateTime(), new CDateTime()});
            }
            if ((iType & 0x10) == 16) {
                ArrayList<String> data = new ArrayList<String>();
                int i = 0;
                while (i < osea.length) {
                    data.add(String.valueOf(osea[i].getSeriesIdentifier()));
                    ++i;
                }
                return new DataSetIterator(data.toArray(new String[data.size()]));
            }
        }
        DataSetIterator dsi = this.getTypedDataSet(sea[0], iType);
        ArrayList<Object> data = new ArrayList<Object>();
        int i = 0;
        while (i < osea.length) {
            if (dsi.hasNext()) {
                data.add(dsi.next());
            } else if ((iType & 1) == 1) {
                data.add(new Double(0.0));
            } else if ((iType & 8) == 8) {
                data.add((Object)new CDateTime());
            } else if ((iType & 0x10) == 16) {
                data.add(osea[i].getSeriesIdentifier());
            }
            ++i;
        }
        if ((iType & 1) == 1) {
            return new DataSetIterator(NumberDataSetImpl.create(data));
        }
        if ((iType & 8) == 8) {
            return new DataSetIterator(DateTimeDataSetImpl.create(data));
        }
        if ((iType & 0x10) == 16) {
            return new DataSetIterator(TextDataSetImpl.create(data));
        }
        return null;
    }

    private final Object getMinMax(Axis ax, int iType) throws ChartException, IllegalArgumentException {
        Series[] sea = ax.getRuntimeSeries();
        int iSeriesCount = sea.length;
        Object oMin = null;
        Object oMax = null;
        PluginSettings ps = PluginSettings.instance();
        IDataSetProcessor iDSP = null;
        int i = 0;
        while (i < iSeriesCount) {
            if (sea[i].isStacked()) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.unstackable.is.stacked"), sea[i]));
            }
            iDSP = ps.getDataSetProcessor(sea[i].getClass());
            DataSet ds = sea[i].getDataSet();
            Object oV1 = iDSP.getMinimum(ds);
            Object oV2 = iDSP.getMaximum(ds);
            if ((iType & 1) == 1) {
                if (oV1 != null) {
                    if (oMin == null) {
                        oMin = oV1;
                    } else {
                        double dV1 = PlotWith3DAxes.asDouble(oV1);
                        if (Math.min(PlotWith3DAxes.asDouble(oMin), dV1) == dV1) {
                            oMin = oV1;
                        }
                    }
                }
                if (oV2 != null) {
                    if (oMax == null) {
                        oMax = oV2;
                    } else {
                        double dV2 = PlotWith3DAxes.asDouble(oV2);
                        if (Math.max(PlotWith3DAxes.asDouble(oMax), dV2) == dV2) {
                            oMax = oV2;
                        }
                    }
                }
            } else if ((iType & 8) == 8) {
                if (oV1 != null) {
                    if (oMin == null) {
                        oMin = oV1;
                    } else {
                        CDateTime cdtMin;
                        CDateTime cdtV1 = PlotWith3DAxes.asDateTime(oV1);
                        if (cdtV1.before((Object)(cdtMin = PlotWith3DAxes.asDateTime(oMin)))) {
                            oMin = cdtV1;
                        }
                    }
                }
                if (oV2 != null) {
                    if (oMax == null) {
                        oMax = oV2;
                    } else {
                        CDateTime cdtMax;
                        CDateTime cdtV2 = PlotWith3DAxes.asDateTime(oV2);
                        if (cdtV2.after((Object)(cdtMax = PlotWith3DAxes.asDateTime(oMax)))) {
                            oMax = cdtV2;
                        }
                    }
                }
            }
            ++i;
        }
        if (ax.isPercent()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.no.stack.percent.3D.chart"), ax));
        }
        if (oMin == null && oMax == null) {
            if (iType == 8) {
                int year = Calendar.getInstance().get(1);
                oMin = new CDateTime(year, 1, 1);
                oMax = new CDateTime(year, 12, 31);
            } else if ((iType & 1) == 1) {
                if ((iType & 0x20) == 32) {
                    oMin = new Double(0.0);
                    oMax = new Double(99.99);
                } else if ((iType & 4) == 4) {
                    oMin = new Double(1.0);
                    oMax = new Double(999.0);
                } else {
                    oMin = new Double(-0.9);
                    oMax = new Double(0.9);
                }
            }
        }
        if (iType == 8) {
            try {
                return new Calendar[]{PlotWith3DAxes.asDateTime(oMin), PlotWith3DAxes.asDateTime(oMax)};
            }
            catch (ClassCastException classCastException) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.numerical.data.datetime.axis", Messages.getResourceBundle(this.rtc.getULocale()));
            }
        }
        if ((iType & 1) == 1) {
            try {
                return new double[]{PlotWith3DAxes.asDouble(oMin), PlotWith3DAxes.asDouble(oMax)};
            }
            catch (ClassCastException classCastException) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.datetime.data.numerical.axis", Messages.getResourceBundle(this.rtc.getULocale()));
            }
        }
        return null;
    }

    public ISeriesRenderingHints getSeriesRenderingHints(SeriesDefinition sdOrthogonal, Series seOrthogonal) throws ChartException, IllegalArgumentException {
        block66: {
            block65: {
                if (seOrthogonal == null) break block65;
                Class<?> clazz = seOrthogonal.getClass();
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.birt.chart.model.component.impl.SeriesImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz != clazz2) break block66;
            }
            return null;
        }
        OneAxis oaxOrthogonal = this.findOrthogonalAxis(seOrthogonal);
        if (oaxOrthogonal == null) {
            throw new ChartException("org.eclipse.birt.chart.engine", 6, "exception.axis.series.link.broken", new Object[]{seOrthogonal}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        OneAxis oaxBase = this.aax.getPrimaryBase();
        SeriesDefinition sdBase = (SeriesDefinition)oaxBase.getModelAxis().getSeriesDefinitions().get(0);
        OneAxis oaxAncillaryBase = this.aax.getAncillaryBase();
        AutoScale scBase = oaxBase.getScale();
        AutoScale scOrthogonal = oaxOrthogonal.getScale();
        AutoScale scAncillary = oaxAncillaryBase.getScale();
        int iXTickCount = scBase.getTickCount();
        int iZTickCount = scAncillary.getTickCount();
        double dXUnitSize = scBase.getUnitSize();
        double dZUnitSize = scAncillary.getUnitSize();
        boolean bZCategoryTextStyle = scAncillary.isCategoryScale() || scAncillary.getType() == 16;
        AxisTickCoordinates daXTickCoordinates = scBase.getTickCordinates();
        AxisTickCoordinates daZTickCoordinates = scAncillary.getTickCordinates();
        Object oDataBase = null;
        DataSetIterator dsiDataBase = scBase.getData();
        DataSetIterator dsiDataOrthogonal = this.getTypedDataSet(seOrthogonal, oaxOrthogonal.getScale().getType());
        DataSetIterator dsiDataAncillary = scAncillary.getData();
        double dOrthogonalZero = 0.0;
        dOrthogonalZero = (scOrthogonal.getType() & 1) == 1 ? PlotWith3DAxes.getLocation(scOrthogonal, 0.0) : (oaxOrthogonal.isTickBwtweenCategories() ? scOrthogonal.getStart() : scOrthogonal.getStart() + scOrthogonal.getStartShift());
        double dAncillaryZero = 0.0;
        dAncillaryZero = (scAncillary.getType() & 1) == 1 ? PlotWith3DAxes.getLocation(scAncillary, 0.0) : (oaxAncillaryBase.isTickBwtweenCategories() ? scAncillary.getStart() : scAncillary.getStart() + scAncillary.getStartShift());
        double dX = 0.0;
        double dY = 0.0;
        double dZ = 0.0;
        double dXLength = 0.0;
        double dZLength = 0.0;
        int iBaseCount = dsiDataBase.size();
        int iOrthogonalCount = dsiDataOrthogonal.size();
        DataPointHints[] dpa = null;
        int seriesIndex = 0;
        Series[] rss = oaxOrthogonal.getModelAxis().getRuntimeSeries();
        int i = 0;
        while (i < rss.length) {
            if (rss[i] == seOrthogonal) {
                seriesIndex = i;
                break;
            }
            ++i;
        }
        Object oDataAncillary = null;
        int i2 = 0;
        while (i2 < seriesIndex) {
            if (dsiDataAncillary.hasNext()) {
                dsiDataAncillary.next();
            }
            ++i2;
        }
        if (dsiDataAncillary.hasNext()) {
            oDataAncillary = dsiDataAncillary.next();
        }
        if (iBaseCount != iOrthogonalCount) {
            logger.log(1, Messages.getString("exception.base.orthogonal.inconsistent.count", new Object[]{new Integer(iBaseCount), new Integer(iOrthogonalCount)}, this.rtc.getULocale()));
        } else {
            dpa = new DataPointHints[iBaseCount];
            boolean bScatter = oaxBase.getScale().getType() != 16 && !oaxBase.isCategoryScale();
            FormatSpecifier fsSDAncillary = null;
            if (oaxAncillaryBase.getModelAxis().getSeriesDefinitions().size() > 0) {
                fsSDAncillary = ((SeriesDefinition)oaxAncillaryBase.getModelAxis().getSeriesDefinitions().get(0)).getFormatSpecifier();
            }
            DataPoint dp = seOrthogonal.getDataPoint();
            EList el = dp.getComponents();
            FormatSpecifier fsBase = null;
            FormatSpecifier fsOrthogonal = null;
            FormatSpecifier fsSeries = null;
            FormatSpecifier fsPercentile = null;
            int i3 = 0;
            while (i3 < el.size()) {
                DataPointComponent dpc = (DataPointComponent)el.get(i3);
                DataPointComponentType dpct = dpc.getType();
                if (dpct == DataPointComponentType.BASE_VALUE_LITERAL) {
                    fsBase = dpc.getFormatSpecifier();
                    if (fsBase == null) {
                        fsBase = sdBase.getFormatSpecifier();
                    }
                } else if (dpct == DataPointComponentType.ORTHOGONAL_VALUE_LITERAL) {
                    fsOrthogonal = dpc.getFormatSpecifier();
                    if (fsOrthogonal == null && seOrthogonal.eContainer() instanceof SeriesDefinition) {
                        fsOrthogonal = ((SeriesDefinition)seOrthogonal.eContainer()).getFormatSpecifier();
                    }
                } else if (dpct == DataPointComponentType.SERIES_VALUE_LITERAL) {
                    fsSeries = dpc.getFormatSpecifier();
                    if (fsSeries == null) {
                        fsSeries = fsSDAncillary;
                    }
                } else if (dpct == DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL) {
                    fsPercentile = dpc.getFormatSpecifier();
                }
                ++i3;
            }
            dsiDataBase.reset();
            dsiDataOrthogonal.reset();
            UserDataSetHints udsh = new UserDataSetHints(seOrthogonal.getDataSets());
            udsh.reset();
            double total = 0.0;
            boolean isZeroValue = true;
            int i4 = 0;
            while (i4 < iOrthogonalCount) {
                Object v = dsiDataOrthogonal.next();
                if (v instanceof Number) {
                    if (((Number)v).doubleValue() != 0.0) {
                        isZeroValue = false;
                    }
                    total += ((Number)v).doubleValue();
                } else if (v instanceof NumberDataElement) {
                    if (((NumberDataElement)v).getValue() != 0.0) {
                        isZeroValue = false;
                    }
                    total += ((NumberDataElement)v).getValue();
                }
                ++i4;
            }
            dsiDataOrthogonal.reset();
            i4 = 0;
            while (i4 < iBaseCount) {
                oDataBase = dsiDataBase.next();
                Object oDataOrthogonal = dsiDataOrthogonal.next();
                if (!bScatter) {
                    if (this.aax.areAxesSwapped()) {
                        dY = daXTickCoordinates.getStart() + dXUnitSize * (double)i4;
                        if (bZCategoryTextStyle) {
                            dZ = daZTickCoordinates.getStart() + dZUnitSize * (double)seriesIndex;
                            if (!scAncillary.isTickBetweenCategories()) {
                                dZ += dZUnitSize / 2.0;
                            }
                        } else {
                            try {
                                dZ = PlotWith3DAxes.getLocation(scAncillary, oDataAncillary);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                dZ = dAncillaryZero;
                            }
                            catch (ChartException chartException) {
                                dZ = dAncillaryZero;
                            }
                        }
                        try {
                            dX = PlotWith3DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            dX = dOrthogonalZero;
                        }
                        catch (ChartException chartException) {
                            dX = dOrthogonalZero;
                        }
                    } else {
                        dX = daXTickCoordinates.getStart() + dXUnitSize * (double)i4;
                        if (!oaxBase.isTickBwtweenCategories()) {
                            dX += dXUnitSize / 2.0;
                        }
                        if (bZCategoryTextStyle) {
                            dZ = daZTickCoordinates.getStart() + dZUnitSize * (double)seriesIndex;
                            if (!scAncillary.isTickBetweenCategories()) {
                                dZ += dZUnitSize / 2.0;
                            }
                        } else {
                            try {
                                dZ = PlotWith3DAxes.getLocation(scAncillary, oDataAncillary);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                dZ = dAncillaryZero;
                            }
                            catch (ChartException chartException) {
                                dZ = dAncillaryZero;
                            }
                        }
                        try {
                            dY = PlotWith3DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            dY = dOrthogonalZero;
                        }
                        catch (ChartException chartException) {
                            dY = dOrthogonalZero;
                        }
                    }
                } else {
                    throw new ChartException("org.eclipse.birt.chart.engine", 15, "exception.scatter.3D.not.supported", Messages.getResourceBundle(this.rtc.getULocale()));
                }
                Location3D lo3d = Location3DImpl.create(dX, dY, dZ);
                dXLength = i4 < iXTickCount - 1 ? daXTickCoordinates.getCoordinate(i4 + 1) - daXTickCoordinates.getCoordinate(i4) : 0.0;
                dZLength = seriesIndex < iZTickCount - 1 ? daZTickCoordinates.getCoordinate(seriesIndex + 1) - daZTickCoordinates.getCoordinate(seriesIndex) : 0.0;
                Double percentileValue = null;
                if (total != 0.0) {
                    if (oDataOrthogonal instanceof Number) {
                        percentileValue = new Double(((Number)oDataOrthogonal).doubleValue() / total);
                    } else if (oDataOrthogonal instanceof NumberDataElement) {
                        percentileValue = new Double(((NumberDataElement)oDataOrthogonal).getValue() / total);
                    }
                } else if (isZeroValue) {
                    percentileValue = new Double(1.0 / (double)iOrthogonalCount);
                }
                dpa[i4] = new DataPointHints(oDataBase, oDataOrthogonal, oDataAncillary, (Object)percentileValue, seOrthogonal.getDataPoint(), fsBase, fsOrthogonal, fsSeries, fsPercentile, i4, (Location)lo3d, new double[]{dXLength, dZLength}, this.rtc);
                udsh.next(dpa[i4]);
                ++i4;
            }
        }
        return new SeriesRenderingHints3D(this, oaxBase.getAxisCoordinate(), oaxAncillaryBase.getAxisCoordinate(), scOrthogonal.getStart(), dOrthogonalZero, scOrthogonal.getEnd() - scOrthogonal.getStart(), daXTickCoordinates, daZTickCoordinates, dpa, scBase, scOrthogonal, scAncillary, dsiDataBase, dsiDataOrthogonal, dsiDataAncillary);
    }

    void buildAxes() throws IllegalArgumentException, ChartException {
        Axis[] axa = this.cwa.getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        if (!axPrimaryBase.isSetOrientation()) {
            axPrimaryBase.setOrientation(Orientation.HORIZONTAL_LITERAL);
        }
        this.validateAxis(axPrimaryBase);
        Axis axPrimaryOrthogonal = this.cwa.getPrimaryOrthogonalAxis(axPrimaryBase);
        if (!axPrimaryOrthogonal.isSetOrientation()) {
            axPrimaryOrthogonal.setOrientation(Orientation.VERTICAL_LITERAL);
        }
        this.validateAxis(axPrimaryOrthogonal);
        Axis axAncillaryBase = this.cwa.getAncillaryBaseAxis(axPrimaryBase);
        axAncillaryBase.setOrientation(Orientation.HORIZONTAL_LITERAL);
        this.validateAxis(axAncillaryBase);
        if (axPrimaryBase.getAssociatedAxes().size() > 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 15, "exception.multi.orthogonal.3D.not.supported", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        this.aax = new AllAxes(null);
        this.insCA = this.aax.getInsets();
        this.aax.swapAxes(this.cwa.isTransposed());
        OneAxis oaxPrimaryBase = new OneAxis(axPrimaryBase, 5);
        oaxPrimaryBase.set(this.getOrientation(1), this.transposeLabelPosition(1, PlotWith3DAxes.getLabelPosition(axPrimaryBase.getLabelPosition())), this.transposeLabelPosition(1, PlotWith3DAxes.getLabelPosition(axPrimaryBase.getTitlePosition())), axPrimaryBase.isSetCategoryAxis() && axPrimaryBase.isCategoryAxis(), axPrimaryBase.getScale().isTickBetweenCategories());
        oaxPrimaryBase.setGridProperties(axPrimaryBase.getMajorGrid().getLineAttributes(), axPrimaryBase.getMinorGrid().getLineAttributes(), axPrimaryBase.getMajorGrid().getTickAttributes(), axPrimaryBase.getMinorGrid().getTickAttributes(), this.transposeTickStyle(1, PlotWith3DAxes.getTickStyle(axPrimaryBase, 0)), this.transposeTickStyle(1, PlotWith3DAxes.getTickStyle(axPrimaryBase, 1)), axPrimaryBase.getScale().getMinorGridsPerUnit());
        oaxPrimaryBase.set(axPrimaryBase.getLabel(), axPrimaryBase.getTitle());
        oaxPrimaryBase.set(PlotWith3DAxes.getIntersection(axPrimaryBase));
        oaxPrimaryBase.set(axPrimaryBase.getLineAttributes());
        this.aax.definePrimary(oaxPrimaryBase);
        OneAxis oaxPrimaryOrthogonal = new OneAxis(axPrimaryOrthogonal, 9);
        oaxPrimaryOrthogonal.set(this.getOrientation(2), this.transposeLabelPosition(2, PlotWith3DAxes.getLabelPosition(axPrimaryOrthogonal.getLabelPosition())), this.transposeLabelPosition(2, PlotWith3DAxes.getLabelPosition(axPrimaryOrthogonal.getTitlePosition())), axPrimaryOrthogonal.isSetCategoryAxis() && axPrimaryOrthogonal.isCategoryAxis(), axPrimaryOrthogonal.getScale().isTickBetweenCategories());
        oaxPrimaryOrthogonal.setGridProperties(axPrimaryOrthogonal.getMajorGrid().getLineAttributes(), axPrimaryOrthogonal.getMinorGrid().getLineAttributes(), axPrimaryOrthogonal.getMajorGrid().getTickAttributes(), axPrimaryOrthogonal.getMinorGrid().getTickAttributes(), this.transposeTickStyle(2, PlotWith3DAxes.getTickStyle(axPrimaryOrthogonal, 0)), this.transposeTickStyle(2, PlotWith3DAxes.getTickStyle(axPrimaryOrthogonal, 1)), axPrimaryOrthogonal.getScale().getMinorGridsPerUnit());
        oaxPrimaryOrthogonal.set(axPrimaryOrthogonal.getLabel(), axPrimaryOrthogonal.getTitle());
        oaxPrimaryOrthogonal.set(PlotWith3DAxes.getIntersection(axPrimaryOrthogonal));
        oaxPrimaryOrthogonal.set(axPrimaryOrthogonal.getLineAttributes());
        this.aax.definePrimary(oaxPrimaryOrthogonal);
        OneAxis oaxAncillaryBase = new OneAxis(axAncillaryBase, 17);
        oaxAncillaryBase.set(0, PlotWith3DAxes.getLabelPosition(axAncillaryBase.getLabelPosition()), PlotWith3DAxes.getLabelPosition(axAncillaryBase.getTitlePosition()), axAncillaryBase.isSetCategoryAxis() && axAncillaryBase.isCategoryAxis(), axAncillaryBase.getScale().isTickBetweenCategories());
        oaxAncillaryBase.setGridProperties(axAncillaryBase.getMajorGrid().getLineAttributes(), axAncillaryBase.getMinorGrid().getLineAttributes(), axAncillaryBase.getMajorGrid().getTickAttributes(), axAncillaryBase.getMinorGrid().getTickAttributes(), PlotWith3DAxes.getTickStyle(axAncillaryBase, 0), PlotWith3DAxes.getTickStyle(axAncillaryBase, 1), axAncillaryBase.getScale().getMinorGridsPerUnit());
        oaxAncillaryBase.set(axAncillaryBase.getLabel(), axAncillaryBase.getTitle());
        oaxAncillaryBase.set(PlotWith3DAxes.getIntersection(axAncillaryBase));
        oaxAncillaryBase.set(axAncillaryBase.getLineAttributes());
        this.aax.defineAncillaryBase(oaxAncillaryBase);
    }
}

