/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.DeferredCache;

public final class DeferredCacheManager {
    private final IDeviceRenderer fDeviceRenderer;
    private final Chart fChart;
    private DeferredCache fFirstDC;
    private DeferredCache fLastDC;
    private DeferredCache fSingleDC;
    private final List fDeferredCacheList = new ArrayList();

    public DeferredCacheManager(IDeviceRenderer idr, Chart chart) {
        this.fDeviceRenderer = idr;
        this.fChart = chart;
        this.fFirstDC = new DeferredCache(this.fDeviceRenderer, this.fChart);
        this.fLastDC = new DeferredCache(this.fDeviceRenderer, this.fChart);
    }

    public DeferredCache createDeferredCache(BaseRenderer br) {
        if (br != null && (2 == this.fChart.getDimension().getValue() || br.getSeries().isSingleCache())) {
            return this.createSingleDeferredCache();
        }
        return this.createDeferredCache();
    }

    DeferredCache createDeferredCache() {
        DeferredCache dc = new DeferredCache(this.fDeviceRenderer, this.fChart);
        this.fDeferredCacheList.add(dc);
        return dc;
    }

    DeferredCache createSingleDeferredCache() {
        if (this.fSingleDC != null) {
            return this.fSingleDC;
        }
        this.fSingleDC = new DeferredCache(this.fDeviceRenderer, this.fChart);
        this.fDeferredCacheList.add(this.fSingleDC);
        return this.fSingleDC;
    }

    public void flushAll() throws ChartException {
        int options = 51;
        this.flushOptions(options);
        this.flushMarkersNLabels();
        this.clearDC();
    }

    public void flushOptions(int options) throws ChartException {
        this.fFirstDC.flushOptions(options);
        Iterator iter = this.fDeferredCacheList.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof DeferredCache)) continue;
            ((DeferredCache)obj).flushOptions(options);
        }
        this.fLastDC.flushOptions(options);
    }

    void flushMarkersNLabels() throws ChartException {
        ArrayList allMarkers = new ArrayList();
        ArrayList allLabels = new ArrayList();
        this.getMarkersNLabels(allMarkers, allLabels);
        DeferredCache.flushMarkers(this.fDeviceRenderer, allMarkers);
        DeferredCache.flushLabels(this.fDeviceRenderer, allLabels);
    }

    public void getMarkersNLabels(List allMarkers, List allLabels) {
        allMarkers.addAll(this.fFirstDC.getAllMarkers());
        this.fFirstDC.getAllMarkers().clear();
        allLabels.addAll(this.fFirstDC.getAllLabels());
        this.fFirstDC.getAllLabels().clear();
        Iterator iter = this.fDeferredCacheList.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof DeferredCache) {
                allMarkers.addAll(((DeferredCache)obj).getAllMarkers());
                ((DeferredCache)obj).getAllMarkers().clear();
                allLabels.addAll(((DeferredCache)obj).getAllLabels());
                ((DeferredCache)obj).getAllLabels().clear();
                continue;
            }
            if (!(obj instanceof List)) continue;
            Collections.sort((List)obj);
            Iterator iter1 = ((List)obj).iterator();
            while (iter1.hasNext()) {
                DeferredCache dc = (DeferredCache)iter1.next();
                allMarkers.addAll(dc.getAllMarkers());
                dc.getAllMarkers().clear();
                allLabels.addAll(dc.getAllLabels());
                dc.getAllLabels().clear();
            }
        }
        allMarkers.addAll(this.fLastDC.getAllMarkers());
        this.fLastDC.getAllMarkers().clear();
        allLabels.addAll(this.fLastDC.getAllLabels());
        this.fLastDC.getAllLabels().clear();
    }

    public void clearDC() {
        this.fDeferredCacheList.clear();
        this.fFirstDC = null;
        this.fLastDC = null;
        this.fSingleDC = null;
    }

    public DeferredCache getFirstDeferredCache() {
        return this.fFirstDC;
    }

    public DeferredCache getLastDeferredCache() {
        return this.fLastDC;
    }
}

