/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.factory.ActionEvaluatorAdapter;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.SearchKeyHandle;

public class BIRTActionEvaluator
extends ActionEvaluatorAdapter {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public String[] getActionExpressions(Action action, StructureSource source) {
        TooltipValue tv;
        String exp;
        if (ActionType.URL_REDIRECT_LITERAL.equals(action.getType())) {
            URLValue uv = (URLValue)action.getValue();
            String sa = uv.getBaseUrl();
            try {
                ActionHandle handle = ModuleUtil.deserializeAction((String)sa);
                ArrayList<String> expList = new ArrayList<String>();
                if ("hyperlink".equals(handle.getLinkType())) {
                    String exp2 = handle.getURI();
                    if (!expList.contains(exp2)) {
                        expList.add(exp2);
                    }
                } else if ("bookmark-link".equals(handle.getLinkType())) {
                    String exp3 = handle.getTargetBookmark();
                    if (!expList.contains(exp3)) {
                        expList.add(exp3);
                    }
                } else if ("drill-through".equals(handle.getLinkType())) {
                    String exp4 = handle.getTargetBookmark();
                    if (exp4 != null && !expList.contains(exp4)) {
                        expList.add(exp4);
                    }
                    Iterator itr = handle.getSearch().iterator();
                    while (itr.hasNext()) {
                        SearchKeyHandle skh = (SearchKeyHandle)itr.next();
                        exp4 = skh.getExpression();
                        if (expList.contains(exp4)) continue;
                        expList.add(exp4);
                    }
                    itr = handle.getParamBindings().iterator();
                    while (itr.hasNext()) {
                        ParamBindingHandle pbh = (ParamBindingHandle)itr.next();
                        exp4 = pbh.getExpression();
                        if (expList.contains(exp4)) continue;
                        expList.add(exp4);
                    }
                }
                if (expList.size() > 0) {
                    return expList.toArray(new String[expList.size()]);
                }
            }
            catch (DesignFileException e) {
                logger.log((Exception)((Object)e));
            }
        } else if (ActionType.SHOW_TOOLTIP_LITERAL.equals(action.getType()) && StructureType.SERIES.equals(source.getType()) && (exp = (tv = (TooltipValue)action.getValue()).getText()) != null && exp.trim().length() > 0) {
            return new String[]{exp};
        }
        return null;
    }
}

