/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.data.engine.aggregation.SummaryAccumulator;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalMode
implements IAggregation {
    static /* synthetic */ Class class$0;

    public String getName() {
        return "MODE";
    }

    public int getType() {
        return 0;
    }

    public boolean[] getParameterDefn() {
        return new boolean[]{true};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    private class MyAccumulator
    extends SummaryAccumulator {
        private HashMap cacheMap;
        private HashMap modeMap;
        private Object mode;
        private int maxCount;
        private int rowIndex;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.aggregation.TotalMode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.rowIndex = 0;
            this.cacheMap = new HashMap();
            this.maxCount = 0;
            this.mode = null;
            this.modeMap = new HashMap();
        }

        public void onRow(Object[] args) throws DataException {
            if (!$assertionsDisabled && args.length <= 0) {
                throw new AssertionError();
            }
            if (args[0] != null) {
                Object value = this.getTypedData(args[0]);
                Counter counter = (Counter)this.cacheMap.get(value);
                if (counter == null) {
                    counter = new Counter(1, this.rowIndex);
                    this.cacheMap.put(value, counter);
                } else {
                    ++counter.count;
                }
                if (counter.count > this.maxCount) {
                    this.mode = value;
                    this.maxCount = counter.count;
                    this.modeMap.clear();
                    this.modeMap.put(value, counter);
                } else if (counter.count == this.maxCount) {
                    this.modeMap.put(value, counter);
                }
                ++this.rowIndex;
            }
        }

        public void finish() throws DataException {
            super.finish();
            this.cacheMap = null;
        }

        public Object getSummaryValue() {
            if (this.maxCount == 1) {
                return null;
            }
            if (!this.modeMap.isEmpty()) {
                int minIndex = Integer.MAX_VALUE;
                Iterator i = this.modeMap.keySet().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                    Counter info = (Counter)this.modeMap.get(key);
                    if (info.firstIndex >= minIndex) continue;
                    minIndex = info.firstIndex;
                    this.mode = key;
                }
                this.modeMap = null;
            }
            return this.mode;
        }

        class Counter {
            int count;
            int firstIndex;

            public Counter(int count, int firstIndex) {
                this.count = count;
                this.firstIndex = firstIndex;
            }
        }
    }
}

