/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Map;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.Md5Util;

public class CacheUtil {
    private static final String PATH_SEP;
    private static final String TEST_MEM_BUFFER_SIZE = "birt.data.engine.test.memcachesize";
    private static final String TIME_DATA = "time.data";
    private static final String PS_ = "PS_";
    private static Integer cacheCounter1;
    private static Integer cacheCounter2;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.cache.CacheUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        PATH_SEP = File.separator;
        cacheCounter1 = new Integer(0);
        cacheCounter2 = new Integer(0);
    }

    private CacheUtil() {
    }

    public static int computeMemoryBufferSize(Map appContext) {
        if (appContext == null) {
            return 0x5000000;
        }
        if (appContext.get(TEST_MEM_BUFFER_SIZE) != null) {
            return CacheUtil.populateMemBufferSize(appContext.get(TEST_MEM_BUFFER_SIZE));
        }
        return CacheUtil.populateMemBufferSize(appContext.get(DataEngine.MEMORY_BUFFER_SIZE)) * 1024 * 1024 * 8;
    }

    private static int populateMemBufferSize(Object propValue) {
        String targetBufferSize = propValue == null ? "10" : propValue.toString();
        int memoryCacheSize = 10;
        if (targetBufferSize != null) {
            memoryCacheSize = Integer.parseInt(targetBufferSize);
        }
        return memoryCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createTempRootDir(String tempDir) {
        String rootDirStr = null;
        File tempDtEDir = null;
        Integer n = cacheCounter1;
        synchronized (n) {
            tempDtEDir = new File(tempDir, "BirtDataTemp" + System.currentTimeMillis() + cacheCounter1);
            cacheCounter1 = new Integer(cacheCounter1 + 1);
            int x = 0;
            while (tempDtEDir.exists()) {
                tempDtEDir = new File(tempDir, "BirtDataTemp" + System.currentTimeMillis() + cacheCounter1 + "_" + ++x);
            }
            tempDtEDir.mkdir();
            tempDtEDir.deleteOnExit();
        }
        rootDirStr = CacheUtil.getCanonicalPath(tempDtEDir);
        return rootDirStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createSessionTempDir(String tempRootDir) {
        File sessionFile = null;
        Integer n = cacheCounter2;
        synchronized (n) {
            String sessionTempDir = String.valueOf(tempRootDir) + File.separator + "session_" + System.currentTimeMillis() + cacheCounter2;
            cacheCounter2 = new Integer(cacheCounter2 + 1);
            sessionFile = new File(sessionTempDir);
            int i = 0;
            while (sessionFile.exists() || !sessionFile.mkdir()) {
                sessionTempDir = String.valueOf(sessionTempDir) + "_" + ++i;
                sessionFile = new File(sessionTempDir);
            }
            sessionFile.deleteOnExit();
        }
        return CacheUtil.getCanonicalPath(sessionFile);
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static String createIncrementalTempDir(String tempDir, String configFilePath, String dataSetName) {
        File cacheDir = new File(String.valueOf(tempDir) + PATH_SEP + PS_ + PATH_SEP + Md5Util.getMD5(configFilePath) + PATH_SEP + dataSetName);
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        return CacheUtil.getCanonicalPath(cacheDir);
    }

    public static String getLastTime(String folder) throws DataException {
        File file;
        block5: {
            file = new File(String.valueOf(folder) + PATH_SEP + TIME_DATA);
            if (file.exists()) break block5;
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            String lastTime = (String)ois.readObject();
            fis.close();
            ois.close();
            return lastTime;
        }
        catch (IOException e) {
            throw new DataException("data.engine.datasetcache.save.error", e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public static void saveCurrentTime(String folder) throws DataException {
        try {
            FileOutputStream fos = new FileOutputStream(new File(String.valueOf(folder) + PATH_SEP + TIME_DATA));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            Calendar calendar = Calendar.getInstance();
            StringBuffer buffer = new StringBuffer();
            buffer.append(CacheUtil.populate2DigitString(calendar.get(1)));
            buffer.append(CacheUtil.populate2DigitString(calendar.get(2) + 1));
            buffer.append(CacheUtil.populate2DigitString(calendar.get(5)));
            if (calendar.get(9) == 1) {
                buffer.append(CacheUtil.populate2DigitString(calendar.get(10) + 12));
            }
            buffer.append(CacheUtil.populate2DigitString(calendar.get(12)));
            buffer.append(CacheUtil.populate2DigitString(calendar.get(13)));
            oos.writeObject(buffer.toString());
            fos.close();
            oos.close();
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }

    private static String populate2DigitString(int value) {
        if (value < 10) {
            return "0" + value;
        }
        return String.valueOf(value);
    }

    public static long getLastTimestamp(String folder) throws DataException {
        try {
            RandomAccessFile raf = new RandomAccessFile(String.valueOf(folder) + PATH_SEP + "timestamp.data", "r");
            long timestamp = raf.readLong();
            raf.close();
            return timestamp;
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    public static void saveCurrentTimestamp(String folder) throws DataException {
        try {
            RandomAccessFile raf = new RandomAccessFile(String.valueOf(folder) + PATH_SEP + "timestamp.data", "rw");
            Calendar calendar = Calendar.getInstance();
            raf.writeLong(calendar.getTimeInMillis());
            raf.close();
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }
}

