/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.DiskDataExport;
import org.eclipse.birt.data.engine.executor.cache.disk.IRowIterator;
import org.eclipse.birt.data.engine.executor.cache.disk.MergeSortInfo;
import org.eclipse.birt.data.engine.executor.cache.disk.MergeSortUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.SortDataProvider;
import org.eclipse.birt.data.engine.odi.IResultObject;

class DiskSortExport
extends DiskDataExport {
    private int dataCountOfUnit;
    private int dataCountOfTotal;
    private SortDataProvider dataProvider;
    private MergeSortUtil mergeSortUti;

    DiskSortExport(Map infoMap, Comparator comparator, ResultObjectUtil resultObjectUtil) {
        this.dataCountOfUnit = Integer.parseInt((String)infoMap.get("dataCountOfUnit"));
        this.dataProvider = new SortDataProvider(this.dataCountOfUnit, (String)infoMap.get("tempDir"), (String)infoMap.get("goalFile"), resultObjectUtil);
        this.mergeSortUti = MergeSortUtil.getUtil(comparator);
    }

    public void exportStartDataToDisk(IResultObject[] resultObjects) throws IOException {
        this.dataCountOfTotal = this.innerExportStartData(resultObjects);
    }

    public int exportRestDataToDisk(IResultObject resultObject, IRowResultSet rs) throws DataException, IOException {
        int dataCountOfRest = this.innerExportRestData(resultObject, rs, this.dataCountOfUnit);
        this.dataCountOfTotal += dataCountOfRest;
        this.dataProvider.initForMerge(this.dataCountOfTotal);
        this.mergeSortOnUnits(this.getMergeCount());
        this.dataProvider.end();
        return dataCountOfRest;
    }

    public IRowIterator getRowIterator() {
        return null;
    }

    public void close() {
    }

    protected void outputResultObjects(IResultObject[] resultObjects, int indexOfUnit) throws IOException {
        this.mergeSortUti.sortSelf(resultObjects);
        this.dataProvider.writeData(0, indexOfUnit * this.dataCountOfUnit, resultObjects, resultObjects.length);
    }

    private int getMergeCount() {
        int mergeCount = this.dataCountOfTotal / this.dataCountOfUnit;
        if (this.dataCountOfTotal % this.dataCountOfUnit != 0) {
            ++mergeCount;
        }
        if (this.dataCountOfUnit < mergeCount) {
            throw new IllegalArgumentException("the dataCountOfUnit of " + this.dataCountOfUnit + " is less than the merge count of " + mergeCount + ", and then merge sort on file can not be done");
        }
        return mergeCount;
    }

    private void mergeSortOnUnits(int mergeCount) throws IOException {
        int[] startIndexArray = new int[mergeCount];
        int[] endIndexArray = new int[mergeCount];
        int i = 0;
        while (i < mergeCount) {
            startIndexArray[i] = i == 0 ? 0 : endIndexArray[i - 1];
            endIndexArray[i] = startIndexArray[i] + this.dataCountOfUnit;
            if (endIndexArray[i] > this.dataCountOfTotal) {
                endIndexArray[i] = this.dataCountOfTotal;
            }
            ++i;
        }
        int[] tempBeginIndex = new int[mergeCount];
        int i2 = 0;
        while (i2 < mergeCount) {
            tempBeginIndex[i2] = startIndexArray[i2];
            ++i2;
        }
        int currData = 0;
        int totalData = endIndexArray[mergeCount - 1] - startIndexArray[0];
        IResultObject[][] resultObjects = new IResultObject[mergeCount][];
        int dataCountOfMergeUnit = this.dataCountOfUnit / mergeCount;
        while (currData < totalData) {
            int i3 = 0;
            while (i3 < mergeCount) {
                int tempEndIndex = tempBeginIndex[i3] + dataCountOfMergeUnit;
                if (tempEndIndex > endIndexArray[i3]) {
                    tempEndIndex = endIndexArray[i3];
                }
                resultObjects[i3] = this.dataProvider.readData(tempBeginIndex[i3], tempEndIndex);
                ++i3;
            }
            int length = 0;
            int i4 = 0;
            while (i4 < mergeCount) {
                length += resultObjects[i4].length;
                ++i4;
            }
            IResultObject[] mergedRowDatas = new IResultObject[length];
            MergeSortInfo mergeInfo = this.mergeSortUti.mergeSort(resultObjects, mergedRowDatas);
            this.dataProvider.writeData(1, currData, mergedRowDatas, mergeInfo.getDataCountOfTotal());
            int i5 = 0;
            while (i5 < mergeCount) {
                int n = i5;
                tempBeginIndex[n] = tempBeginIndex[n] + mergeInfo.getDataCountOfUnit(i5);
                ++i5;
            }
            currData += mergeInfo.getDataCountOfTotal();
        }
    }
}

