/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.transform.OrderingInfo;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInstanceSorter;
import org.eclipse.birt.data.engine.executor.transform.group.GroupProcessorManager;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.mozilla.javascript.Context;

public class GroupWithIntervalsProcessor {
    private ResultSetPopulator populator;
    private GroupProcessorManager groupProcessor;
    private GroupInstanceSorter giSorter;

    GroupWithIntervalsProcessor(GroupProcessorManager gp) {
        this.populator = gp.getResultSetPopulator();
        this.groupProcessor = gp;
        this.giSorter = new GroupInstanceSorter(this.groupProcessor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processGroupWithIntervals(ResultSetCache rsCache, IQuery.GroupSpec[] groups) throws DataException {
        this.populator.setCache(rsCache);
        List leveledGroup = this.populateLeveledGroups(groups);
        if (leveledGroup.size() <= 0) return;
        Context cx = Context.enter();
        try {
            this.groupProcessor.getGroupCalculationUtil().getQuery().setGrouping(null);
            int i = 0;
            while (i < leveledGroup.size() - 1) {
                IQuery.GroupSpec immediatelyNextGroupSpec = ((IQuery.GroupSpec[])leveledGroup.get(i + 1))[0];
                SortDefinition sd = new SortDefinition();
                if (immediatelyNextGroupSpec.getKeyColumn() != null) {
                    sd.setExpression(ExpressionUtil.createJSDataSetRowExpression((String)immediatelyNextGroupSpec.getKeyColumn()));
                } else {
                    sd.setExpression("dataSetRow[\"" + immediatelyNextGroupSpec.getKeyIndex() + "\"]");
                }
                ArrayList<SortDefinition> sorts = new ArrayList<SortDefinition>();
                sorts.add(sd);
                immediatelyNextGroupSpec.setSorts(sorts);
                ArrayList<IQuery.GroupSpec> tempGroups = new ArrayList<IQuery.GroupSpec>();
                int k = 0;
                while (k < leveledGroup.size()) {
                    IQuery.GroupSpec[] tempGroupsArray = (IQuery.GroupSpec[])leveledGroup.get(k);
                    int j = 0;
                    while (j < tempGroupsArray.length) {
                        tempGroups.add(tempGroupsArray[j]);
                        ++j;
                    }
                    ++k;
                }
                this.groupProcessor.getGroupCalculationUtil().getQuery().setGrouping(tempGroups);
                this.populator.getCache().next();
                ArrayList groupLevels = new ArrayList();
                ArrayList expressionList = new ArrayList();
                this.giSorter.populateGroupSortExpressions(expressionList, groupLevels);
                this.groupProcessor.calculateExpressionList(expressionList, groupLevels, 4);
                List[] groupArray = this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().getGroupBoundaryInfos();
                this.giSorter.populateGroupBoundaryInfosSortings(cx, groupArray);
                this.groupProcessor.getGroupCalculationUtil().sortGroupBoundaryInfos(groupArray);
                OrderingInfo odInfo = this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().getOrderingInfo(groupArray);
                this.populator.reSetCache(odInfo);
                immediatelyNextGroupSpec.setSorts(new ArrayList());
                this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().doGrouping();
                ++i;
            }
            this.groupProcessor.getGroupCalculationUtil().getQuery().setGrouping(this.getListFromArray(groups));
            Object var14_18 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    private List populateLeveledGroups(IQuery.GroupSpec[] groups) {
        ArrayList<IQuery.GroupSpec[]> leveledGroup = new ArrayList<IQuery.GroupSpec[]>();
        if (groups != null) {
            int last = -1;
            int i = 0;
            while (i < groups.length - 1) {
                if (groups[i].getInterval() != 0) {
                    IQuery.GroupSpec[] gs = this.getOneLevelOfGroupSpecs(groups, last, i);
                    last = i;
                    leveledGroup.add(gs);
                }
                ++i;
            }
            if (last > -1) {
                leveledGroup.add(this.getOneLevelOfGroupSpecs(groups, last, groups.length - 1));
            }
        }
        return leveledGroup;
    }

    private List getListFromArray(Object[] o) {
        ArrayList<Object> l = new ArrayList<Object>();
        if (o == null) {
            return l;
        }
        int i = 0;
        while (i < o.length) {
            l.add(o[i]);
            ++i;
        }
        return l;
    }

    private IQuery.GroupSpec[] getOneLevelOfGroupSpecs(IQuery.GroupSpec[] groups, int last, int i) {
        IQuery.GroupSpec[] gs = new IQuery.GroupSpec[i - last];
        int j = last + 1;
        while (j <= i) {
            IQuery.GroupSpec gps = new IQuery.GroupSpec(groups[j].getKeyIndex(), groups[j].getKeyColumn());
            gps.setDataType(groups[j].getDataType());
            gps.setInterval(groups[j].getInterval());
            gps.setIntervalRange(groups[j].getIntervalRange());
            gps.setIntervalStart(groups[j].getIntervalStart());
            gps.setIsComplexExpression(groups[j].isCompleteExpression());
            gps.setName(groups[j].getName());
            gps.setSortDirection(groups[j].getSortDirection());
            gs[j - last - 1] = gps;
            ++j;
        }
        return gs;
    }
}

