/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public final class ColumnReferenceExpression
extends CompiledExpression {
    private String m_columnName;
    private int m_columnIndex;
    private String rowIndicator = "row";
    private int dataType;
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.expression.ColumnReferenceExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.expression.ColumnReferenceExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    ColumnReferenceExpression(String rowInd, String columnName) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.expression.ColumnReferenceExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "ColumnReferenceExpression", columnName);
        if (!$assertionsDisabled && columnName == null && columnName.length() != 0) {
            throw new AssertionError();
        }
        this.m_columnName = columnName;
        this.m_columnIndex = -1;
        this.rowIndicator = rowInd;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.expression.ColumnReferenceExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "ColumnReferenceExpression");
        this.dataType = -1;
    }

    ColumnReferenceExpression(String rowInd, int columnIndex) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.expression.ColumnReferenceExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "ColumnReferenceExpression", new Integer(columnIndex));
        if (!$assertionsDisabled && columnIndex < 0) {
            throw new AssertionError();
        }
        this.m_columnIndex = columnIndex;
        this.rowIndicator = rowInd;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.expression.ColumnReferenceExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "ColumnReferenceExpression");
    }

    public int getType() {
        return 1;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public int getColumnindex() {
        return this.m_columnIndex;
    }

    public boolean isIndexed() {
        return this.m_columnIndex != -1;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ColumnReferenceExpression)) {
            return false;
        }
        ColumnReferenceExpression expr2 = (ColumnReferenceExpression)other;
        if (this.m_columnName != null) {
            return this.m_columnName.equals(expr2.m_columnName);
        }
        return this.m_columnIndex == expr2.m_columnIndex;
    }

    public int hashCode() {
        if (this.m_columnName != null) {
            return this.m_columnName.hashCode();
        }
        return this.m_columnIndex;
    }

    public Object evaluate(Context context, Scriptable scope) throws DataException {
        StringBuffer expr = new StringBuffer(String.valueOf(this.rowIndicator) + "[");
        if (this.isIndexed()) {
            expr.append(this.m_columnIndex);
        } else {
            expr.append('\"');
            expr.append(JavascriptEvalUtil.transformToJsConstants((String)this.m_columnName));
            expr.append('\"');
        }
        expr.append(']');
        try {
            return DataTypeUtil.convert((Object)ScriptEvalUtil.evaluateJSAsExpr(context, scope, expr.toString(), "ROM Expression", 0), (int)this.dataType);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    public void setDataType(int type) {
        this.dataType = type;
    }

    public int getDataType() {
        return this.dataType;
    }
}

