/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.impl.CachedQueryResults;
import org.eclipse.birt.data.engine.impl.DataEngineContextExt;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSourceManager;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.LogUtil;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedCubeQuery;
import org.eclipse.birt.data.engine.script.JSDataSources;
import org.mozilla.javascript.Scriptable;

public class DataEngineImpl
extends DataEngine {
    private HashMap dataSources = new HashMap();
    private HashMap dataSetDesigns = new HashMap();
    private Scriptable dataSourcesJSObject;
    private DataEngineContext context;
    private DataEngineSession session;
    private DataSourceManager dataSourceManager;
    private List shutdownListenerList = null;
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public DataEngineImpl(DataEngineContext context) {
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "DataEngineImpl", context);
        this.context = context;
        DataEngineContextExt.getInstance().setTmpdir(context.getTmpdir());
        this.dataSourceManager = new DataSourceManager(logger);
        this.session = new DataEngineSession(context, this);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "DataEngineImpl");
        logger.log(Level.INFO, "Data Engine starts up");
    }

    public DataEngineContext getContext() {
        return this.context;
    }

    public IQueryResults getQueryResults(String queryResultID) throws DataException {
        if (this.context.getMode() == 2) {
            return new QueryResults(this.context, queryResultID);
        }
        if (this.context.getMode() == 1 || this.context.getMode() == 3) {
            return new CachedQueryResults(this.context, queryResultID);
        }
        return null;
    }

    public void defineDataSource(IBaseDataSourceDesign dataSource) throws DataException {
        Object existingDefn;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "defineDataSource", dataSource == null ? null : dataSource.getName());
        if (dataSource == null) {
            NullPointerException e = new NullPointerException("dataSource param cannot be null");
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.WARNING, clazz2.getName(), "defineDataSource", "dataSource param cannot be null", e);
            throw e;
        }
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.WARNING, clazz3.getName(), "defineDataSource", "DataEngine has been shutdown", e);
            throw e;
        }
        String name = dataSource.getName();
        if (name == null || name.length() == 0) {
            IllegalArgumentException e = new IllegalArgumentException("Data source has no name");
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.WARNING, clazz4.getName(), "defineDataSource", "Data source has no name", e);
            throw e;
        }
        if (logger.isLoggable(Level.FINE)) {
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINE, clazz5.getName(), "defineDataSource", "DataEngine.defineDataSource: " + LogUtil.toString(dataSource));
        }
        if ((existingDefn = this.dataSources.get(dataSource.getName())) != null) {
            this.dataSourceManager.addDataSource((DataSourceRuntime)existingDefn);
        }
        DataSourceRuntime newDefn = DataSourceRuntime.newInstance(dataSource, this);
        this.dataSources.put(newDefn.getName(), newDefn);
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz6.getName(), "defineDataSource");
    }

    public void defineDataSet(IBaseDataSetDesign dataSet) throws DataException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "defineDataSet", dataSet == null ? null : dataSet.getName());
        if (dataSet == null) {
            NullPointerException e = new NullPointerException("dataSource param cannot be null");
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.WARNING, clazz2.getName(), "defineDataSet", "dataSource param cannot be null", e);
            throw e;
        }
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.WARNING, clazz3.getName(), "defineDataSet", "DataEngine has been shutdown", e);
            throw e;
        }
        String name = dataSet.getName();
        if (name == null || name.length() == 0) {
            IllegalArgumentException e = new IllegalArgumentException("Data source has no name");
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.WARNING, clazz4.getName(), "defineDataSet", "Data source has no name", e);
            throw e;
        }
        if (logger.isLoggable(Level.FINE)) {
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINE, clazz5.getName(), "defineDataSet", "DataEngine.defineDataSet: " + LogUtil.toString(dataSet));
        }
        if (!(dataSet instanceof IJointDataSetDesign)) {
            Class<?> dSourceClass;
            String dataSourceName = dataSet.getDataSourceName();
            DataSourceRuntime dsource = this.getDataSourceRuntime(dataSourceName);
            if (dsource == null) {
                DataException e = new DataException("data.engine.UndefinedDataSource", dataSourceName);
                Class<?> clazz6 = class$0;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.logp(Level.WARNING, clazz6.getName(), "defineDataSet", "Data source {" + dataSourceName + "} is not defined", (Throwable)((Object)e));
                throw e;
            }
            if (dataSet instanceof IOdaDataSetDesign) {
                Class<?> clazz7 = class$1;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$1 = Class.forName("org.eclipse.birt.data.engine.api.IOdaDataSourceDesign");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                dSourceClass = clazz7;
            } else if (dataSet instanceof IScriptDataSetDesign) {
                Class<?> clazz8 = class$2;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$2 = Class.forName("org.eclipse.birt.data.engine.api.IScriptDataSourceDesign");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                dSourceClass = clazz8;
            } else {
                DataException e = new DataException("data.engine.UnsupportedDataSetType");
                Class<?> clazz9 = class$0;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.logp(Level.WARNING, clazz9.getName(), "defineDataSet", "Unsupported data set type: " + dataSet.getName(), (Throwable)((Object)e));
                throw e;
            }
            if (!dSourceClass.isInstance(dsource.getDesign())) {
                DataException e = new DataException("data.engine.UnsupportedDataSourceType", dsource.getName());
                Class<?> clazz10 = class$0;
                if (clazz10 == null) {
                    try {
                        clazz10 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.logp(Level.WARNING, clazz10.getName(), "defineDataSet", "Unsupported data source type: " + dsource.getName(), (Throwable)((Object)e));
                throw e;
            }
        }
        this.dataSetDesigns.put(name, dataSet);
        Class<?> clazz11 = class$0;
        if (clazz11 == null) {
            try {
                clazz11 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz11.getName(), "defineDataSet");
    }

    public void clearCache(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        if (dataSource == null || dataSet == null) {
            return;
        }
        DataSetCacheManager dscManager = this.getSession().getDataSetCacheManager();
        if (dscManager == null) {
            return;
        }
        dscManager.clearCache(dataSource, dataSet);
    }

    DataSourceRuntime getDataSourceRuntime(String name) {
        return (DataSourceRuntime)this.dataSources.get(name);
    }

    IBaseDataSetDesign getDataSetDesign(String name) {
        return (IBaseDataSetDesign)this.dataSetDesigns.get(name);
    }

    public IPreparedQuery prepare(IQueryDefinition querySpec) throws DataException {
        return this.prepare(querySpec, null);
    }

    public IPreparedQuery prepare(IQueryDefinition querySpec, Map appContext) throws DataException {
        if (logger.isLoggable(Level.FINER)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.entering(clazz.getName(), "prepare", LogUtil.toString(querySpec));
        }
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.WARNING, clazz.getName(), "prepare", "DataEngine has been shutdown", e);
            throw e;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Start to prepare query: " + LogUtil.toString(querySpec));
        }
        IPreparedQuery result = PreparedQueryUtil.newInstance(this, querySpec, appContext);
        logger.fine("Finished preparing query.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz.getName(), "prepare");
        return result;
    }

    public void closeDataSource(String dataSourceName) throws DataException {
        Class<?> clazz;
        logger.entering("DataEngineImpl", "closeDataSource", dataSourceName);
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.WARNING, clazz2.getName(), "closeDataSource", "DataEngine has been shutdown", e);
            throw e;
        }
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz3.getName(), "closeDataSource", "Close DataSource :" + dataSourceName);
        DataSourceRuntime ds = this.getDataSourceRuntime(dataSourceName);
        if (ds != null) {
            DataEngineImpl.closeDataSource(ds);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz.getName(), "closeDataSource");
    }

    private static void closeDataSource(DataSourceRuntime ds) throws DataException {
        if (!$assertionsDisabled && ds == null) {
            throw new AssertionError();
        }
        if (ds.isOpen()) {
            ds.beforeClose();
            ds.closeOdiDataSource();
            ds.afterClose();
        }
    }

    public DataEngineSession getSession() {
        return this.session;
    }

    public void addShutdownListener(IShutdownListener listener) {
        if (this.shutdownListenerList == null) {
            this.shutdownListenerList = new ArrayList();
        }
        int i = 0;
        while (i < this.shutdownListenerList.size()) {
            if (listener == this.shutdownListenerList.get(i)) {
                return;
            }
            ++i;
        }
        this.shutdownListenerList.add(listener);
    }

    public void removeListener(IShutdownListener listener) {
        if (this.shutdownListenerList == null) {
            return;
        }
        int i = 0;
        while (i < this.shutdownListenerList.size()) {
            if (listener == this.shutdownListenerList.get(i)) {
                this.shutdownListenerList.remove(i);
                return;
            }
            ++i;
        }
    }

    public void shutdown() {
        logger.entering("DataEngineImpl", "shutdown");
        if (this.dataSources == null) {
            logger.fine("The data engine has already been shutdown");
            return;
        }
        if (this.shutdownListenerList != null) {
            int i = 0;
            while (i < this.shutdownListenerList.size()) {
                ((IShutdownListener)this.shutdownListenerList.get(i)).dataEngineShutdown();
                ++i;
            }
            this.shutdownListenerList.clear();
        }
        Collection col = this.dataSources.values();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            DataSourceRuntime ds = (DataSourceRuntime)it.next();
            try {
                DataEngineImpl.closeDataSource(ds);
            }
            catch (DataException e) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "The data source (" + ds + ") fails to shut down", (Throwable)((Object)e));
            }
        }
        this.dataSourceManager.close();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.INFO, clazz.getName(), "shutdown", "Data engine shuts down");
        this.dataSetDesigns = null;
        this.dataSources = null;
        this.clearTempFile();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "shutdown");
    }

    private void clearTempFile() {
        File tmpDir = new File(String.valueOf(this.context.getTmpdir()) + this.hashCode());
        if (!tmpDir.exists() || !tmpDir.isDirectory()) {
            return;
        }
        File[] tmpFiles = tmpDir.listFiles();
        int i = 0;
        while (i < tmpFiles.length) {
            if (!tmpFiles[i].delete()) {
                tmpFiles[i].deleteOnExit();
            }
            ++i;
        }
        if (!tmpDir.delete()) {
            tmpDir.deleteOnExit();
        }
    }

    public Scriptable getDataSourcesScriptObject() {
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.WARNING, clazz.getName(), "closeDataSource", "DataEngine has been shutdown", e);
            throw e;
        }
        if (this.dataSourcesJSObject == null) {
            this.dataSourcesJSObject = new JSDataSources(this.dataSources);
        }
        return this.dataSourcesJSObject;
    }

    public IPreparedCubeQuery prepare(ICubeQueryDefinition query, Map appContext) throws BirtException {
        return new PreparedCubeQuery(query, this.session, this.context, appContext);
    }

    public IResultMetaData getCachedDataSetMetaData(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        return this.session.getDataSetCacheManager().getCachedResultMetadata(dataSource, dataSet);
    }
}

