/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class ResultMetaData
implements IResultMetaData {
    IResultClass m_odiResultClass;
    protected static Logger logger;
    private int columnCount = -1;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ResultMetaData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ResultMetaData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public ResultMetaData(IResultClass odiResultClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ResultMetaData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "ResultMetaData", odiResultClass);
        if (!$assertionsDisabled && odiResultClass == null) {
            throw new AssertionError();
        }
        this.m_odiResultClass = odiResultClass;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINER, clazz2.getName(), "QueryResults", "QueryResults starts up");
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ResultMetaData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz3.getName(), "ResultMetaData");
    }

    public int getColumnCount() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getColumnCount", "");
        return this.doGetColumnCount();
    }

    private int doGetColumnCount() {
        int columnCount;
        if (this.columnCount != -1) {
            return this.columnCount;
        }
        int i = columnCount = this.m_odiResultClass.getFieldCount();
        while (i > 0) {
            try {
                if (!this.isTemp(this.m_odiResultClass.getFieldName(i))) {
                    columnCount = i;
                    break;
                }
            }
            catch (DataException dataException) {
                return columnCount;
            }
            --i;
        }
        return columnCount;
    }

    private boolean isTemp(String name) {
        return name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_SORT_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_FILTER_\\E\\d*\\Q$}_\\E");
    }

    public String getColumnName(int index) throws DataException {
        this.checkIndex(index);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getColumnName", "the column name at the specified index", new Integer(index));
        return this.m_odiResultClass.getFieldName(index);
    }

    public String getColumnAlias(int index) throws DataException {
        this.checkIndex(index);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getColumnAlias", "the column alias at the specified index", new Integer(index));
        return this.m_odiResultClass.getFieldAlias(index);
    }

    public int getColumnType(int index) throws DataException {
        this.checkIndex(index);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getColumnType", "the data type of the column at the specified index", new Integer(index));
        Class odiDataType = this.m_odiResultClass.getFieldValueClass(index);
        return DataTypeUtil.toApiDataType((Class)odiDataType);
    }

    public String getColumnTypeName(int index) throws DataException {
        this.checkIndex(index);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getColumnTypeName", "the Data Engine data type name of the column at the specified index", new Integer(index));
        return DataType.getName((int)this.getColumnType(index));
    }

    public String getColumnNativeTypeName(int index) throws DataException {
        this.checkIndex(index);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getColumnNativeTypeName", "the data provider specific data type name of the specified column", new Integer(index));
        return this.m_odiResultClass.getFieldNativeTypeName(index);
    }

    public String getColumnLabel(int index) throws DataException {
        this.checkIndex(index);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getColumnLabel", "the label or display name of the column at the specified index", new Integer(index));
        return this.m_odiResultClass.getFieldLabel(index);
    }

    public boolean isComputedColumn(int index) throws DataException {
        this.checkIndex(index);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "isComputedColumn", "whether the specified projected column is defined as a computed column", new Integer(index));
        return this.m_odiResultClass.isCustomField(index);
    }

    private void checkIndex(int index) throws DataException {
        if (index > this.doGetColumnCount()) {
            throw new DataException("data.engine.InvalidFieldIndex", new Integer(index));
        }
    }
}

