/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class LogHelper {
    private static HashMap sm_loggerMap;
    private Logger m_logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.LogHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        sm_loggerMap = new HashMap();
    }

    static LogHelper getInstance(String loggerName) {
        LogHelper aLogHelper = (LogHelper)sm_loggerMap.get(loggerName);
        if (aLogHelper == null) {
            aLogHelper = new LogHelper(loggerName);
            sm_loggerMap.put(loggerName, aLogHelper);
        }
        return aLogHelper;
    }

    private LogHelper(String loggerName) {
        this.m_logger = Logger.getLogger(loggerName);
    }

    boolean isLoggable(Level level) {
        return this.m_logger.isLoggable(level);
    }

    boolean isLoggingEnterExitLevel() {
        return this.m_logger.isLoggable(Level.FINER);
    }

    void entering(String sourceClass, String sourceMethod) {
        this.m_logger.entering(sourceClass, sourceMethod);
    }

    void entering(String sourceClass, String sourceMethod, int intParam) {
        if (!this.isLoggingEnterExitLevel()) {
            return;
        }
        Integer param1 = new Integer(intParam);
        this.m_logger.entering(sourceClass, sourceMethod, param1);
    }

    void entering(String sourceClass, String sourceMethod, Object param1) {
        this.m_logger.entering(sourceClass, sourceMethod, param1);
    }

    void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (!this.isLoggingEnterExitLevel()) {
            return;
        }
        if (params == null) {
            this.m_logger.entering(sourceClass, sourceMethod, "<null>");
        } else {
            this.m_logger.entering(sourceClass, sourceMethod, params);
        }
    }

    void exiting(String sourceClass, String sourceMethod) {
        this.m_logger.exiting(sourceClass, sourceMethod);
    }

    void exiting(String sourceClass, String sourceMethod, int intParam) {
        if (!this.isLoggingEnterExitLevel()) {
            return;
        }
        Integer param1 = new Integer(intParam);
        this.m_logger.exiting(sourceClass, sourceMethod, param1);
    }

    void exiting(String sourceClass, String sourceMethod, Object result) {
        this.m_logger.exiting(sourceClass, sourceMethod, result);
    }

    void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.m_logger.logp(level, sourceClass, sourceMethod, msg);
    }

    void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.m_logger.logp(level, sourceClass, sourceMethod, msg, param1);
    }

    void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (params == null) {
            this.m_logger.logp(level, sourceClass, sourceMethod, msg, "<null>");
        } else {
            this.m_logger.logp(level, sourceClass, sourceMethod, msg, params);
        }
    }

    void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable ex) {
        if (!$assertionsDisabled && ex == null) {
            throw new AssertionError();
        }
        this.m_logger.logp(level, sourceClass, sourceMethod, msg, ex);
    }
}

