/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSet {
    private IResultSet m_resultSet;
    private IResultClass m_resultClass;
    private static String sm_className;
    private static String sm_loggerName;
    private static LogHelper sm_logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.ResultSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.ResultSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sm_className = clazz2.getName();
        sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }

    ResultSet(IResultSet resultSet, IResultClass resultClass) {
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, "ResultSet", new Object[]{resultSet, resultClass});
        }
        if (!($assertionsDisabled || resultSet != null && resultClass != null)) {
            throw new AssertionError();
        }
        this.m_resultSet = resultSet;
        this.m_resultClass = resultClass;
        sm_logger.exiting(sm_className, "ResultSet", this);
    }

    public IResultClass getMetaData() throws DataException {
        return this.m_resultClass;
    }

    public void setMaxRows(int max) throws DataException {
        try {
            this.m_resultSet.setMaxRows(max);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "setMaxRows", "Cannot set max rows.", ex);
            throw new DataException("odaconsumer.CannotSetMaxRows", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "setMaxRows", "Cannot set max rows.", ex);
        }
    }

    public IResultObject fetch() throws DataException {
        if (this.m_resultSet == null) {
            return null;
        }
        try {
            if (!this.m_resultSet.next()) {
                return null;
            }
        }
        catch (OdaException ex) {
            this.handleException(ex, "odaconsumer.CannotFetchNextRow", "fetch", -1);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException(ex, "odaconsumer.CannotFetchNextRow", "fetch", -1);
        }
        int columnCount = this.m_resultClass.getFieldCount();
        int[] driverPositions = ((ResultClass)this.m_resultClass).getFieldDriverPositions();
        if (!$assertionsDisabled && columnCount != driverPositions.length) {
            throw new AssertionError();
        }
        Object[] fields = new Object[columnCount];
        int i = 1;
        while (i <= columnCount) {
            if (!this.m_resultClass.isCustomField(i)) {
                Class dataType = this.m_resultClass.getFieldValueClass(i);
                int driverPosition = driverPositions[i - 1];
                Object colValue = null;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (dataType == clazz) {
                    int j = this.getInt(driverPosition);
                    if (!this.wasNull()) {
                        colValue = new Integer(j);
                    }
                } else {
                    Class<?> clazz2 = class$2;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("java.lang.Double");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (dataType == clazz2) {
                        double d = this.getDouble(driverPosition);
                        if (!this.wasNull()) {
                            colValue = new Double(d);
                        }
                    } else {
                        Class<?> clazz3 = class$3;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType == clazz3) {
                            colValue = this.getString(driverPosition);
                        } else {
                            Class<?> clazz4 = class$4;
                            if (clazz4 == null) {
                                try {
                                    clazz4 = Class.forName("java.math.BigDecimal");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (dataType == clazz4) {
                                colValue = this.getBigDecimal(driverPosition);
                            } else {
                                Class<?> clazz5 = class$5;
                                if (clazz5 == null) {
                                    try {
                                        clazz5 = Class.forName("java.sql.Date");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (dataType == clazz5) {
                                    colValue = this.getDate(driverPosition);
                                } else {
                                    Class<?> clazz6 = class$6;
                                    if (clazz6 == null) {
                                        try {
                                            clazz6 = Class.forName("java.sql.Time");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (dataType == clazz6) {
                                        colValue = this.getTime(driverPosition);
                                    } else {
                                        Class<?> clazz7 = class$7;
                                        if (clazz7 == null) {
                                            try {
                                                clazz7 = Class.forName("java.util.Date");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (dataType == clazz7) {
                                            colValue = this.getTimestamp(driverPosition);
                                        } else {
                                            Class<?> clazz8 = class$8;
                                            if (clazz8 == null) {
                                                try {
                                                    clazz8 = Class.forName("java.sql.Timestamp");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (dataType == clazz8) {
                                                colValue = this.getTimestamp(driverPosition);
                                            } else {
                                                Class<?> clazz9 = class$9;
                                                if (clazz9 == null) {
                                                    try {
                                                        clazz9 = Class.forName("org.eclipse.datatools.connectivity.oda.IBlob");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (dataType == clazz9) {
                                                    colValue = this.getBlob(driverPosition);
                                                } else {
                                                    Class<?> clazz10 = class$10;
                                                    if (clazz10 == null) {
                                                        try {
                                                            clazz10 = Class.forName("org.eclipse.datatools.connectivity.oda.IClob");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (dataType == clazz10) {
                                                        colValue = this.getClob(driverPosition);
                                                    } else {
                                                        Class<?> clazz11 = class$11;
                                                        if (clazz11 == null) {
                                                            try {
                                                                clazz11 = Class.forName("java.lang.Boolean");
                                                            }
                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                            }
                                                        }
                                                        if (dataType == clazz11) {
                                                            boolean val = this.getBoolean(driverPosition);
                                                            if (!this.wasNull()) {
                                                                colValue = new Boolean(val);
                                                            }
                                                        } else if (!$assertionsDisabled) {
                                                            throw new AssertionError();
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (this.wasNull()) {
                    colValue = null;
                }
                fields[i - 1] = colValue;
            }
            ++i;
        }
        ResultObject ret = new ResultObject(this.m_resultClass, fields);
        sm_logger.logp(Level.FINEST, sm_className, "fetch", "Fetched next row: {0} .", ret);
        return ret;
    }

    private int getInt(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getInt(driverPosition);
        }
        catch (OdaException ex) {
            this.handleException(ex, "odaconsumer.CannotGetIntFromColumn", "getInt", driverPosition);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException(ex, "odaconsumer.CannotGetIntFromColumn", "getInt", driverPosition);
        }
        return 0;
    }

    private double getDouble(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getDouble(driverPosition);
        }
        catch (OdaException ex) {
            this.handleException(ex, "odaconsumer.CannotGetDoubleFromColumn", "getDouble", driverPosition);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException(ex, "odaconsumer.CannotGetDoubleFromColumn", "getDouble", driverPosition);
        }
        return 0.0;
    }

    private String getString(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getString(driverPosition);
        }
        catch (OdaException ex) {
            this.handleException(ex, "odaconsumer.CannotGetStringFromColumn", "getString", driverPosition);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException(ex, "odaconsumer.CannotGetStringFromColumn", "getString", driverPosition);
        }
        return null;
    }

    private BigDecimal getBigDecimal(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getBigDecimal(driverPosition);
        }
        catch (OdaException ex) {
            this.handleException(ex, "odaconsumer.CannotGetBigDecimalFromColumn", "getBigDecimal", driverPosition);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException(ex, "odaconsumer.CannotGetBigDecimalFromColumn", "getBigDecimal", driverPosition);
        }
        return null;
    }

    private Date getDate(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getDate(driverPosition);
        }
        catch (OdaException ex) {
            this.handleException(ex, "odaconsumer.CannotGetDateFromColumn", "getDate", driverPosition);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException(ex, "odaconsumer.CannotGetDateFromColumn", "getDate", driverPosition);
        }
        return null;
    }

    private Time getTime(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getTime(driverPosition);
        }
        catch (OdaException ex) {
            this.handleException(ex, "odaconsumer.CannotGetTimeFromColumn", "getTime", driverPosition);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException(ex, "odaconsumer.CannotGetTimeFromColumn", "getTime", driverPosition);
        }
        return null;
    }

    private Timestamp getTimestamp(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getTimestamp(driverPosition);
        }
        catch (OdaException ex) {
            this.handleException(ex, "odaconsumer.CannotGetTimestampFromColumn", "getTimestamp", driverPosition);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException(ex, "odaconsumer.CannotGetTimestampFromColumn", "getTimestamp", driverPosition);
        }
        return null;
    }

    private IBlob getBlob(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getBlob(driverPosition);
        }
        catch (OdaException ex) {
            this.handleException(ex, "odaconsumer.CannotGetBlobFromColumn", "getBlob", driverPosition);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException(ex, "odaconsumer.CannotGetBlobFromColumn", "getBlob", driverPosition);
        }
        return null;
    }

    private IClob getClob(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getClob(driverPosition);
        }
        catch (OdaException ex) {
            this.handleException(ex, "odaconsumer.CannotGetClobFromColumn", "getClob", driverPosition);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException(ex, "odaconsumer.CannotGetClobFromColumn", "getClob", driverPosition);
        }
        return null;
    }

    private boolean getBoolean(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getBoolean(driverPosition);
        }
        catch (OdaException ex) {
            this.handleException(ex, "odaconsumer.CannotGetBooleanFromColumn", "getBoolean", driverPosition);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException(ex, "odaconsumer.CannotGetBooleanFromColumn", "getBoolean", driverPosition);
        }
        return false;
    }

    private boolean wasNull() throws DataException {
        try {
            return this.m_resultSet.wasNull();
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "wasNull", "Cannot check wasNull.", ex);
            throw new DataException("odaconsumer.CannotDetermineWasNull", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "wasNull", "Cannot check wasNull. Default to false.", ex);
            return false;
        }
    }

    public int getRowPosition() throws DataException {
        try {
            return this.m_resultSet.getRow();
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getRowPosition", "Cannot get row position.", ex);
            throw new DataException("odaconsumer.CannotGetRowPosition", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "getRowPosition", "Cannot get row position.  Default to 0.", ex);
            return 0;
        }
    }

    public void close() throws DataException {
        sm_logger.entering(sm_className, "close");
        try {
            this.m_resultSet.close();
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "close", "Cannot close result set.", ex);
            throw new DataException("odaconsumer.CannotCloseResultSet", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "close", "Cannot close result set.", ex);
        }
        sm_logger.exiting(sm_className, "close");
    }

    private void handleException(Throwable ex, String errorCode, String methodName, int driverColumnPosition) throws DataException {
        DataException dataEx = driverColumnPosition > 0 ? new DataException(errorCode, ex, new Integer(driverColumnPosition)) : new DataException(errorCode, ex);
        sm_logger.logp(Level.SEVERE, sm_className, methodName, dataEx.getLocalizedMessage(), ex);
        throw dataEx;
    }
}

