/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.api.cube;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerMap;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerReleaser;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.api.cube.StopSign;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Hierarchy;

public class CubeMaterializer {
    private IDocumentManager documentManager;
    private DataEngine dataEngine;

    public CubeMaterializer(DataEngine dataEngine, String pathName, String managerName) throws DataException, IOException {
        this(dataEngine, pathName, managerName, 0);
    }

    public CubeMaterializer(DataEngine dataEngine, String pathName, String managerName, int cacheSize) throws DataException, IOException {
        this.dataEngine = dataEngine;
        this.setShutdownListener();
        this.documentManager = DocumentManagerFactory.createFileDocumentManager(pathName, managerName, cacheSize);
        if (this.dataEngine != null) {
            DocManagerMap.getDocManagerMap().set(String.valueOf(this.dataEngine.hashCode()), String.valueOf(pathName) + managerName, this.documentManager);
        }
    }

    public CubeMaterializer(DataEngine dataEngine) throws DataException, IOException {
        this.dataEngine = dataEngine;
        this.setShutdownListener();
        this.documentManager = DocumentManagerFactory.createFileDocumentManager();
    }

    private void setShutdownListener() {
        if (this.dataEngine == null) {
            return;
        }
        this.dataEngine.addShutdownListener(new DocManagerReleaser(this.dataEngine));
    }

    public IDocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public IHierarchy createHierarchy(String dimensionName, String hierarchyName, IDatasetIterator iterator, ILevelDefn[] levelDefs) throws IOException, BirtException {
        Hierarchy hierarchy = new Hierarchy(this.documentManager, dimensionName, hierarchyName);
        hierarchy.createAndSaveHierarchy(iterator, levelDefs);
        return hierarchy;
    }

    public IDimension createDimension(String name, IHierarchy hierarchy) throws BirtException, IOException {
        if (hierarchy instanceof Hierarchy) {
            return new Dimension(name, this.documentManager, (Hierarchy)hierarchy, false);
        }
        return null;
    }

    public void createCube(String name, String[][] keyColumnNames, IDimension[] dimensions, IDatasetIterator factTable, String[] measureColumns, StopSign stopSign) throws IOException, BirtException {
        this.createCube(name, keyColumnNames, keyColumnNames, dimensions, factTable, measureColumns, stopSign);
    }

    public void createCube(String name, String[][] factTableJointColumnNames, String[][] DimJointColumnNames, IDimension[] dimensions, IDatasetIterator factTable, String[] measureColumns, StopSign stopSign) throws IOException, BirtException {
        if (stopSign == null) {
            stopSign = new StopSign();
        }
        Cube cube = new Cube(name, this.documentManager);
        cube.create(factTableJointColumnNames, DimJointColumnNames, dimensions, factTable, measureColumns, stopSign);
        cube.close();
        this.documentManager.flush();
    }

    public void saveCubeToReportDocument(String cubeName, IDocArchiveWriter writer, StopSign stopSign) throws IOException, DataException {
        if (stopSign == null) {
            stopSign = new StopSign();
        }
        Cube cube = new Cube(cubeName, this.documentManager);
        cube.load(stopSign);
        this.saveDocObjToReportDocument(NamingUtil.getCubeDocName(cubeName), writer, stopSign);
        String factTableName = cube.getFactTable().getName();
        this.saveDocObjToReportDocument(NamingUtil.getFactTableName(factTableName), writer, stopSign);
        this.saveDocObjToReportDocument(NamingUtil.getFTSUListName(factTableName), writer, stopSign);
        IDocumentObject documentObject = this.documentManager.openDocumentObject(NamingUtil.getFTSUListName(factTableName));
        try {
            String FTSUName = documentObject.readString();
            while (FTSUName != null) {
                this.saveDocObjToReportDocument(FTSUName, writer, stopSign);
                FTSUName = documentObject.readString();
            }
        }
        catch (EOFException eOFException) {}
        IDimension[] dimensions = cube.getDimesions();
        int i = 0;
        while (i < dimensions.length) {
            this.saveDocObjToReportDocument(NamingUtil.getDimensionDocName(dimensions[i].getName()), writer, stopSign);
            IHierarchy hierarchy = dimensions[i].getHierarchy();
            this.saveDocObjToReportDocument(NamingUtil.getHierarchyDocName(dimensions[i].getName(), hierarchy.getName()), writer, stopSign);
            this.saveDocObjToReportDocument(NamingUtil.getHierarchyOffsetDocName(dimensions[i].getName(), hierarchy.getName()), writer, stopSign);
            ILevel[] levels = hierarchy.getLevels();
            int j = 0;
            while (j < levels.length) {
                this.saveDocObjToReportDocument(NamingUtil.getLevelIndexDocName(dimensions[i].getName(), levels[j].getName()), writer, stopSign);
                this.saveDocObjToReportDocument(NamingUtil.getLevelIndexOffsetDocName(dimensions[i].getName(), levels[j].getName()), writer, stopSign);
                ++j;
            }
            ++i;
        }
        writer.flush();
    }

    private void saveDocObjToReportDocument(String name, IDocArchiveWriter writer, StopSign stopSign) throws IOException, DataException {
        IDocumentObject documentObject = this.documentManager.openDocumentObject(name);
        RAOutputStream outputStreadm = writer.createRandomAccessStream(name);
        byte[] buffer = new byte[4096];
        if (documentObject == null) {
            documentObject = null;
        }
        int readSize = documentObject.read(buffer, 0, buffer.length);
        while (!stopSign.isStopped() && readSize >= 0) {
            outputStreadm.write(buffer, 0, readSize);
            readSize = documentObject.read(buffer, 0, buffer.length);
        }
        outputStreadm.flush();
        outputStreadm.close();
        documentObject.close();
    }

    public void close() throws IOException {
        this.documentManager.flush();
    }
}

