/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.util.DataType;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class AggregationResultSet
implements IAggregationResultSet {
    private AggregationDefinition aggregation;
    private Map aggregationResultNameMap = null;
    private IDiskArray aggregationResultRows;
    private int currentPosition;
    private String[][] keyNames;
    private String[][] attributeNames;
    private int[][] keyDataTypes;
    private int[][] attributeDataTypes;
    private int[] aggregationDataType;
    private IAggregationResultRow resultObject;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public AggregationResultSet(AggregationDefinition aggregation, IDiskArray aggregationResultRow, String[][] keyNames, String[][] attributeNames) throws IOException {
        Object[] params = new Object[]{aggregation, aggregationResultRow, keyNames, attributeNames};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "AggregationResultSet", params);
        this.aggregation = aggregation;
        this.aggregationResultRows = aggregationResultRow;
        this.produceaggregationNameMap();
        this.keyNames = keyNames;
        this.attributeNames = attributeNames;
        if (aggregationResultRow.size() == 0) {
            return;
        }
        this.resultObject = (IAggregationResultRow)aggregationResultRow.get(0);
        if (this.resultObject.getLevelMembers() != null) {
            this.keyDataTypes = new int[this.resultObject.getLevelMembers().length][];
            this.attributeDataTypes = new int[this.resultObject.getLevelMembers().length][];
            int i = 0;
            while (i < this.resultObject.getLevelMembers().length) {
                this.keyDataTypes[i] = new int[this.resultObject.getLevelMembers()[i].getKeyValues().length];
                int j = 0;
                while (j < this.resultObject.getLevelMembers()[i].getKeyValues().length) {
                    this.keyDataTypes[i][j] = DataType.getDataType(this.resultObject.getLevelMembers()[i].getKeyValues()[j].getClass());
                    ++j;
                }
                if (this.resultObject.getLevelMembers()[i].getAttributes() != null) {
                    this.attributeDataTypes[i] = new int[this.resultObject.getLevelMembers()[i].getAttributes().length];
                    j = 0;
                    while (j < this.attributeDataTypes[i].length) {
                        if (this.resultObject.getLevelMembers()[i].getAttributes()[j] != null) {
                            this.attributeDataTypes[i][j] = DataType.getDataType(this.resultObject.getLevelMembers()[i].getAttributes()[j].getClass());
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.setAggregationDataType();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "AggregationResultSet");
    }

    private void setAggregationDataType() throws IOException {
        IAggregationResultRow resultObject = (IAggregationResultRow)this.aggregationResultRows.get(0);
        int i = 0;
        while (i < this.aggregationResultRows.size()) {
            resultObject = (IAggregationResultRow)this.aggregationResultRows.get(i);
            if (resultObject.getAggregationValues() != null) {
                if (this.aggregationDataType == null) {
                    this.aggregationDataType = new int[resultObject.getAggregationValues().length];
                    int j = 0;
                    while (j < this.aggregationDataType.length) {
                        this.aggregationDataType[j] = -1;
                        ++j;
                    }
                }
                boolean existUnknown = false;
                if (resultObject.getAggregationValues() != null) {
                    int j = 0;
                    while (j < resultObject.getAggregationValues().length) {
                        if (this.aggregationDataType[j] == -1) {
                            if (resultObject.getAggregationValues()[j] != null) {
                                this.aggregationDataType[j] = DataType.getDataType(resultObject.getAggregationValues()[j].getClass());
                            } else {
                                existUnknown = true;
                            }
                        }
                        ++j;
                    }
                    if (!existUnknown) {
                        return;
                    }
                }
            }
            ++i;
        }
    }

    private void produceaggregationNameMap() {
        AggregationFunctionDefinition[] functions = this.aggregation.getAggregationFunctions();
        this.aggregationResultNameMap = new HashMap();
        if (functions == null) {
            return;
        }
        int i = 0;
        while (i < functions.length) {
            if (functions[i].getName() != null) {
                this.aggregationResultNameMap.put(functions[i].getName(), new Integer(i));
            }
            ++i;
        }
    }

    public int getAggregationDataType(int aggregationIndex) throws IOException {
        if (this.aggregationDataType == null || aggregationIndex < 0) {
            return -1;
        }
        return this.aggregationDataType[aggregationIndex];
    }

    public int[] getAggregationDataType() {
        return this.aggregationDataType;
    }

    public Object getAggregationValue(int aggregationIndex) throws IOException {
        if (this.resultObject.getAggregationValues() == null || aggregationIndex < 0) {
            return null;
        }
        return this.resultObject.getAggregationValues()[aggregationIndex];
    }

    public Object getLevelAttribute(int levelIndex, int attributeIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || this.resultObject.getLevelMembers()[levelIndex].getAttributes() == null) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getAttributes()[attributeIndex];
    }

    public int getLevelAttributeDataType(DimLevel level, String attributeName) {
        int levelIndex = this.getLevelIndex(level);
        if (this.attributeDataTypes == null || this.attributeDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.attributeDataTypes[levelIndex][this.getLevelAttributeIndex(level, attributeName)];
    }

    public int getLevelAttributeIndex(DimLevel level, String attributeName) {
        int levelIndex = this.getLevelIndex(level);
        if (this.attributeNames == null || this.attributeNames[levelIndex] == null) {
            return -1;
        }
        int i = 0;
        while (i < this.attributeNames[levelIndex].length) {
            if (this.attributeNames[levelIndex][i].equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLevelAttributeIndex(int levelIndex, String attributeName) {
        if (this.attributeNames == null || levelIndex < 0 || this.attributeNames[levelIndex] == null) {
            return -1;
        }
        int i = 0;
        while (i < this.attributeNames[levelIndex].length) {
            if (this.attributeNames[levelIndex][i].equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLevelIndex(DimLevel level) {
        if (this.aggregation.getLevels() == null) {
            return -1;
        }
        int i = 0;
        while (i < this.aggregation.getLevels().length) {
            if (this.aggregation.getLevels()[i].equals(level)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLevelKeyDataType(DimLevel level, String keyName) {
        if (this.keyDataTypes == null) {
            return -1;
        }
        return this.getLevelKeyDataType(this.getLevelIndex(level), keyName);
    }

    public Object[] getLevelKeyValue(int levelIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || levelIndex > this.resultObject.getLevelMembers().length - 1) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getKeyValues();
    }

    public int length() {
        return this.aggregationResultRows.size();
    }

    public void seek(int index) throws IOException {
        if (index >= this.aggregationResultRows.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.aggregationResultRows.size());
        }
        this.currentPosition = index;
        this.resultObject = (IAggregationResultRow)this.aggregationResultRows.get(index);
    }

    public IAggregationResultRow getCurrentRow() {
        return this.resultObject;
    }

    public int getPosition() {
        return this.currentPosition;
    }

    public int getSortType(int levelIndex) {
        if (this.aggregation.getSortTypes() == null) {
            return -100;
        }
        return this.aggregation.getSortTypes()[levelIndex];
    }

    public int[] getSortType() {
        return this.aggregation.getSortTypes();
    }

    public int getLevelAttributeDataType(int levelIndex, String attributeName) {
        if (this.attributeDataTypes == null || levelIndex < 0 || this.attributeDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.attributeDataTypes[levelIndex][this.getLevelAttributeIndex(levelIndex, attributeName)];
    }

    public String[] getLevelAttributes(int levelIndex) {
        if (this.attributeNames == null) {
            return null;
        }
        return this.attributeNames[levelIndex];
    }

    public int getLevelKeyDataType(int levelIndex, String keyName) {
        if (this.keyDataTypes == null || levelIndex < 0 || this.keyDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.keyDataTypes[levelIndex][this.getLevelKeyIndex(levelIndex, keyName)];
    }

    public int getLevelKeyIndex(int levelIndex, String keyName) {
        if (this.keyNames == null || levelIndex < 0 || this.keyNames[levelIndex] == null) {
            return -1;
        }
        int i = 0;
        while (i < this.keyNames[levelIndex].length) {
            if (this.keyNames[levelIndex][i].equals(keyName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLevelKeyIndex(DimLevel level, String keyName) {
        if (this.keyNames == null) {
            return -1;
        }
        return this.getLevelKeyIndex(this.getLevelIndex(level), keyName);
    }

    public int getLevelAttributeColCount(int levelIndex) {
        if (this.attributeNames == null || this.attributeNames[levelIndex] == null) {
            return 0;
        }
        return this.attributeNames[levelIndex].length;
    }

    public int getLevelKeyColCount(int levelIndex) {
        if (this.keyNames == null || this.keyNames[levelIndex] == null) {
            return 0;
        }
        return this.keyNames[levelIndex].length;
    }

    public String[][] getLevelKeys() {
        return this.keyNames;
    }

    public int[][] getLevelKeyDataType() {
        return this.keyDataTypes;
    }

    public String[][] getLevelAttributes() {
        return this.attributeNames;
    }

    public int[][] getLevelAttributeDataType() {
        return this.attributeDataTypes;
    }

    public int getLevelCount() {
        if (this.keyNames == null) {
            return 0;
        }
        return this.keyNames.length;
    }

    public String getLevelKeyName(int levelIndex, int keyIndex) {
        return this.keyNames[levelIndex][keyIndex];
    }

    public DimLevel getLevel(int levelIndex) {
        return this.aggregation.getLevels()[levelIndex];
    }

    public String[][] getAggributeNames() {
        return this.attributeNames;
    }

    public String[][] getKeyNames() {
        return this.keyNames;
    }

    public int getAggregationIndex(String name) throws IOException {
        Object index = this.aggregationResultNameMap.get(name);
        if (index == null) {
            return -1;
        }
        return (Integer)index;
    }

    public DimLevel[] getAllLevels() {
        return this.aggregation.getLevels();
    }

    public AggregationDefinition getAggregationDefinition() {
        return this.aggregation;
    }

    public void close() throws IOException {
        this.aggregationResultRows.close();
    }

    public void clear() throws IOException {
        this.aggregationResultRows.clear();
    }
}

