/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter;

import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.util.filter.IJSTopBottomFilterHelper;

public class TopBottomFilter {
    private IJSTopBottomFilterHelper filterHelper;
    private double n;
    private int filterType;
    private DimLevel[] aggrLevels;
    private DimLevel targetLevel;
    private DimLevel[] axisQualifierLevels;
    private Object[] axisQualifierValues;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.TopBottomFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public TopBottomFilter(int n) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.TopBottomFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "TopBottomFilterDefn", new Integer(n));
        if (n == 0) {
            throw new IllegalArgumentException("Parameter n can't be zero!");
        }
        this.n = n > 0 ? n : -n;
        this.filterType = 1;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.TopBottomFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "TopBottomFilterDefn");
    }

    public TopBottomFilter(int n, DimLevel targerLevel, DimLevel[] aggrLevels) {
        this(n);
        Object[] params = new Object[]{new Integer(n), targerLevel, aggrLevels};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.TopBottomFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "TopBottomFilterDefn", params);
        this.targetLevel = targerLevel;
        this.aggrLevels = aggrLevels;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.TopBottomFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "TopBottomFilterDefn");
    }

    public TopBottomFilter(IJSTopBottomFilterHelper filterHelper) {
        ICubeFilterDefinition cubeFilter = filterHelper.getCubeFilterDefinition();
        this.aggrLevels = filterHelper.getAggrLevels();
        this.filterType = filterHelper.getFilterType();
        this.n = filterHelper.getN();
        this.filterHelper = filterHelper;
        this.targetLevel = new DimLevel(cubeFilter.getTargetLevel());
        ILevelDefinition[] axisLevels = cubeFilter.getAxisQualifierLevels();
        if (axisLevels != null) {
            this.axisQualifierLevels = new DimLevel[axisLevels.length];
            int i = 0;
            while (i < axisLevels.length) {
                this.axisQualifierLevels[i] = new DimLevel(axisLevels[i]);
                ++i;
            }
        }
        this.axisQualifierValues = cubeFilter.getAxisQualifierValues();
    }

    public double getN() {
        return this.n;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public DimLevel[] getAggrLevels() {
        return this.aggrLevels;
    }

    public void setAggrLevels(DimLevel[] aggrLevels) {
        this.aggrLevels = aggrLevels;
    }

    public DimLevel getTargetLevel() {
        return this.targetLevel;
    }

    public void setTargetLevel(DimLevel targerLevel) {
        this.targetLevel = targerLevel;
    }

    public IJSTopBottomFilterHelper getFilterHelper() {
        return this.filterHelper;
    }

    public DimLevel[] getAxisQualifierLevels() {
        return this.axisQualifierLevels;
    }

    public Object[] getAxisQualifierValues() {
        return this.axisQualifierValues;
    }
}

