/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.util.BufferedRandomAccessFile;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.TempPathManager;

abstract class BaseDiskArray
implements IDiskArray {
    private static final String fileNamePrefix = "BasicDiskList";
    private static final int FILE_BUFFER_SIZE = 1024;
    private static final int bufferSize = 1000;
    protected static final short NORMAL_VALUE = 0;
    protected static final short NULL_VALUE = -1;
    private static Logger logger;
    private int currentCacheStartIndex = -1;
    private int size = 0;
    private File diskFile = null;
    protected BufferedRandomAccessFile randomAccessFile = null;
    private Object[] buffer = new Object[1000];
    private List segmentOffsets = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.util.PrimitiveDiskArray");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public BaseDiskArray() throws IOException {
        this.segmentOffsets.add(new Integer(0));
        this.createRandomAccessFile();
    }

    public boolean add(Object o) throws IOException {
        this.writeObject(o);
        ++this.size;
        if (this.size % 1000 == 0) {
            this.segmentOffsets.add(new Integer(this.getOffset()));
        }
        return true;
    }

    private void createRandomAccessFile() throws IOException {
        this.createCacheFile();
        this.randomAccessFile = new BufferedRandomAccessFile(this.diskFile, "rw", 1024);
    }

    private int getOffset() throws IOException {
        return (int)this.randomAccessFile.getFilePointer();
    }

    protected abstract void writeObject(Object var1) throws IOException;

    public Object get(int index) throws IOException {
        this.RangeCheck(index);
        if (this.currentCacheStartIndex < 0 || index < this.currentCacheStartIndex || index > this.currentCacheStartIndex + 1000 - 1) {
            int readSize = 1000;
            if (index / 1000 == this.segmentOffsets.size() - 1) {
                readSize = this.size % 1000;
            }
            this.currentCacheStartIndex = index / 1000 * 1000;
            this.readObjects(this.getSegmentOffset(index), readSize);
        }
        return this.buffer[index % 1000];
    }

    private int getSegmentOffset(int index) {
        return (Integer)this.segmentOffsets.get(index / 1000);
    }

    private void readObjects(int offset, int readSize) throws IOException {
        this.randomAccessFile.seek(offset);
        int i = 0;
        while (i < readSize) {
            this.buffer[i] = this.readObject();
            ++i;
        }
    }

    protected abstract Object readObject() throws IOException;

    private void createCacheFile() throws IOException {
        String tempFileStr = TempPathManager.getTempFileName(fileNamePrefix, this.hashCode(), "");
        if (this.diskFile == null) {
            this.diskFile = new File(tempFileStr);
            this.diskFile.createNewFile();
        }
    }

    public int size() {
        return this.size;
    }

    public void close() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        this.clearDiskFile();
        this.size = 0;
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private void clearDiskFile() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        if (this.diskFile != null) {
            this.diskFile.delete();
            this.diskFile = null;
        }
    }

    public void finalize() {
        try {
            this.clearDiskFile();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    public void clear() throws IOException {
        this.currentCacheStartIndex = -1;
        this.size = 0;
        this.clearDiskFile();
        this.segmentOffsets.clear();
        this.segmentOffsets.add(new Integer(0));
        this.createRandomAccessFile();
    }
}

