/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.util.ICubeAggrDefn;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;

public class OlapExpressionUtil {
    static /* synthetic */ Class class$0;

    public static boolean isReferenceToDimLevel(String expr) {
        if (expr == null) {
            return false;
        }
        return expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E");
    }

    private static String[] getTargetLevel(String expr) {
        if (expr == null) {
            return null;
        }
        if (!expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E")) {
            return null;
        }
        expr = expr.replaceFirst("\\Qdimension\\E", "");
        String[] result = expr.split("\\Q\"][\"\\E");
        result[0] = result[0].replaceAll("\\Q[\"\\E", "");
        result[1] = result[1].replaceAll("\\Q\"]\\E", "");
        return result;
    }

    private static String[] getTargetAttribute(String expr, List bindings) throws DataException {
        if (expr == null) {
            return null;
        }
        if (!expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E") && !expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E")) {
            String bindingName = OlapExpressionUtil.getBindingName(expr);
            if (bindingName != null) {
                int i = 0;
                while (i < bindings.size()) {
                    IBinding binding = (IBinding)bindings.get(i);
                    if (bindingName.equals(binding.getBindingName()) && binding.getExpression() instanceof IScriptExpression) {
                        return OlapExpressionUtil.getTargetAttribute(((IScriptExpression)binding.getExpression()).getText(), bindings);
                    }
                    ++i;
                }
            }
            throw new DataException("data.engine.backwardSeekError");
        }
        expr = expr.replaceFirst("\\Qdimension\\E", "");
        String[] result = new String[3];
        String[] candidateResult = expr.split("\\Q\"][\"\\E");
        if (candidateResult.length == 2) {
            result[0] = candidateResult[0].replaceAll("\\Q[\"\\E", "");
            result[1] = candidateResult[1].replaceAll("\\Q\"]\\E", "");
        } else {
            result[0] = candidateResult[0].replaceAll("\\Q[\"\\E", "");
            result[1] = candidateResult[1];
            result[2] = candidateResult[2].replaceAll("\\Q\"]\\E", "");
        }
        return result;
    }

    public static DimLevel getTargetDimLevel(String expr) throws DataException {
        String[] target = OlapExpressionUtil.getTargetLevel(expr);
        if (target == null || target.length != 2) {
            throw new DataException("data.olap.levelNameNotFound", expr);
        }
        return new DimLevel(target[0], target[1]);
    }

    public static String getMeasure(String expr) throws DataException {
        if (expr == null || !expr.matches("\\Qmeasure[\"\\E.*\\Q\"]\\E")) {
            throw new DataException("data.olap.invalidMeasureRef", expr);
        }
        return expr.replaceFirst("\\Qmeasure[\"\\E", "").replaceFirst("\\Q\"]\\E", "");
    }

    public static String getBindingName(String expr) {
        if (expr == null) {
            return null;
        }
        if (!expr.matches("\\Qdata[\"\\E.*\\Q\"]\\E")) {
            return null;
        }
        return expr.replaceFirst("\\Qdata[\"\\E", "").replaceFirst("\\Q\"]\\E", "");
    }

    public static String getAttributeColumnName(String level, String attribute) {
        return String.valueOf(level) + "/" + attribute;
    }

    public static String getQualifiedLevelName(String dimensionName, String levelName) {
        return String.valueOf(dimensionName) + "/" + levelName;
    }

    public static String getDisplayColumnName(String level) {
        return String.valueOf(level) + "/" + "DisplayName";
    }

    public static ICubeAggrDefn[] getAggrDefns(List bindings) throws DataException {
        if (bindings == null || bindings.size() == 0) {
            return new ICubeAggrDefn[0];
        }
        ArrayList<CubeAggrDefn> cubeAggrDefns = new ArrayList<CubeAggrDefn>();
        Iterator it = bindings.iterator();
        while (it.hasNext()) {
            IBinding binding = (IBinding)it.next();
            if (!(binding.getExpression() instanceof IScriptExpression) || binding.getAggrFunction() == null) continue;
            cubeAggrDefns.add(new CubeAggrDefn(binding.getBindingName(), OlapExpressionUtil.getMeasure(((IScriptExpression)binding.getExpression()).getText()), OlapExpressionUtil.convertToDimLevel(binding.getAggregatOns()), binding.getAggrFunction(), OlapExpressionUtil.convertToDimLevelAttribute(binding.getArguments(), bindings), binding.getFilter()));
        }
        ICubeAggrDefn[] result = new ICubeAggrDefn[cubeAggrDefns.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (ICubeAggrDefn)cubeAggrDefns.get(i);
            ++i;
        }
        return result;
    }

    public static String getReferencedDimensionName(IBaseExpression expr, List bindings) throws DataException {
        String result = OlapExpressionCompiler.getReferencedScriptObject(expr, "dimension");
        if (result == null) {
            String bindingName = OlapExpressionCompiler.getReferencedScriptObject(expr, "data");
            if (bindingName == null) {
                return null;
            }
            int i = 0;
            while (i < bindings.size()) {
                IBinding binding = (IBinding)bindings.get(i);
                if (binding.getBindingName().equals(bindingName)) {
                    return OlapExpressionUtil.getReferencedDimensionName(binding.getExpression(), bindings);
                }
                ++i;
            }
        }
        return result;
    }

    private static List convertToDimLevel(List dimLevelExpressions) throws DataException {
        ArrayList<DimLevel> result = new ArrayList<DimLevel>();
        int i = 0;
        while (i < dimLevelExpressions.size()) {
            result.add(OlapExpressionUtil.getTargetDimLevel(dimLevelExpressions.get(i).toString()));
            ++i;
        }
        return result;
    }

    private static List convertToDimLevelAttribute(List dimLevelExpressions, List bindings) throws DataException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        int i = 0;
        while (i < dimLevelExpressions.size()) {
            result.add(OlapExpressionUtil.getTargetAttribute(((IScriptExpression)dimLevelExpressions.get(i)).getText(), bindings));
            ++i;
        }
        return result;
    }

    private static class CubeAggrDefn
    implements ICubeAggrDefn {
        private String name;
        private String measure;
        private List aggrLevels;
        private List arguments;
        private String aggrName;
        private IBaseExpression filterExpression;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        CubeAggrDefn(String name, String measure, List aggrLevels, String aggrName, List arguments, IBaseExpression filterExpression) {
            if (!$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && measure == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && aggrLevels == null) {
                throw new AssertionError();
            }
            this.name = name;
            this.measure = measure;
            this.aggrLevels = aggrLevels;
            this.aggrName = aggrName;
            this.arguments = arguments;
            this.filterExpression = filterExpression;
        }

        public List getAggrLevels() {
            return this.aggrLevels;
        }

        public List getArguments() {
            return this.arguments;
        }

        public String getMeasure() {
            return this.measure;
        }

        public String getName() {
            return this.name;
        }

        public String getAggrName() {
            return this.aggrName;
        }

        public IBaseExpression getFilter() {
            return this.filterExpression;
        }
    }
}

