/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.internal.adapter;

import java.util.Iterator;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.report.data.adapter.internal.adapter.FilterAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.SortAdapter;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;

public class GroupAdapter
extends GroupDefinition {
    public GroupAdapter(GroupHandle modelGroup) {
        super(modelGroup.getName());
        Iterator filtersIt;
        Iterator sortsIt;
        this.setKeyExpression(modelGroup.getKeyExpr());
        this.setInterval(GroupAdapter.intervalFromModel(modelGroup.getInterval()));
        this.setIntervalRange(modelGroup.getIntervalRange());
        this.setIntervalStart(modelGroup.getIntervalBase());
        String direction = modelGroup.getSortDirection();
        if (direction != null) {
            this.setSortDirection(SortAdapter.sortDirectionFromModel(direction));
        }
        if ((sortsIt = modelGroup.sortsIterator()) != null) {
            while (sortsIt.hasNext()) {
                SortKeyHandle keyHandle = (SortKeyHandle)sortsIt.next();
                this.addSort(new SortAdapter(keyHandle));
            }
        }
        if ((filtersIt = modelGroup.filtersIterator()) != null) {
            while (filtersIt.hasNext()) {
                FilterConditionHandle filterHandle = (FilterConditionHandle)filtersIt.next();
                this.addFilter((IFilterDefinition)new FilterAdapter(filterHandle));
            }
        }
    }

    public static int intervalFromModel(String interval) {
        if ("year".equals(interval)) {
            return 1;
        }
        if ("month".equals(interval)) {
            return 2;
        }
        if ("week".equals(interval)) {
            return 4;
        }
        if ("quarter".equals(interval)) {
            return 3;
        }
        if ("day".equals(interval)) {
            return 5;
        }
        if ("hour".equals(interval)) {
            return 6;
        }
        if ("minute".equals(interval)) {
            return 7;
        }
        if ("prefix".equals(interval)) {
            return 100;
        }
        if ("second".equals(interval)) {
            return 8;
        }
        if ("interval".equals(interval)) {
            return 99;
        }
        return 0;
    }
}

