/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.w3c.dom.css.CSSValue;

public class AttributeBuilder {
    public static String buildPos(DimensionType x, DimensionType y, DimensionType width, DimensionType height) {
        StringBuffer content = new StringBuffer();
        if (x != null || y != null) {
            content.append("position: relative;");
            AttributeBuilder.buildSize(content, "left", x);
            AttributeBuilder.buildSize(content, "top", y);
        }
        AttributeBuilder.buildSize(content, "width", width);
        AttributeBuilder.buildSize(content, "height", height);
        return content.toString();
    }

    public static void buildVisual(StringBuffer styleBuffer, IStyle style) {
        AttributeBuilder.buildProperty(styleBuffer, "line-height", style.getLineHeight());
    }

    public static void buildBackground(StringBuffer styleBuffer, IStyle style, HTMLReportEmitter emitter) {
        AttributeBuilder.buildProperty(styleBuffer, "background-color", style.getBackgroundColor());
        String image = style.getBackgroundImage();
        if (image == null || "none".equalsIgnoreCase(image)) {
            return;
        }
        if ((image = emitter.handleStyleImage(image)) != null && image.length() > 0) {
            AttributeBuilder.buildURLProperty(styleBuffer, "background-image", image);
            AttributeBuilder.buildProperty(styleBuffer, "background-repeat", style.getBackgroundRepeat());
            AttributeBuilder.buildProperty(styleBuffer, "background-attachment", style.getBackgroundAttachment());
            String x = style.getBackgroundPositionX();
            String y = style.getBackgroundPositionY();
            if (x != null || y != null) {
                if (x == null) {
                    x = "0pt";
                }
                if (y == null) {
                    y = "0pt";
                }
                AttributeBuilder.addPropName(styleBuffer, "background-position");
                AttributeBuilder.addPropValue(styleBuffer, x);
                AttributeBuilder.addPropValue(styleBuffer, y);
                styleBuffer.append(';');
            }
        }
    }

    public static void buildBox(StringBuffer styleBuffer, IStyle style) {
        AttributeBuilder.buildMargins(styleBuffer, style);
        AttributeBuilder.buildPaddings(styleBuffer, style);
        AttributeBuilder.buildBorders(styleBuffer, style);
    }

    public static void buildMargins(StringBuffer styleBuffer, IStyle style) {
        String topMargin = style.getMarginTop();
        String rightMargin = style.getMarginRight();
        String bottomMargin = style.getMarginBottom();
        String leftMargin = style.getMarginLeft();
        if (topMargin != null && rightMargin != null && bottomMargin != null && leftMargin != null) {
            if (rightMargin.equals(leftMargin)) {
                if (topMargin.equals(bottomMargin)) {
                    if (topMargin.equals(rightMargin)) {
                        AttributeBuilder.buildProperty(styleBuffer, "margin", topMargin);
                    } else {
                        AttributeBuilder.addPropName(styleBuffer, "margin");
                        AttributeBuilder.addPropValue(styleBuffer, topMargin);
                        AttributeBuilder.addPropValue(styleBuffer, rightMargin);
                        styleBuffer.append(';');
                    }
                } else {
                    AttributeBuilder.addPropName(styleBuffer, "margin");
                    AttributeBuilder.addPropValue(styleBuffer, topMargin);
                    AttributeBuilder.addPropValue(styleBuffer, rightMargin);
                    AttributeBuilder.addPropValue(styleBuffer, bottomMargin);
                    styleBuffer.append(';');
                }
            } else {
                AttributeBuilder.addPropName(styleBuffer, "margin");
                AttributeBuilder.addPropValue(styleBuffer, topMargin);
                AttributeBuilder.addPropValue(styleBuffer, rightMargin);
                AttributeBuilder.addPropValue(styleBuffer, bottomMargin);
                AttributeBuilder.addPropValue(styleBuffer, leftMargin);
                styleBuffer.append(';');
            }
        } else {
            AttributeBuilder.buildProperty(styleBuffer, "margin-top", topMargin);
            AttributeBuilder.buildProperty(styleBuffer, "margin-right", rightMargin);
            AttributeBuilder.buildProperty(styleBuffer, "margin-bottom", bottomMargin);
            AttributeBuilder.buildProperty(styleBuffer, "margin-left", leftMargin);
        }
    }

    public static void buildPaddings(StringBuffer styleBuffer, IStyle style) {
        String topPadding = style.getPaddingTop();
        String rightPadding = style.getPaddingRight();
        String bottomPadding = style.getPaddingBottom();
        String leftPadding = style.getPaddingLeft();
        if (topPadding != null && rightPadding != null && bottomPadding != null && leftPadding != null) {
            if (rightPadding.equals(leftPadding)) {
                if (topPadding.equals(bottomPadding)) {
                    if (topPadding.equals(rightPadding)) {
                        AttributeBuilder.buildProperty(styleBuffer, "padding", topPadding);
                    } else {
                        AttributeBuilder.addPropName(styleBuffer, "padding");
                        AttributeBuilder.addPropValue(styleBuffer, topPadding);
                        AttributeBuilder.addPropValue(styleBuffer, rightPadding);
                        styleBuffer.append(';');
                    }
                } else {
                    AttributeBuilder.addPropName(styleBuffer, "padding");
                    AttributeBuilder.addPropValue(styleBuffer, topPadding);
                    AttributeBuilder.addPropValue(styleBuffer, rightPadding);
                    AttributeBuilder.addPropValue(styleBuffer, bottomPadding);
                    styleBuffer.append(';');
                }
            } else {
                AttributeBuilder.addPropName(styleBuffer, "padding");
                AttributeBuilder.addPropValue(styleBuffer, topPadding);
                AttributeBuilder.addPropValue(styleBuffer, rightPadding);
                AttributeBuilder.addPropValue(styleBuffer, bottomPadding);
                AttributeBuilder.addPropValue(styleBuffer, leftPadding);
                styleBuffer.append(';');
            }
        } else {
            AttributeBuilder.buildProperty(styleBuffer, "padding-top", topPadding);
            AttributeBuilder.buildProperty(styleBuffer, "padding-right", rightPadding);
            AttributeBuilder.buildProperty(styleBuffer, "padding-bottom", bottomPadding);
            AttributeBuilder.buildProperty(styleBuffer, "padding-left", leftPadding);
        }
    }

    public static void buildBorders(StringBuffer styleBuffer, IStyle style) {
        String topBorderWidth = style.getBorderTopWidth();
        String topBorderStyle = style.getBorderTopStyle();
        String topBorderColor = style.getBorderTopColor();
        String rightBorderWidth = style.getBorderRightWidth();
        String rightBorderStyle = style.getBorderRightStyle();
        String rightBorderColor = style.getBorderRightColor();
        String bottomBorderWidth = style.getBorderBottomWidth();
        String bottomBorderStyle = style.getBorderBottomStyle();
        String bottomBorderColor = style.getBorderBottomColor();
        String leftBorderWidth = style.getBorderLeftWidth();
        String leftBorderStyle = style.getBorderLeftStyle();
        String leftBorderColor = style.getBorderLeftColor();
        if ((topBorderWidth != null && topBorderWidth.equals(rightBorderWidth) && topBorderWidth.equals(bottomBorderWidth) && topBorderWidth.equals(leftBorderWidth) || topBorderWidth == null && rightBorderWidth == null && bottomBorderWidth == null && leftBorderWidth == null) && (topBorderStyle != null && topBorderStyle.equals(rightBorderStyle) && topBorderStyle.equals(bottomBorderStyle) && topBorderStyle.equals(leftBorderStyle) || topBorderStyle == null && rightBorderStyle == null && bottomBorderStyle == null && leftBorderStyle == null) && (topBorderColor != null && topBorderColor.equals(rightBorderColor) && topBorderColor.equals(bottomBorderColor) && topBorderColor.equals(leftBorderColor) || topBorderColor == null && rightBorderColor == null && bottomBorderColor == null && leftBorderColor == null)) {
            AttributeBuilder.buildBorder(styleBuffer, "border", topBorderWidth, topBorderStyle, topBorderColor);
            return;
        }
        AttributeBuilder.buildBorder(styleBuffer, "border-top", topBorderWidth, topBorderStyle, topBorderColor);
        AttributeBuilder.buildBorder(styleBuffer, "border-right", rightBorderWidth, rightBorderStyle, rightBorderColor);
        AttributeBuilder.buildBorder(styleBuffer, "border-bottom", bottomBorderWidth, bottomBorderStyle, bottomBorderColor);
        AttributeBuilder.buildBorder(styleBuffer, "border-left", leftBorderWidth, leftBorderStyle, leftBorderColor);
    }

    public static void buildText(StringBuffer styleBuffer, IStyle style) {
        AttributeBuilder.buildProperty(styleBuffer, "text-indent", style.getTextIndent());
        AttributeBuilder.buildProperty(styleBuffer, "letter-spacing", style.getLetterSpacing());
        AttributeBuilder.buildProperty(styleBuffer, "word-spacing", style.getWordSpacing());
        AttributeBuilder.buildProperty(styleBuffer, "text-transform", style.getTextTransform());
        AttributeBuilder.buildProperty(styleBuffer, "white-space", style.getWhiteSpace());
    }

    public static void buildFont(StringBuffer styleBuffer, IStyle style) {
        AttributeBuilder.buildProperty(styleBuffer, "font-family", style.getFontFamily());
        AttributeBuilder.buildProperty(styleBuffer, "font-style", style.getFontStyle());
        AttributeBuilder.buildProperty(styleBuffer, "font-variant", style.getFontVariant());
        AttributeBuilder.buildProperty(styleBuffer, "font-weight", style.getFontWeight());
        AttributeBuilder.buildProperty(styleBuffer, "font-size", style.getFontSize());
        AttributeBuilder.buildProperty(styleBuffer, "color", style.getColor());
    }

    public static void buildTextDecoration(StringBuffer styleBuffer, IStyle style) {
        CSSValue linethrough = style.getProperty(16);
        CSSValue underline = style.getProperty(8);
        CSSValue overline = style.getProperty(7);
        if (linethrough == IStyle.LINE_THROUGH_VALUE || underline == IStyle.UNDERLINE_VALUE || overline == IStyle.OVERLINE_VALUE) {
            styleBuffer.append(" text-decoration:");
            if (IStyle.LINE_THROUGH_VALUE == linethrough) {
                AttributeBuilder.addPropValue(styleBuffer, "line-through");
            }
            if (IStyle.UNDERLINE_VALUE == underline) {
                AttributeBuilder.addPropValue(styleBuffer, "underline");
            }
            if (IStyle.OVERLINE_VALUE == overline) {
                AttributeBuilder.addPropValue(styleBuffer, "overline");
            }
            styleBuffer.append(';');
        }
    }

    static void buildBorder(StringBuffer styleBuffer, String name, String width, String style, String color) {
        if (style == null || style.length() <= 0) {
            return;
        }
        AttributeBuilder.addPropName(styleBuffer, name);
        AttributeBuilder.addPropValue(styleBuffer, width);
        AttributeBuilder.addPropValue(styleBuffer, style);
        AttributeBuilder.addPropValue(styleBuffer, color == null ? "black" : color);
        styleBuffer.append(';');
    }

    public static void buildSize(StringBuffer styleBuffer, String name, DimensionType value) {
        if (value != null) {
            if ("min-height".equals(name)) {
                AttributeBuilder.addPropName(styleBuffer, "height");
                AttributeBuilder.addPropValue(styleBuffer, "auto !important");
                styleBuffer.append(';');
                AttributeBuilder.addPropName(styleBuffer, "height");
                AttributeBuilder.addPropValue(styleBuffer, value.toString());
                styleBuffer.append(';');
                AttributeBuilder.addPropName(styleBuffer, "min-height");
                AttributeBuilder.addPropValue(styleBuffer, value.toString());
                styleBuffer.append(';');
            } else {
                AttributeBuilder.addPropName(styleBuffer, name);
                AttributeBuilder.addPropValue(styleBuffer, value.toString());
                styleBuffer.append(';');
            }
        }
    }

    private static void buildProperty(StringBuffer styleBuffer, String name, String value) {
        if (value != null) {
            AttributeBuilder.addPropName(styleBuffer, name);
            AttributeBuilder.addPropValue(styleBuffer, value);
            styleBuffer.append(';');
        }
    }

    private static void buildURLProperty(StringBuffer styleBuffer, String name, String url) {
        if (url != null) {
            AttributeBuilder.addPropName(styleBuffer, name);
            AttributeBuilder.addURLValue(styleBuffer, url);
            styleBuffer.append(';');
        }
    }

    private static void addPropName(StringBuffer styleBuffer, String name) {
        styleBuffer.append(' ');
        styleBuffer.append(name);
        styleBuffer.append(':');
    }

    private static void addPropValue(StringBuffer styleBuffer, String value) {
        if (value != null) {
            styleBuffer.append(' ');
            styleBuffer.append(value);
        }
    }

    private static void addURLValue(StringBuffer styleBuffer, String url) {
        if (url == null) {
            return;
        }
        StringBuffer escapedUrl = null;
        int i = 0;
        int max = url.length();
        int delta = 0;
        while (i < max) {
            char c = url.charAt(i);
            String replacement = null;
            if (c == '\\') {
                replacement = "%5c";
            } else if (c == '#') {
                replacement = "%23";
            } else if (c == '%') {
                replacement = "%25";
            } else if (c == '\'') {
                replacement = "%27";
            } else if (c >= '\u0080') {
                replacement = String.valueOf('%') + Integer.toHexString(c);
            }
            if (replacement != null) {
                if (escapedUrl == null) {
                    escapedUrl = new StringBuffer(url);
                }
                escapedUrl.replace(i + delta, i + delta + 1, replacement);
                delta += replacement.length() - 1;
            }
            ++i;
        }
        if (escapedUrl != null) {
            url = escapedUrl.toString();
        }
        if (url.length() > 0) {
            styleBuffer.append(" url('");
            styleBuffer.append(url);
            styleBuffer.append("')");
        }
    }
}

