/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import com.ibm.icu.util.ULocale;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.HTMLEmitterConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.html.HTMLEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLPerformanceOptimize;
import org.eclipse.birt.report.engine.emitter.html.HTMLVisionOptimize;
import org.eclipse.birt.report.engine.emitter.html.HTMLWriter;
import org.eclipse.birt.report.engine.emitter.html.IDGenerator;
import org.eclipse.birt.report.engine.emitter.html.MetadataEmitter;
import org.eclipse.birt.report.engine.emitter.html.util.HTMLEmitterUtil;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.css.HTMLProcessor;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.parser.TextParser;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSValue;

public class HTMLReportEmitter
extends ContentEmitterAdapter {
    public static final String OUTPUT_FORMAT_HTML = "html";
    public static final String REPORT_FILE = "report.html";
    public static final String IMAGE_FOLDER = "image";
    protected OutputStream out = null;
    protected IReportContent report;
    protected IReportRunnable runnable;
    protected IRenderOption renderOption;
    protected boolean outputMasterPageContent = true;
    protected boolean isEmbeddable = false;
    protected String urlEncoding = null;
    protected boolean htmlRtLFlag = false;
    protected boolean pageFooterFloatFlag = true;
    protected boolean enableMetadata = false;
    protected List ouputInstanceIDs = null;
    protected int pageNo = 0;
    protected HTMLWriter writer;
    protected IReportContext reportContext;
    protected Stack stack = new Stack();
    protected static Logger logger;
    protected IHTMLImageHandler imageHandler;
    protected IHTMLActionHandler actionHandler;
    protected IEmitterServices services;
    protected static final int DISPLAY_BLOCK = 1;
    protected static final int DISPLAY_INLINE = 2;
    protected static final int DISPLAY_INLINE_BLOCK = 4;
    protected static final int DISPLAY_NONE = 8;
    protected static final int DISPLAY_FLAG_ALL = 65535;
    protected ContentEmitterVisitor contentVisitor;
    private MetadataEmitter metadataEmitter;
    private IDGenerator idGenerator = new IDGenerator();
    private String layoutPreference;
    private boolean enableAgentStyleEngine;
    private boolean outputMasterPageMargins;
    private HTMLEmitter htmlEmitter;
    protected Stack tableDIVWrapedFlagStack = new Stack();
    private Set outputtedStyles = new HashSet();
    protected Stack startedGroups = new Stack();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public HTMLReportEmitter() {
        this.contentVisitor = new ContentEmitterVisitor((IContentEmitter)this);
    }

    public void initialize(IEmitterServices services) {
        Object ac;
        Object im;
        Object emitterConfig;
        this.services = services;
        Object fd = services.getOption("outputFile");
        File file = null;
        try {
            if (fd != null) {
                file = new File(fd.toString());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                this.out = new BufferedOutputStream(new FileOutputStream(file));
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (this.out == null) {
            Object value = services.getOption("outputStream");
            if (value != null && value instanceof OutputStream) {
                this.out = (OutputStream)value;
            } else {
                try {
                    file = new File(REPORT_FILE);
                    this.out = new BufferedOutputStream(new FileOutputStream(file));
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        if ((emitterConfig = services.getEmitterConfig().get(OUTPUT_FORMAT_HTML)) != null && emitterConfig instanceof HTMLEmitterConfig) {
            this.imageHandler = ((HTMLEmitterConfig)emitterConfig).getImageHandler();
            this.actionHandler = ((HTMLEmitterConfig)emitterConfig).getActionHandler();
        }
        if ((im = services.getOption("imageHandler")) != null && im instanceof IHTMLImageHandler) {
            this.imageHandler = (IHTMLImageHandler)im;
        }
        if ((ac = services.getOption("actionHandler")) != null && ac instanceof IHTMLActionHandler) {
            this.actionHandler = (IHTMLActionHandler)ac;
        }
        this.reportContext = services.getReportContext();
        this.renderOption = services.getRenderOption();
        this.runnable = services.getReportRunnable();
        this.writer = new HTMLWriter();
        if (this.renderOption != null) {
            HTMLRenderOption htmlOption = new HTMLRenderOption(this.renderOption);
            this.isEmbeddable = htmlOption.getEmbeddable();
            HashMap options = this.renderOption.getOutputSetting();
            if (options != null) {
                this.urlEncoding = (String)options.get("url-encoding");
            }
            this.outputMasterPageContent = htmlOption.getMasterPageContent();
            IHTMLActionHandler actHandler = htmlOption.getActionHandle();
            if (ac != null) {
                this.actionHandler = actHandler;
            }
            this.pageFooterFloatFlag = htmlOption.getPageFooterFloatFlag();
            this.htmlRtLFlag = htmlOption.getHtmlRtLFlag();
            this.enableMetadata = htmlOption.getEnableMetadata();
            this.ouputInstanceIDs = htmlOption.getInstanceIDs();
            this.metadataEmitter = new MetadataEmitter(this.writer, htmlOption, this.idGenerator);
            this.layoutPreference = htmlOption.getLayoutPreference();
            this.enableAgentStyleEngine = htmlOption.getEnableAgentStyleEngine();
            this.outputMasterPageMargins = htmlOption.getOutputMasterPageMargins();
        }
    }

    public IReportContent getReport() {
        return this.report;
    }

    public String getOutputFormat() {
        return OUTPUT_FORMAT_HTML;
    }

    protected void fixTransparentPNG() {
        this.writer.writeCode("<!--[if gte IE 5.5000]>");
        this.writer.writeCode("   <script language=\"JavaScript\"> var ie55up = true </script>");
        this.writer.writeCode("<![endif]-->");
        this.writer.writeCode("<script language=\"JavaScript\">");
        this.writer.writeCode("   function fixPNG(myImage) // correctly handle PNG transparency in Win IE 5.5 or higher.");
        this.writer.writeCode("      {");
        this.writer.writeCode("      if (window.ie55up)");
        this.writer.writeCode("         {");
        this.writer.writeCode("         var imgID = (myImage.id) ? \"id='\" + myImage.id + \"' \" : \"\"");
        this.writer.writeCode("         var imgClass = (myImage.className) ? \"class='\" + myImage.className + \"' \" : \"\"");
        this.writer.writeCode("         var imgTitle = (myImage.title) ? \"title='\" + myImage.title + \"' \" : \"title='\" + myImage.alt + \"' \"");
        this.writer.writeCode("         var imgStyle = \"display:inline-block;\" + myImage.style.cssText");
        this.writer.writeCode("         var strNewHTML = \"<span \" + imgID + imgClass + imgTitle");
        this.writer.writeCode("         strNewHTML += \" style=\\\"\" + \"width:\" + myImage.width + \"px; height:\" + myImage.height + \"px;\" + imgStyle + \";\"");
        this.writer.writeCode("         strNewHTML += \"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader\"");
        this.writer.writeCode("         strNewHTML += \"(src=\\'\" + myImage.src + \"\\', sizingMethod='scale');\\\"></span>\"");
        this.writer.writeCode("         myImage.outerHTML = strNewHTML");
        this.writer.writeCode("         }");
        this.writer.writeCode("      }");
        this.writer.writeCode("</script>");
    }

    protected void fixRedirect() {
        this.writer.writeCode("<script language=\"javascript\">");
        this.writer.writeCode("          function redirect(target, url){\n");
        this.writer.writeCode("                          if (target =='_blank'){\n");
        this.writer.writeCode("                                          open(url);\n");
        this.writer.writeCode("                          }\n");
        this.writer.writeCode("                          else if (target == '_top'){\n");
        this.writer.writeCode("          window.top.location.href=url;\n");
        this.writer.writeCode("                          }\n");
        this.writer.writeCode("                          else if (target == '_parent'){\n");
        this.writer.writeCode("          location.href=url;\n");
        this.writer.writeCode("                          }\n");
        this.writer.writeCode("                          else if (target == '_self'){\n");
        this.writer.writeCode("          location.href =url;\n");
        this.writer.writeCode("                          }\n");
        this.writer.writeCode("                          else{\n");
        this.writer.writeCode("                                          open(url);\n");
        this.writer.writeCode("                          }\n");
        this.writer.writeCode("          }\n");
        this.writer.writeCode("</script>");
    }

    public void start(IReportContent report) {
        IStyle style;
        String reportStyleName;
        logger.log(Level.FINE, "[HTMLReportEmitter] Start emitter.");
        this.report = report;
        this.writer.open(this.out, "UTF-8");
        if (this.htmlRtLFlag) {
            IStyle style2;
            String reportStyleName2;
            String string = reportStyleName2 = report == null ? null : report.getDesign().getRootStyleName();
            if (reportStyleName2 != null && (style2 = report.findStyle(reportStyleName2)) != null) {
                style2.setProperty(26, (CSSValue)IStyle.RIGHT_VALUE);
            }
        }
        if (this.layoutPreference == null && report != null) {
            Report reportDesign = report.getDesign();
            ReportDesignHandle designHandle = reportDesign.getReportDesign();
            String reportLayoutPreference = designHandle.getLayoutPreference();
            if ("fixed layout".equals(reportLayoutPreference)) {
                this.layoutPreference = "fixed";
            } else if ("auto layout".equals(reportLayoutPreference)) {
                this.layoutPreference = "auto";
            }
        }
        this.htmlEmitter = this.enableAgentStyleEngine ? new HTMLPerformanceOptimize(this, this.writer, this.isEmbeddable, this.layoutPreference) : new HTMLVisionOptimize(this, this.writer, this.isEmbeddable, this.layoutPreference);
        StringBuffer defaultStyleBuffer = new StringBuffer();
        if (report != null && (reportStyleName = report.getDesign().getRootStyleName()) != null) {
            style = report.findStyle(reportStyleName);
            this.htmlEmitter.buildDefaultStyle(defaultStyleBuffer, style);
        }
        if (this.isEmbeddable) {
            this.fixTransparentPNG();
            this.fixRedirect();
            this.writer.openTag("div");
            this.writer.attribute("style", defaultStyleBuffer.toString());
            return;
        }
        this.writer.startWriter();
        this.writer.openTag(OUTPUT_FORMAT_HTML);
        this.writer.openTag("head");
        Report reportDesign = null;
        if (report != null) {
            reportDesign = report.getDesign();
            ReportDesignHandle designHandle = reportDesign.getReportDesign();
            String title = designHandle.getStringProperty("title");
            if (title == null && this.renderOption != null) {
                HTMLRenderOption htmlOption = new HTMLRenderOption(this.renderOption);
                title = htmlOption.getHtmlTitle();
            }
            if (title != null) {
                this.writer.openTag("title");
                this.writer.text(title);
                this.writer.closeTag("title");
            }
        }
        this.writer.openTag("META");
        this.writer.attribute("http-equiv", "Content-Type");
        this.writer.attribute("content", "text/html; charset=UTF-8");
        this.writer.closeNoEndTag();
        this.writer.openTag("style");
        this.writer.attribute("type", "text/css");
        StringBuffer styleBuffer = new StringBuffer();
        String defaultStyleName = "style_report";
        if (report == null) {
            logger.log(Level.WARNING, "[HTMLReportEmitter] Report object is null.");
        } else {
            this.writer.style(String.valueOf('.') + defaultStyleName, defaultStyleBuffer.toString());
            Map styles = reportDesign.getStyles();
            Iterator iter = styles.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String styleName = (String)entry.getKey();
                style = (IStyle)entry.getValue();
                styleBuffer.setLength(0);
                this.htmlEmitter.buildStyle(styleBuffer, style);
                if (styleBuffer.length() <= 0) continue;
                this.writer.style(String.valueOf('.') + styleName, styleBuffer.toString());
                this.outputtedStyles.add(styleName);
            }
        }
        this.writer.closeTag("style");
        this.fixTransparentPNG();
        this.fixRedirect();
        this.writer.closeTag("head");
        this.writer.openTag("body");
        if (defaultStyleBuffer.length() > 0) {
            this.writer.attribute("class", defaultStyleName);
        }
        this.writer.attribute("style", " margin:0px;");
    }

    private void appendErrorMessage(EngineResourceHandle rc, int index, ExecutionContext.ElementExceptionInfo info) {
        this.writer.writeCode("\t\t\t<div>");
        this.writer.writeCode("\t\t\t\t<div  id=\"error_title\" style=\"text-decoration:underline\">");
        String name = info.getName();
        if (name != null) {
            this.writer.text(rc.getMessage("Error.ReportErrorMessage", new Object[]{info.getType(), name}), false);
        } else {
            this.writer.text(rc.getMessage("Error.ReportErrorMessageWithID", new Object[]{info.getType(), info.getID()}), false);
        }
        this.writer.writeCode("</div>");
        ArrayList errorList = info.getErrorList();
        ArrayList countList = info.getCountList();
        int i = 0;
        while (i < errorList.size()) {
            String errorId = "document.getElementById('error_detail" + index + "_" + i + "')";
            String errorIcon = "document.getElementById('error_icon" + index + "_" + i + "')";
            String onClick = "if (" + errorId + ".style.display == 'none') { " + errorIcon + ".innerHTML = '- '; " + errorId + ".style.display = 'block'; }" + "else { " + errorIcon + ".innerHTML = '+ '; " + errorId + ".style.display = 'none'; }";
            this.writer.writeCode("<div>");
            BirtException ex = (BirtException)errorList.get(i);
            this.writer.writeCode("<span id=\"error_icon" + index + "_" + i + "\"  style=\"cursor:pointer\" onclick=\"" + onClick + "\" > + </span>");
            this.writer.text(ex.getLocalizedMessage());
            this.writer.writeCode("\t\t\t\t<pre id=\"error_detail" + index + "_" + i + "\" style=\"display:none;\" >");
            String messageTitle = rc.getMessage("Error.ReportErrorID", new Object[]{ex.getErrorCode(), countList.get(i)});
            String detailTag = rc.getMessage("Error.ReportErrorDetail");
            String messageBody = this.getDetailMessage((Throwable)ex);
            boolean indent = this.writer.isIndent();
            this.writer.setIndent(false);
            this.writer.text(messageTitle, false);
            this.writer.writeCode("\r\n");
            this.writer.text(detailTag, false);
            this.writer.text(messageBody, false);
            this.writer.setIndent(indent);
            this.writer.writeCode("\t\t\t\t</pre>");
            this.writer.writeCode("</div>");
            ++i;
        }
        this.writer.writeCode("</div>");
        this.writer.writeCode("<br>");
    }

    private String getDetailMessage(Throwable t) {
        StringWriter out = new StringWriter();
        PrintWriter print = new PrintWriter(out);
        try {
            t.printStackTrace(print);
        }
        catch (Throwable throwable) {}
        print.flush();
        return out.getBuffer().toString();
    }

    protected boolean outputErrors(List errors) {
        if (errors != null && !errors.isEmpty()) {
            this.writer.writeCode("\t<hr style=\"color:red\"/>");
            this.writer.writeCode("\t<div style=\"color:red\">");
            this.writer.writeCode("\t\t<div>");
            Locale locale = this.reportContext.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            EngineResourceHandle rc = new EngineResourceHandle(ULocale.forLocale((Locale)locale));
            this.writer.text(rc.getMessage("Error.ErrorOnReportPage"), false);
            this.writer.writeCode("</div>");
            this.writer.writeCode("<br>");
            Iterator it = errors.iterator();
            int index = 0;
            while (it.hasNext()) {
                this.appendErrorMessage(rc, index++, (ExecutionContext.ElementExceptionInfo)it.next());
            }
            this.writer.writeCode("</div>");
            return true;
        }
        return false;
    }

    public void end(IReportContent report) {
        List errors;
        logger.log(Level.FINE, "[HTMLReportEmitter] End body.");
        if (report != null && (errors = report.getErrors()) != null && !errors.isEmpty()) {
            this.outputErrors(errors);
        }
        if (!this.isEmbeddable) {
            this.writer.closeTag("body");
            this.writer.closeTag(OUTPUT_FORMAT_HTML);
        } else {
            this.writer.closeTag("div");
        }
        this.writer.endWriter();
        this.writer.close();
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public void startPage(IPageContent page) {
        ++this.pageNo;
        if (this.pageNo > 1 && !this.outputMasterPageContent) {
            this.writer.openTag("hr");
            this.writer.closeTag("hr");
        }
        this.writer.openTag("div");
        if (page != null) {
            DimensionType leftMargin;
            boolean implementMargins;
            boolean outputPageHeight;
            boolean fixedReport;
            StringBuffer styleBuffer = new StringBuffer();
            if (this.pageNo > 1) {
                styleBuffer.append("page-break-before: always;");
            }
            if ((fixedReport = "fixed".equals(this.layoutPreference)) || this.outputMasterPageContent) {
                this.htmlEmitter.buildPageStyle(page, styleBuffer);
            }
            this.writer.attribute("style", styleBuffer.toString());
            this.writer.openTag("table");
            this.writer.attribute("cellpadding", "0");
            styleBuffer.setLength(0);
            styleBuffer.append(" border-collapse: collapse; empty-cells: show; width:100%;");
            boolean bl = outputPageHeight = fixedReport || this.outputMasterPageContent && !this.pageFooterFloatFlag;
            if (outputPageHeight) {
                this.htmlEmitter.buildSize(styleBuffer, "height", page.getPageHeight());
            }
            if (fixedReport) {
                styleBuffer.append(" table-layout:fixed;");
            }
            this.writer.attribute("style", styleBuffer.toString());
            boolean bl2 = implementMargins = fixedReport || this.outputMasterPageContent && this.outputMasterPageMargins;
            if (implementMargins) {
                this.writer.openTag("col");
                styleBuffer.setLength(0);
                styleBuffer.append("width: ");
                leftMargin = page.getMarginLeft();
                if (leftMargin != null) {
                    styleBuffer.append(leftMargin.toString());
                } else {
                    styleBuffer.append("0pt");
                }
                styleBuffer.append(";");
                this.writer.attribute("style", styleBuffer.toString());
                this.writer.closeNoEndTag();
                this.writer.openTag("col");
                this.writer.closeNoEndTag();
                this.writer.openTag("col");
                styleBuffer.setLength(0);
                styleBuffer.append("width: ");
                DimensionType rightMargin = page.getMarginRight();
                if (rightMargin != null) {
                    styleBuffer.append(rightMargin.toString());
                } else {
                    styleBuffer.append("0pt");
                }
                styleBuffer.append(";");
                this.writer.attribute("style", styleBuffer.toString());
                this.writer.closeNoEndTag();
                DimensionType topMargin = page.getMarginTop();
                if (topMargin != null) {
                    this.writer.openTag("tr");
                    styleBuffer.setLength(0);
                    styleBuffer.append("height: ");
                    styleBuffer.append(topMargin.toString());
                    styleBuffer.append(";");
                    this.writer.attribute("style", styleBuffer.toString());
                    this.writer.openTag("td");
                    this.writer.attribute("colspan", 3);
                    this.writer.closeTag("td");
                    this.writer.closeTag("tr");
                }
            }
            this.writer.openTag("tr");
            if (outputPageHeight && !this.pageFooterFloatFlag) {
                this.writer.attribute("style", " height: 100%;");
            }
            if (implementMargins) {
                this.writer.openTag("td");
                this.writer.attribute("rowspan", 2);
                leftMargin = page.getMarginLeft();
                if (leftMargin != null) {
                    this.writer.openTag("div");
                    styleBuffer.setLength(0);
                    styleBuffer.append("width: ");
                    styleBuffer.append(leftMargin.toString());
                    styleBuffer.append(";");
                    this.writer.attribute("style", styleBuffer.toString());
                    this.writer.closeTag("div");
                }
                this.writer.closeTag("td");
            }
            this.writer.openTag("td");
            if (fixedReport) {
                this.writer.attribute("style", " overflow: hidden;");
            }
            this.writer.attribute("valign", "top");
            if (this.htmlRtLFlag) {
                this.writer.attribute("dir", "RTL");
            }
            if (this.outputMasterPageContent) {
                SimpleMasterPageDesign masterPage;
                boolean showHeader = true;
                Object genBy = page.getGenerateBy();
                if (genBy instanceof SimpleMasterPageDesign && !(masterPage = (SimpleMasterPageDesign)genBy).isShowHeaderOnFirst() && page.getPageNumber() == 1L) {
                    showHeader = false;
                }
                if (showHeader) {
                    this.writer.openTag("div");
                    styleBuffer.setLength(0);
                    this.htmlEmitter.buildPageBandStyle(styleBuffer, page.getStyle());
                    this.writer.attribute("style", styleBuffer.toString());
                    this.contentVisitor.visitChildren(page.getPageHeader(), null);
                    this.writer.closeTag("div");
                }
            }
        }
        this.writer.openTag("div");
    }

    public void endPage(IPageContent page) {
        logger.log(Level.FINE, "[HTMLReportEmitter] End page.");
        this.writer.closeTag("div");
        if (page != null) {
            DimensionType bottomMargin;
            boolean outputPageHeight;
            boolean implementMargins;
            this.writer.closeTag("td");
            boolean fixedReport = "fixed".equals(this.layoutPreference);
            boolean bl = implementMargins = fixedReport || this.outputMasterPageContent && this.outputMasterPageMargins;
            if (implementMargins) {
                this.writer.openTag("td");
                this.writer.attribute("rowspan", 2);
                DimensionType rightMargin = page.getMarginRight();
                if (rightMargin != null) {
                    this.writer.openTag("div");
                    StringBuffer styleBuffer = new StringBuffer();
                    styleBuffer.append("width: ");
                    styleBuffer.append(rightMargin.toString());
                    styleBuffer.append(";");
                    this.writer.attribute("style", styleBuffer.toString());
                    this.writer.closeTag("div");
                }
                this.writer.closeTag("td");
            }
            this.writer.closeTag("tr");
            this.writer.openTag("tr");
            boolean bl2 = outputPageHeight = fixedReport || this.outputMasterPageContent && !this.pageFooterFloatFlag;
            if (outputPageHeight && this.pageFooterFloatFlag) {
                this.writer.attribute("style", " height: 100%;");
            }
            this.writer.openTag("td");
            if (fixedReport) {
                this.writer.attribute("style", " overflow: hidden;");
            }
            this.writer.attribute("valign", "top");
            if (this.htmlRtLFlag) {
                this.writer.attribute("dir", "RTL");
            }
            if (this.outputMasterPageContent) {
                SimpleMasterPageDesign masterPage;
                boolean showFooter = true;
                Object genBy = page.getGenerateBy();
                if (genBy instanceof SimpleMasterPageDesign && !(masterPage = (SimpleMasterPageDesign)genBy).isShowFooterOnLast()) {
                    long totalPage = page.getPageNumber();
                    IReportContent report = page.getReportContent();
                    if (report != null) {
                        totalPage = report.getTotalPage();
                    }
                    if (page.getPageNumber() == totalPage) {
                        showFooter = false;
                    }
                }
                if (showFooter) {
                    this.writer.openTag("div");
                    StringBuffer styleBuffer = new StringBuffer();
                    this.htmlEmitter.buildPageBandStyle(styleBuffer, page.getStyle());
                    this.writer.attribute("style", styleBuffer.toString());
                    this.contentVisitor.visitChildren(page.getPageFooter(), null);
                    this.writer.closeTag("div");
                }
            }
            this.writer.closeTag("td");
            this.writer.closeTag("tr");
            if (implementMargins && (bottomMargin = page.getMarginBottom()) != null) {
                this.writer.openTag("tr");
                StringBuffer styleBuffer = new StringBuffer();
                styleBuffer.append("height: ");
                styleBuffer.append(bottomMargin.toString());
                styleBuffer.append(";");
                this.writer.attribute("style", styleBuffer.toString());
                this.writer.openTag("td");
                this.writer.attribute("colspan", 3);
                this.writer.closeTag("td");
                this.writer.closeTag("tr");
            }
            this.writer.closeTag("table");
        }
        this.writer.closeTag("div");
    }

    public void startTable(ITableContent table) {
        CSSValue display;
        if (!$assertionsDisabled && table == null) {
            throw new AssertionError();
        }
        boolean DIVWrap = false;
        IStyle style = table.getStyle();
        if (this.needImplementAlignTable(table)) {
            this.writer.openTag("div");
            DIVWrap = true;
            this.writer.attribute("align", style.getTextAlign());
        }
        if (IStyle.INLINE_VALUE == (display = style.getProperty(33)) || IStyle.INLINE_BLOCK_VALUE == display) {
            if (!DIVWrap) {
                this.writer.openTag("div");
                DIVWrap = true;
            }
            this.writer.attribute("style", " display:-moz-inline-box !important; display:inline;");
        }
        this.tableDIVWrapedFlagStack.push(new Boolean(DIVWrap));
        logger.log(Level.FINE, "[HTMLTableEmitter] Start table");
        if (this.enableMetadata) {
            this.metadataEmitter.startWrapTable(table);
        }
        this.writer.openTag("table");
        String styleClass = table.getStyleClass();
        this.setStyleName(styleClass);
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildTableStyle(table, styleBuffer);
        this.writer.attribute("style", styleBuffer.toString());
        String bookmark = table.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            table.setBookmark(bookmark);
        }
        HTMLEmitterUtil.setBookmark(this.writer, null, bookmark);
        HTMLEmitterUtil.setActiveIDTypeIID(this.writer, this.ouputInstanceIDs, (IContent)table);
        String caption = table.getCaption();
        if (caption != null && caption.length() > 0) {
            this.writer.openTag("caption");
            this.writer.text(caption);
            this.writer.closeTag("caption");
        }
        if (this.enableMetadata) {
            this.metadataEmitter.startTable(table);
        }
        this.writeColumns(table);
    }

    protected void writeColumns(ITableContent table) {
        int i = 0;
        while (i < table.getColumnCount()) {
            IColumn column = table.getColumn(i);
            if (!this.isColumnHidden(column)) {
                InstanceID iid;
                this.writer.openTag("col");
                if (this.enableAgentStyleEngine) {
                    String styleClass = column.getStyleClass();
                    this.setStyleName(styleClass);
                }
                StringBuffer styleBuffer = new StringBuffer();
                this.htmlEmitter.buildColumnStyle(column, styleBuffer);
                this.writer.attribute("style", styleBuffer.toString());
                this.htmlEmitter.handleColumnAlign(column);
                if (this.enableMetadata && (iid = column.getInstanceID()) != null) {
                    this.writer.attribute("iid", iid.toString());
                }
                this.writer.closeNoEndTag();
            }
            ++i;
        }
    }

    private boolean isColumnHidden(IColumn column) {
        String formats = column.getVisibleFormat();
        return formats != null && (formats.indexOf("viewer") >= 0 || formats.indexOf("all") >= 0);
    }

    public void endTable(ITableContent table) {
        boolean DIVWrap;
        if (this.enableMetadata) {
            this.metadataEmitter.endTable(table);
        }
        this.writer.closeTag("table");
        if (this.enableMetadata) {
            this.metadataEmitter.endWrapTable(table);
        }
        if (DIVWrap = ((Boolean)this.tableDIVWrapedFlagStack.pop()).booleanValue()) {
            this.writer.closeTag("div");
        }
        logger.log(Level.FINE, "[HTMLTableEmitter] End table");
    }

    protected boolean needImplementAlignTable(ITableContent table) {
        CSSValue algin;
        IStyle style;
        CSSValue display;
        DimensionType width;
        return !(this.report.getRoot() != table.getParent() || (width = table.getWidth()) == null || "100%".equals(width.toString()) || (display = (style = table.getStyle()).getProperty(33)) != null && IStyle.BLOCK_VALUE != display || IStyle.CENTER_VALUE != (algin = style.getProperty(26)) && IStyle.RIGHT_VALUE != algin);
    }

    public void startTableHeader(ITableBandContent band) {
        this.writer.openTag("thead");
    }

    public void endTableHeader(ITableBandContent band) {
        this.writer.closeTag("thead");
    }

    public void startTableBody(ITableBandContent band) {
        this.writer.openTag("tbody");
    }

    public void endTableBody(ITableBandContent band) {
        this.writer.closeTag("tbody");
    }

    public void startTableFooter(ITableBandContent band) {
        this.writer.openTag("tfoot");
    }

    public void endTableFooter(ITableBandContent band) {
        this.writer.closeTag("tfoot");
    }

    public void startRow(IRowContent row) {
        if (!$assertionsDisabled && row == null) {
            throw new AssertionError();
        }
        this.writer.openTag("tr");
        if (this.enableMetadata) {
            this.metadataEmitter.startRow(row);
            this.outputRowMetaData(row);
        }
        String styleClass = row.getStyleClass();
        this.setStyleName(styleClass);
        HTMLEmitterUtil.setBookmark(this.writer, null, row.getBookmark());
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildRowStyle(row, styleBuffer);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleRowAlign(row);
        if (!this.startedGroups.isEmpty()) {
            IGroupContent group = (IGroupContent)this.startedGroups.firstElement();
            String bookmark = group.getBookmark();
            if (bookmark == null) {
                bookmark = this.idGenerator.generateUniqueID();
                group.setBookmark(bookmark);
            }
            this.writer.attribute("id", group.getBookmark());
            this.startedGroups.remove(group);
        }
    }

    protected void outputRowMetaData(IRowContent rowContent) {
        IElement parent = rowContent.getParent();
        if (parent instanceof ITableBandContent) {
            ITableBandContent bandContent = (ITableBandContent)parent;
            IGroupContent group = rowContent.getGroup();
            String groupId = rowContent.getGroupId();
            if (groupId != null) {
                this.writer.attribute("group-id", groupId);
            }
            String rowType = null;
            String metaType = null;
            int bandType = bandContent.getBandType();
            if (bandType == 1) {
                metaType = "wrth";
                rowType = "header";
            } else if (bandType == 2) {
                metaType = "wrtf";
                rowType = "footer";
            } else if (bandType == 3) {
                rowType = "group-header";
                if (group != null) {
                    metaType = "wrgh" + group.getGroupLevel();
                }
            } else if (bandType == 4) {
                rowType = "group-footer";
                if (group != null) {
                    metaType = "wrgf" + group.getGroupLevel();
                }
            }
            this.writer.attribute("type", metaType);
            this.writer.attribute("row-type", rowType);
        }
    }

    public void endRow(IRowContent row) {
        if (this.enableMetadata) {
            this.metadataEmitter.endRow(row);
        }
        this.writer.closeTag("tr");
    }

    private boolean isCellInTableHead(ICellContent cell) {
        int type;
        IElement tableBand;
        IElement row = cell.getParent();
        return row instanceof IRowContent && (tableBand = row.getParent()) instanceof ITableBandContent && (type = ((ITableBandContent)tableBand).getBandType()) == 1;
    }

    public void startCell(ICellContent cell) {
        int rowSpan;
        logger.log(Level.FINE, "[HTMLTableEmitter] Start cell.");
        boolean isHead = this.isCellInTableHead(cell);
        if (isHead) {
            this.writer.openTag("th");
        } else {
            this.writer.openTag("td");
        }
        String styleClass = cell.getStyleClass();
        this.setStyleName(styleClass);
        int colSpan = cell.getColSpan();
        if (colSpan > 1) {
            this.writer.attribute("colspan", colSpan);
        }
        if ((rowSpan = cell.getRowSpan()) > 1) {
            this.writer.attribute("rowspan", rowSpan);
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildCellStyle(cell, styleBuffer, isHead);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleCellAlign(cell);
        if (!this.startedGroups.isEmpty()) {
            IGroupContent group = (IGroupContent)this.startedGroups.firstElement();
            String bookmark = group.getBookmark();
            if (bookmark == null) {
                bookmark = this.idGenerator.generateUniqueID();
                group.setBookmark(bookmark);
            }
            this.writer.attribute("id", group.getBookmark());
            this.startedGroups.remove(group);
            Iterator iter = this.startedGroups.iterator();
            while (iter.hasNext()) {
                group = (IGroupContent)iter.next();
                this.outputBookmark(group);
            }
            this.startedGroups.clear();
        }
        if (this.enableMetadata) {
            this.metadataEmitter.startCell(cell);
        }
    }

    public void endCell(ICellContent cell) {
        logger.log(Level.FINE, "[HTMLReportEmitter] End cell.");
        if (this.enableMetadata) {
            this.metadataEmitter.endCell(cell);
        }
        if (this.isCellInTableHead(cell)) {
            this.writer.closeTag("th");
        } else {
            this.writer.closeTag("td");
        }
    }

    public void startContainer(IContainerContent container) {
        logger.log(Level.FINE, "[HTMLReportEmitter] Start container");
        this.htmlEmitter.openContainerTag(container);
        String styleClass = container.getStyleClass();
        this.setStyleName(styleClass);
        String bookmark = container.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            container.setBookmark(bookmark);
        }
        HTMLEmitterUtil.setBookmark(this.writer, "div", bookmark);
        HTMLEmitterUtil.setActiveIDTypeIID(this.writer, this.ouputInstanceIDs, (IContent)container);
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildContainerStyle(container, styleBuffer);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleContainerAlign(container);
    }

    public void endContainer(IContainerContent container) {
        this.htmlEmitter.closeContainerTag();
        logger.log(Level.FINE, "[HTMLContainerEmitter] End container");
    }

    public void startText(ITextContent text) {
        String tagName;
        IStyle mergedStyle = text.getStyle();
        logger.log(Level.FINE, "[HTMLReportEmitter] Start text");
        DimensionType x = text.getX();
        DimensionType y = text.getY();
        DimensionType width = text.getWidth();
        DimensionType height = text.getHeight();
        String textValue = text.getText();
        if (textValue == null || textValue == "") {
            textValue = " ";
        }
        int display = textValue != null && textValue.indexOf(10) >= 0 ? this.getElementType(x, y, width, height, mergedStyle) : this.getElementType(x, y, null, null, mergedStyle);
        String url = this.validate(text.getHyperlinkAction());
        boolean metadataOutput = false;
        if (url != null) {
            if (this.enableMetadata) {
                metadataOutput = this.metadataEmitter.startText(text, "span");
            }
            tagName = "a";
            this.outputAction(text.getHyperlinkAction(), url);
        } else {
            if (this.enableMetadata) {
                metadataOutput = this.metadataEmitter.startText(text, HTMLEmitterUtil.getTagByType(display, 65535));
            }
            tagName = this.openTagByType(display, 65535);
        }
        String styleClass = text.getStyleClass();
        this.setStyleName(styleClass);
        if (!metadataOutput) {
            this.outputBookmark((IContent)text, tagName);
        }
        this.writer.attribute("title", text.getHelpText());
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildTextStyle(text, styleBuffer, display, url);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleVerticalAlignBegin((IContent)text);
        this.writer.text(textValue);
        this.htmlEmitter.handleVerticalAlignEnd((IContent)text);
        this.writer.closeTag(tagName);
        if (this.enableMetadata) {
            this.metadataEmitter.endText(text);
        }
    }

    public void startForeign(IForeignContent foreign) {
        String tagName;
        IStyle mergedStyle = foreign.getStyle();
        logger.log(Level.FINE, "[HTMLReportEmitter] Start foreign");
        boolean isTemplate = false;
        Object genBy = foreign.getGenerateBy();
        if (genBy instanceof TemplateDesign) {
            isTemplate = true;
            this.setupTemplateElement((TemplateDesign)genBy, (IContent)foreign);
            this.writer.openTag("div");
            this.writer.attribute("align", "center");
        }
        DimensionType x = foreign.getX();
        DimensionType y = foreign.getY();
        DimensionType width = foreign.getWidth();
        DimensionType height = foreign.getHeight();
        int display = this.getElementType(x, y, width, height, mergedStyle);
        String url = this.validate(foreign.getHyperlinkAction());
        boolean metadataOutput = false;
        if (url != null) {
            if (this.enableMetadata) {
                metadataOutput = this.metadataEmitter.startForeign(foreign, "span");
            }
            tagName = "a";
            this.outputAction(foreign.getHyperlinkAction(), url);
        } else {
            if (this.enableMetadata) {
                metadataOutput = this.metadataEmitter.startForeign(foreign, HTMLEmitterUtil.getTagByType(display, 65535));
            }
            tagName = this.openTagByType(display, 65535);
        }
        String styleClass = foreign.getStyleClass();
        this.setStyleName(styleClass);
        if (!metadataOutput) {
            this.outputBookmark((IContent)foreign, tagName);
        }
        this.writer.attribute("title", foreign.getHelpText());
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildForeignStyle(foreign, styleBuffer, display, url);
        this.writer.attribute("style", styleBuffer.toString());
        String rawType = foreign.getRawType();
        boolean isHtml = "text/html".equalsIgnoreCase(rawType);
        if (isHtml) {
            this.htmlEmitter.handleVerticalAlignBegin((IContent)foreign);
            this.outputHtmlText(foreign);
            this.htmlEmitter.handleVerticalAlignEnd((IContent)foreign);
        }
        this.writer.closeTag(tagName);
        if (this.enableMetadata) {
            this.metadataEmitter.endForeign(foreign);
        }
        if (isTemplate) {
            this.writer.closeTag("div");
        }
    }

    private void outputHtmlText(IForeignContent foreign) {
        NodeList bodys;
        Object rawValue = foreign.getRawValue();
        String text = rawValue == null ? null : rawValue.toString();
        Document doc = new TextParser().parse(text, TextParser.TEXT_TYPE_HTML);
        ReportDesignHandle design = (ReportDesignHandle)this.runnable.getDesignHandle();
        HTMLProcessor htmlProcessor = new HTMLProcessor(design);
        HashMap styleMap = new HashMap();
        Element body = null;
        if (doc != null && (bodys = doc.getElementsByTagName("body")).getLength() > 0) {
            body = (Element)bodys.item(0);
        }
        if (body != null) {
            htmlProcessor.execute(body, styleMap);
            this.processNodes(body, styleMap);
        }
    }

    private void processNodes(Element ele, HashMap cssStyles) {
        Node node = ele.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3 || node.getNodeType() == 1) {
                if (!node.getNodeName().equals("#text")) {
                    this.startNode(node, cssStyles);
                }
                if (node.getNodeType() == 3) {
                    if (this.isScriptText(node)) {
                        this.textForScript(node.getNodeValue());
                    } else {
                        this.writer.textForHtmlItem(node.getNodeValue());
                    }
                } else {
                    this.processNodes((Element)node, cssStyles);
                }
                if (!node.getNodeName().equals("#text")) {
                    this.endNode(node);
                }
            }
            node = node.getNextSibling();
        }
    }

    private boolean isScriptText(Node node) {
        String tag;
        Node parent = node.getParentNode();
        return parent != null && parent.getNodeType() == 1 && "script".equalsIgnoreCase(tag = parent.getNodeName());
    }

    private void textForScript(String text) {
        this.writer.text(text, false, false);
    }

    public void startNode(Node node, HashMap cssStyles) {
        String nodeName = node.getNodeName();
        HashMap cssStyle = (HashMap)cssStyles.get(node);
        this.writer.openTag(nodeName);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                String attrName = attribute.getNodeName();
                String attrValue = attribute.getNodeValue();
                if (attrValue != null) {
                    String attrValueTrue;
                    if ("img".equalsIgnoreCase(nodeName) && "src".equalsIgnoreCase(attrName) && (attrValueTrue = this.handleStyleImage(attrValue)) != null) {
                        attrValue = attrValueTrue;
                    }
                    this.writer.attribute(attrName, attrValue);
                }
                ++i;
            }
        }
        if (cssStyle != null) {
            StringBuffer buffer = new StringBuffer();
            Iterator ite = cssStyle.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry entry = ite.next();
                Object keyObj = entry.getKey();
                Object valueObj = entry.getValue();
                if (keyObj == null || valueObj == null) continue;
                String key = keyObj.toString();
                String value = valueObj.toString();
                buffer.append(key);
                buffer.append(":");
                if ("background-image".equalsIgnoreCase(key)) {
                    String valueTrue = this.handleStyleImage(value);
                    if (valueTrue != null) {
                        value = valueTrue;
                    }
                    buffer.append("url(");
                    buffer.append(value);
                    buffer.append(")");
                } else {
                    buffer.append(value);
                }
                buffer.append(";");
            }
            if (buffer.length() != 0) {
                this.writer.attribute("style", buffer.toString());
            }
        }
    }

    public void endNode(Node node) {
        this.writer.closeTag(node.getNodeName());
    }

    public void startLabel(ILabelContent label) {
        String bookmark = label.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            label.setBookmark(bookmark);
        }
        this.startText((ITextContent)label);
    }

    public void startData(IDataContent data) {
        this.startText((ITextContent)data);
    }

    public void startImage(IImageContent image) {
        boolean useSVG;
        if (!$assertionsDisabled && image == null) {
            throw new AssertionError();
        }
        IStyle mergedStyle = image.getStyle();
        logger.log(Level.FINE, "[HTMLImageEmitter] Start image");
        StringBuffer styleBuffer = new StringBuffer();
        int display = this.checkElementType(image.getX(), image.getY(), mergedStyle, styleBuffer);
        boolean isSelectHandleTableChart = false;
        if (this.enableMetadata) {
            isSelectHandleTableChart = this.metadataEmitter.startImage(image);
        }
        String tag = this.openTagByType(display, 1);
        boolean hasAction = this.handleAction(image.getHyperlinkAction());
        String imgUri = this.getImageURI(image);
        boolean bl = useSVG = "image/svg+xml".equalsIgnoreCase(image.getMIMEType()) || ".svg".equalsIgnoreCase(image.getExtension()) || image.getURI() != null && image.getURI().toLowerCase().endsWith(".svg");
        if (useSVG) {
            this.writer.openTag("embed");
            String bookmark = image.getBookmark();
            if (!isSelectHandleTableChart) {
                if (bookmark == null) {
                    bookmark = this.idGenerator.generateUniqueID();
                    image.setBookmark(bookmark);
                }
                this.outputBookmark((IContent)image, "img");
            }
            this.writer.attribute("onresize", String.valueOf(bookmark) + ".reload()");
            this.writer.attribute("type", "image/svg+xml");
            this.writer.attribute("src", imgUri);
            String altText = image.getAltText();
            if (altText == null) {
                this.writer.attributeAllowEmpty("alt", "");
            } else {
                this.writer.attribute("alt", altText);
            }
            String styleClass = image.getStyleClass();
            this.setStyleName(styleClass);
            this.htmlEmitter.buildImageStyle(image, styleBuffer, display);
            this.writer.attribute("style", styleBuffer.toString());
            this.writer.closeNoEndTag();
        } else {
            String altText;
            boolean hasImageMap;
            Object imageMapObject = image.getImageMap();
            String imageMapId = imgUri;
            boolean bl2 = hasImageMap = imageMapObject != null && imageMapObject instanceof String && ((String)imageMapObject).length() > 0;
            if (hasImageMap) {
                this.writer.openTag("map");
                this.writer.attribute("name", imageMapId);
                this.writer.text((String)imageMapObject, true, false);
                this.writer.closeTag("map");
            }
            this.writer.openTag("img");
            String styleClass = image.getStyleClass();
            this.setStyleName(styleClass);
            String bookmark = image.getBookmark();
            if (!isSelectHandleTableChart) {
                if (bookmark == null) {
                    bookmark = this.idGenerator.generateUniqueID();
                    image.setBookmark(bookmark);
                }
                this.outputBookmark((IContent)image, "img");
            }
            String ext = image.getExtension();
            this.writer.attribute("src", imgUri);
            if (hasImageMap) {
                if (!hasAction) {
                    IStyle style = image.getStyle();
                    if (style.getBorderTopStyle() == null) {
                        styleBuffer.append("border-top-style:none;");
                    } else if (style.getBorderTopColor() == null) {
                        styleBuffer.append("border-top-color:black");
                    }
                    if (style.getBorderBottomStyle() == null) {
                        styleBuffer.append("border-bottom-style:none;");
                    } else if (style.getBorderBottomColor() == null) {
                        styleBuffer.append("border-bottom-color:black");
                    }
                    if (style.getBorderLeftStyle() == null) {
                        styleBuffer.append("border-left-style:none;");
                    } else if (style.getBorderLeftColor() == null) {
                        styleBuffer.append("border-left-color:black");
                    }
                    if (style.getBorderRightStyle() == null) {
                        styleBuffer.append("border-right-style:none;");
                    } else if (style.getBorderRightColor() == null) {
                        styleBuffer.append("border-right-color:black");
                    }
                }
                this.writer.attribute("usemap", "#" + imageMapId);
            }
            if ((altText = image.getAltText()) == null) {
                this.writer.attributeAllowEmpty("alt", "");
            } else {
                this.writer.attribute("alt", altText);
            }
            this.writer.attribute("title", image.getHelpText());
            this.htmlEmitter.buildImageStyle(image, styleBuffer, display);
            this.writer.attribute("style", styleBuffer.toString());
            if (".PNG".equalsIgnoreCase(ext) && this.imageHandler != null) {
                this.writer.attribute("onload", "fixPNG(this)");
            }
            this.writer.closeNoEndTag();
        }
        if (hasAction) {
            this.writer.closeTag("a");
        }
        this.writer.closeTag(tag);
        if (this.enableMetadata) {
            this.metadataEmitter.endImage(image);
        }
    }

    protected String getImageURI(IImageContent image) {
        String imgUri = null;
        if (this.imageHandler != null) {
            Image img = new Image(image);
            img.setRenderOption(this.renderOption);
            img.setReportRunnable(this.runnable);
            switch (img.getSource()) {
                case 0: {
                    imgUri = this.imageHandler.onDesignImage((IImage)img, this.reportContext);
                    break;
                }
                case 2: {
                    imgUri = this.imageHandler.onURLImage((IImage)img, this.reportContext);
                    break;
                }
                case 1: {
                    imgUri = this.imageHandler.onDocImage((IImage)img, this.reportContext);
                    break;
                }
                case 4: {
                    imgUri = this.imageHandler.onCustomImage((IImage)img, this.reportContext);
                    break;
                }
                case 3: {
                    imgUri = this.imageHandler.onFileImage((IImage)img, this.reportContext);
                    break;
                }
            }
        }
        return imgUri;
    }

    protected void setStyleName(String styleName) {
        if (this.isEmbeddable) {
            return;
        }
        if (styleName != null && this.outputtedStyles.contains(styleName)) {
            this.writer.attribute("class", styleName);
        }
    }

    protected void outputBookmark(IContent content, String tagName) {
        String bookmark = content.getBookmark();
        HTMLEmitterUtil.setBookmark(this.writer, tagName, bookmark);
    }

    protected int checkElementType(DimensionType x, DimensionType y, IStyle style, StringBuffer styleBuffer) {
        return this.checkElementType(x, y, null, null, style, styleBuffer);
    }

    protected int checkElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style, StringBuffer styleBuffer) {
        return this.getElementType(x, y, width, height, style);
    }

    public int getElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        return this.htmlEmitter.getElementType(x, y, width, height, style);
    }

    protected String openTagByType(int display, int mask) {
        String tag = HTMLEmitterUtil.getTagByType(display, mask);
        if (tag != null) {
            this.writer.openTag(tag);
        }
        return tag;
    }

    protected boolean handleAction(IHyperlinkAction action) {
        String url = this.validate(action);
        if (url != null) {
            this.outputAction(action, url);
        }
        return url != null;
    }

    protected void outputAction(IHyperlinkAction action, String url) {
        this.writer.openTag("a");
        this.writer.attribute("href", url);
        this.writer.attribute("target", action.getTargetWindow());
    }

    private String validate(IHyperlinkAction action) {
        if (action == null) {
            return null;
        }
        String systemId = this.runnable == null ? null : this.runnable.getReportName();
        Action act = new Action(systemId, action);
        if (this.actionHandler == null) {
            return null;
        }
        String link = this.actionHandler.getURL((IAction)act, this.reportContext);
        if (link != null && !link.equals("")) {
            return link;
        }
        return null;
    }

    public String handleStyleImage(String uri) {
        ReportDesignHandle design = (ReportDesignHandle)this.runnable.getDesignHandle();
        URL url = design.findResource(uri, 1);
        if (url == null) {
            return uri;
        }
        uri = url.toExternalForm();
        Image image = new Image(uri);
        image.setReportRunnable(this.runnable);
        image.setRenderOption(this.renderOption);
        String imgUri = null;
        if (this.imageHandler != null) {
            switch (image.getSource()) {
                case 2: {
                    imgUri = this.imageHandler.onURLImage((IImage)image, this.reportContext);
                    break;
                }
                case 3: {
                    imgUri = this.imageHandler.onFileImage((IImage)image, this.reportContext);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
        return imgUri;
    }

    private void setupTemplateElement(TemplateDesign template, IContent content) {
        String allowedType;
        String bookmark = content.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            content.setBookmark(bookmark);
        }
        if ("ExtendedItem".equals(allowedType = template.getAllowedType())) {
            IStyle style = content.getStyle();
            style.setProperty(6, (CSSValue)IStyle.FALSE_VALUE);
            content.setWidth(new DimensionType(3.0, "in"));
            content.setHeight(new DimensionType(3.0, "in"));
        } else if ("Table".equals(allowedType)) {
            IStyle style = content.getStyle();
            style.setProperty(6, (CSSValue)IStyle.FALSE_VALUE);
            content.setWidth(new DimensionType(5.0, "in"));
            style.setProperty(10, (CSSValue)IStyle.DOTTED_VALUE);
            style.setProperty(13, (CSSValue)IStyle.DOTTED_VALUE);
            style.setProperty(11, (CSSValue)IStyle.DOTTED_VALUE);
            style.setProperty(12, (CSSValue)IStyle.DOTTED_VALUE);
            style.setProperty(49, (CSSValue)IStyle.SANS_SERIF_VALUE);
        }
    }

    public void endGroup(IGroupContent group) {
    }

    public void endListBand(IListBandContent listBand) {
    }

    public void endListGroup(IListGroupContent group) {
    }

    public void endTableBand(ITableBandContent band) {
    }

    public void endTableGroup(ITableGroupContent group) {
    }

    public void startGroup(IGroupContent group) {
    }

    public void startListBand(IListBandContent listBand) {
    }

    public void startListGroup(IListGroupContent group) {
        this.outputBookmark((IGroupContent)group);
    }

    public void startTableBand(ITableBandContent band) {
    }

    public void startTableGroup(ITableGroupContent group) {
        this.startedGroups.push(group);
    }

    private void outputBookmark(IGroupContent group) {
        String bookmark = group.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            group.setBookmark(bookmark);
        }
        this.writer.openTag("span");
        this.writer.attribute("id", group.getBookmark());
        this.writer.closeTag("span");
    }
}

