/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.wpml.SpanInfo;

public class EmitterContext {
    private LinkedList tbls = new LinkedList();
    private boolean empty = false;
    private LinkedList wlist = new LinkedList();
    private Stack cellind = new Stack();
    private boolean inline = false;
    private boolean lastTable = false;

    public void setLast(boolean isTable) {
        this.lastTable = isTable;
    }

    public boolean isLastTable() {
        return this.lastTable;
    }

    public void startInline() {
        this.inline = true;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void endInline() {
        this.inline = false;
    }

    public void startCell() {
        this.cellind.push(Boolean.TRUE);
    }

    public void endCell() {
        this.cellind.pop();
    }

    public boolean needEmptyP() {
        return (Boolean)this.cellind.peek();
    }

    public void addContainer(boolean isContainer) {
        if (!this.cellind.isEmpty()) {
            this.cellind.pop();
            this.cellind.push(new Boolean(isContainer));
        }
    }

    public void addWidth(int w) {
        this.wlist.addLast(new Integer(w));
    }

    public void resetWidth() {
        this.wlist.removeAll(this.wlist);
    }

    public int getCurrentWidth() {
        return (Integer)this.wlist.getLast();
    }

    public void removeWidth() {
        this.wlist.removeLast();
    }

    public int[] getCurrentTblCols() {
        return ((TableInfo)this.tbls.getLast()).getCWidths();
    }

    public void addTable(int[] cols, IStyle style) {
        this.tbls.addLast(new TableInfo(cols, style));
    }

    public IStyle getTableStyle() {
        return ((TableInfo)this.tbls.getLast()).getTableStyle();
    }

    public void newRow() {
        ((TableInfo)this.tbls.getLast()).newRow();
    }

    public void addSpan(int col, int cs, int cw, int height, IStyle style) {
        ((TableInfo)this.tbls.getLast()).addSpan(col, cs, cw, height, style);
    }

    public void removeTable() {
        this.tbls.removeLast();
    }

    public List getSpans(int col) {
        return ((TableInfo)this.tbls.getLast()).getSpans(col);
    }

    public int getCellWidth(int col, int cs) {
        int[] cols = this.getCurrentTblCols();
        int w = 0;
        int i = col;
        while (i < col + cs) {
            w += cols[i];
            ++i;
        }
        return w;
    }

    class TableInfo {
        private Hashtable spans = new Hashtable();
        private int[] cols;
        private int crow = 0;
        IStyle style = null;

        TableInfo(int[] cols, IStyle style) {
            this.cols = cols;
            this.style = style;
        }

        void newRow() {
            ++this.crow;
        }

        void addSpan(int y, int cs, int cw, int height, IStyle style) {
            int i = 1;
            while (i < height) {
                List<SpanInfo> rSpan;
                Integer key = new Integer(this.crow + i);
                if (this.spans.containsKey(key)) {
                    rSpan = (List)this.spans.get(key);
                    rSpan.add(new SpanInfo(y, cs, cw, false, style));
                    Collections.sort(rSpan, new Comparator(this){
                        final /* synthetic */ TableInfo this$1;
                        {
                            this.this$1 = tableInfo;
                        }

                        public int compare(Object obj1, Object obj2) {
                            SpanInfo r1 = (SpanInfo)obj1;
                            SpanInfo r2 = (SpanInfo)obj2;
                            return r1.x - r2.x;
                        }
                    });
                } else {
                    rSpan = new Vector<SpanInfo>();
                    ((Vector)rSpan).add(new SpanInfo(y, cs, cw, false, style));
                    this.spans.put(key, rSpan);
                }
                ++i;
            }
        }

        List getSpans(int end) {
            List cSpans = (List)this.spans.get(new Integer(this.crow));
            if (cSpans == null) {
                return null;
            }
            Vector<SpanInfo> cList = new Vector<SpanInfo>();
            int pos = -1;
            int i = 0;
            while (i < cSpans.size()) {
                SpanInfo r = (SpanInfo)cSpans.get(i);
                if (r.x + r.cs - 1 > end) break;
                cList.add(r);
                pos = i++;
            }
            i = 0;
            while (i <= pos) {
                cSpans.remove(0);
                ++i;
            }
            if (cSpans.size() == 0) {
                this.removeSpan();
            }
            return cList.size() == 0 ? null : cList;
        }

        public void removeSpan() {
            this.spans.remove(new Integer(this.crow));
        }

        int[] getCWidths() {
            return this.cols;
        }

        int getRow() {
            return this.crow;
        }

        IStyle getTableStyle() {
            return this.style;
        }
    }
}

