/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.ir.Report;
import org.mozilla.javascript.Scriptable;

public class DataInteractiveEngine
extends AbstractDataEngine {
    private IDocArchiveReader reader;
    private DataOutputStream dos;
    protected HashMap rsetRelations = new HashMap();
    private StringBuffer keyBuffer = new StringBuffer();

    public DataInteractiveEngine(ExecutionContext context, IDocArchiveReader reader, IDocArchiveWriter writer) throws Exception {
        super(context);
        DataSessionContext dteSessionContext;
        if (writer == null) {
            dteSessionContext = new DataSessionContext(2, null, context.getSharedScope());
            dteSessionContext.setDocumentReader(reader);
        } else {
            dteSessionContext = new DataSessionContext(4, null, context.getSharedScope());
            dteSessionContext.setDocumentReader(reader);
            dteSessionContext.setDocumentWriter(writer);
        }
        DataEngineContext dteEngineContext = dteSessionContext.getDataEngineContext();
        dteEngineContext.setLocale(context.getLocale());
        String tempDir = this.getTempDir(context);
        if (tempDir != null) {
            dteEngineContext.setTmpdir(tempDir);
        }
        this.dteSession = DataRequestSession.newSession((DataSessionContext)dteSessionContext);
        this.reader = reader;
        this.loadDteMetaInfo();
        if (writer != null && this.dos == null) {
            this.dos = new DataOutputStream((OutputStream)writer.createRandomAccessStream("/Data/snap_hierarchy"));
            DteMetaInfoIOUtil.startMetaInfo(this.dos);
        }
    }

    private void storeDteMetaInfo(String pRsetId, String rowId, String queryId, String rsetId) {
        if (this.dos != null) {
            try {
                if (this.context.isExecutingMasterPage() && pRsetId == null) {
                    rowId = String.valueOf(this.context.getPageNumber());
                }
                DteMetaInfoIOUtil.storeMetaInfo(this.dos, pRsetId, rowId, queryId, rsetId);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage());
            }
        }
    }

    private void loadDteMetaInfo() throws IOException {
        ArrayList result = DteMetaInfoIOUtil.loadDteMetaInfo(this.reader);
        if (result != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < result.size()) {
                String[] rsetRelation = (String[])result.get(i);
                String pRsetId = rsetRelation[0];
                String rowId = rsetRelation[1];
                String queryId = rsetRelation[2];
                String rsetId = rsetRelation[3];
                buffer.setLength(0);
                buffer.append(pRsetId);
                buffer.append(".");
                buffer.append(rowId);
                buffer.append(".");
                buffer.append(queryId);
                this.rsetRelations.put(buffer.toString(), rsetId);
                ++i;
            }
        }
    }

    protected String getResultID(String pRsetId, String rowId, String queryId) {
        int charAt;
        this.keyBuffer.setLength(0);
        this.keyBuffer.append(pRsetId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(rowId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(queryId);
        String rsetId = (String)this.rsetRelations.get(this.keyBuffer.toString());
        if (rsetId == null && pRsetId != null && (charAt = pRsetId.indexOf("_")) != -1) {
            String rootId = pRsetId.substring(0, charAt);
            this.keyBuffer.setLength(0);
            this.keyBuffer.append(rootId);
            this.keyBuffer.append(".");
            this.keyBuffer.append(rowId);
            this.keyBuffer.append(".");
            this.keyBuffer.append(queryId);
            rsetId = (String)this.rsetRelations.get(this.keyBuffer.toString());
        }
        return rsetId;
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        this.appContext = appContext;
        this.queryIDMap.putAll(report.getQueryIDs());
    }

    protected IBaseResultSet doExecuteQuery(IBaseResultSet resultSet, IDataQueryDefinition query, boolean useCache) {
        if (query instanceof IQueryDefinition) {
            return this.doExecuteQuery(resultSet, (IQueryDefinition)query, useCache);
        }
        if (query instanceof ICubeQueryDefinition) {
            return this.doExecuteCube(resultSet, (ICubeQueryDefinition)query, useCache);
        }
        return null;
    }

    protected IBaseResultSet doExecuteQuery(IBaseResultSet parentResult, IQueryDefinition query, boolean useCache) {
        String resultSetID;
        IBaseQueryResults parentQueryResults;
        String queryID;
        block12: {
            queryID = (String)this.queryIDMap.get(query);
            try {
                parentQueryResults = null;
                if (parentResult != null) {
                    parentQueryResults = parentResult.getQueryResults();
                }
                if ((resultSetID = this.loadResultSetID(parentResult, parentQueryResults, queryID)) != null) break block12;
                logger.log(Level.SEVERE, "Can't load the report query");
                return null;
            }
            catch (BirtException be) {
                logger.log(Level.SEVERE, be.getMessage());
                this.context.addException(be);
                return null;
            }
        }
        ((QueryDefinition)query).setQueryResultsID(resultSetID);
        IPreparedQuery pQuery = this.dteSession.prepare(query, null);
        Scriptable scope = this.context.getSharedScope();
        String pRsetId = null;
        String rowId = "-1";
        IBaseQueryResults dteResults = null;
        QueryResultSet resultSet = null;
        if (parentQueryResults == null) {
            if (useCache) {
                dteResults = this.getCachedQueryResult((IDataQueryDefinition)query);
            }
            if (dteResults == null) {
                dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, null, scope);
                if (query.cacheQueryResults()) {
                    this.cachedQueryIdMap.put(query, dteResults.getID());
                }
            }
            resultSet = new QueryResultSet(this, this.context, query, (IQueryResults)dteResults);
        } else {
            pRsetId = parentResult.getQueryResults().getID();
            rowId = parentResult.getRawID();
            if (useCache) {
                dteResults = this.getCachedQueryResult((IDataQueryDefinition)query);
            }
            if (dteResults == null) {
                dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, parentQueryResults, scope);
                if (query.cacheQueryResults()) {
                    this.cachedQueryIdMap.put(query, dteResults.getID());
                }
            }
            resultSet = new QueryResultSet(this, this.context, parentResult, query, (IQueryResults)dteResults);
        }
        resultSet.setBaseRSetID(resultSetID);
        this.storeDteMetaInfo(pRsetId, rowId, queryID, dteResults.getID());
        return resultSet;
    }

    protected IBaseResultSet doExecuteCube(IBaseResultSet parentResult, ICubeQueryDefinition query, boolean useCache) {
        IBaseQueryResults dteResults;
        String resultSetID;
        IBaseQueryResults parentQueryResults;
        String queryID;
        block9: {
            queryID = (String)this.queryIDMap.get(query);
            try {
                parentQueryResults = null;
                if (parentResult != null) {
                    parentQueryResults = parentResult.getQueryResults();
                }
                if ((resultSetID = this.loadResultSetID(parentResult, parentQueryResults, queryID)) != null) break block9;
                logger.log(Level.SEVERE, "Can't load the report query");
                return null;
            }
            catch (BirtException be) {
                logger.log(Level.SEVERE, be.getMessage());
                this.context.addException(be);
                return null;
            }
        }
        if (useCache) {
            String rsetId = String.valueOf(this.cachedQueryIdMap.get(query));
            query.setQueryResultsID(rsetId);
        } else {
            query.setQueryResultsID(null);
        }
        query.setQueryResultsID(resultSetID);
        IPreparedCubeQuery pQuery = this.dteSession.prepare(query, this.appContext);
        Scriptable scope = this.context.getSharedScope();
        String pRsetId = null;
        String rowId = "-1";
        CubeResultSet resultSet = null;
        if (parentQueryResults == null) {
            dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, null, scope);
            resultSet = new CubeResultSet(this, this.context, query, (ICubeQueryResults)dteResults);
        } else {
            pRsetId = parentResult.getQueryResults().getID();
            rowId = parentResult.getRawID();
            dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, parentQueryResults, scope);
            resultSet = new CubeResultSet(this, this.context, resultSet, query, (ICubeQueryResults)dteResults);
        }
        this.storeDteMetaInfo(pRsetId, rowId, queryID, dteResults.getID());
        if (query.cacheQueryResults()) {
            this.cachedQueryIdMap.put(query, dteResults.getID());
        }
        return resultSet;
    }

    private String loadResultSetID(IBaseResultSet parentResult, IBaseQueryResults queryResults, String queryID) throws BirtException {
        String resultSetID = null;
        if (queryResults == null) {
            if (this.context.isExecutingMasterPage()) {
                long pageNumber = this.context.getPageNumber();
                resultSetID = this.getResultID(null, String.valueOf(pageNumber), queryID);
                if (resultSetID == null) {
                    resultSetID = this.getResultID(null, "-1", queryID);
                }
            } else {
                resultSetID = this.getResultID(null, "-1", queryID);
            }
        } else {
            String pRsetId = parentResult.getType() == 0 ? ((QueryResultSet)parentResult).getBaseRSetID() : queryResults.getID();
            String rowid = parentResult.getRawID();
            resultSetID = this.getResultID(pRsetId, rowid, queryID);
        }
        return resultSetID;
    }

    public void shutdown() {
        if (this.dos != null) {
            try {
                this.dos.close();
            }
            catch (IOException iOException) {}
            this.dos = null;
        }
        this.dteSession.shutdown();
    }
}

