/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.executor.AutoTextItemExecutor;
import org.eclipse.birt.report.engine.executor.CellExecutor;
import org.eclipse.birt.report.engine.executor.DataItemExecutor;
import org.eclipse.birt.report.engine.executor.DynamicTextItemExecutor;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.ExtendedItemExecutor;
import org.eclipse.birt.report.engine.executor.GridItemExecutor;
import org.eclipse.birt.report.engine.executor.ImageItemExecutor;
import org.eclipse.birt.report.engine.executor.LabelItemExecutor;
import org.eclipse.birt.report.engine.executor.ListBandExecutor;
import org.eclipse.birt.report.engine.executor.ListGroupExecutor;
import org.eclipse.birt.report.engine.executor.ListItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.executor.RowExecutor;
import org.eclipse.birt.report.engine.executor.TableBandExecutor;
import org.eclipse.birt.report.engine.executor.TableGroupExecutor;
import org.eclipse.birt.report.engine.executor.TableItemExecutor;
import org.eclipse.birt.report.engine.executor.TemplateExecutor;
import org.eclipse.birt.report.engine.executor.TextItemExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IExecutorContext;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.script.internal.ReportContextImpl;
import org.eclipse.birt.report.engine.util.FastPool;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class ExecutorManager {
    public static final int GRIDITEM = 0;
    public static final int IMAGEITEM = 1;
    public static final int LABELITEM = 2;
    public static final int LISTITEM = 3;
    public static final int TABLEITEM = 4;
    public static final int DYNAMICTEXTITEM = 5;
    public static final int TEXTITEM = 6;
    public static final int DATAITEM = 7;
    public static final int EXTENDEDITEM = 8;
    public static final int TEMPLATEITEM = 9;
    public static final int AUTOTEXTITEM = 10;
    public static final int LISTBANDITEM = 11;
    public static final int TABLEBANDITEM = 12;
    public static final int ROWITEM = 13;
    public static final int CELLITEM = 14;
    public static final int LISTGROUPITEM = 15;
    public static final int TABLEGROUPITEM = 16;
    public static final int NUMBER = 17;
    protected static Logger log;
    protected ExecutionContext context;
    protected ReportExecutor executor;
    protected IExecutorContext executorContext;
    protected ExecutorFactory executorFactory;
    protected FastPool[] freeList = new FastPool[17];
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.executor.ExecutorManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.executor.ExecutorManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz2.getName());
    }

    public ExecutorManager(ReportExecutor executor) {
        this.executor = executor;
        this.context = executor.getContext();
        this.executorContext = new ExecutorContext(this.context);
        int i = 0;
        while (i < 17) {
            this.freeList[i] = new FastPool();
            ++i;
        }
        this.executorFactory = new ExecutorFactory();
    }

    long generateUniqueID() {
        return this.executor.generateUniqueID();
    }

    public IExecutorContext getExecutorContext() {
        return this.executorContext;
    }

    protected ReportItemExecutor getItemExecutor(int type) {
        if (!($assertionsDisabled || type >= 0 && type < 17)) {
            throw new AssertionError();
        }
        if (!this.freeList[type].isEmpty()) {
            return (ReportItemExecutor)this.freeList[type].remove();
        }
        switch (type) {
            case 0: {
                return new GridItemExecutor(this);
            }
            case 1: {
                return new ImageItemExecutor(this);
            }
            case 2: {
                return new LabelItemExecutor(this);
            }
            case 3: {
                return new ListItemExecutor(this);
            }
            case 4: {
                return new TableItemExecutor(this);
            }
            case 5: {
                return new DynamicTextItemExecutor(this);
            }
            case 6: {
                return new TextItemExecutor(this);
            }
            case 7: {
                return new DataItemExecutor(this);
            }
            case 8: {
                return new ExtendedItemExecutor(this);
            }
            case 9: {
                return new TemplateExecutor(this);
            }
            case 10: {
                return new AutoTextItemExecutor(this);
            }
            case 11: {
                return new ListBandExecutor(this);
            }
            case 12: {
                return new TableBandExecutor(this);
            }
            case 13: {
                return new RowExecutor(this);
            }
            case 14: {
                return new CellExecutor(this);
            }
            case 15: {
                return new ListGroupExecutor(this);
            }
            case 16: {
                return new TableGroupExecutor(this);
            }
        }
        throw new UnsupportedOperationException("unsupported executor!");
    }

    public ReportItemExecutor createExecutor(IReportItemExecutor parent, ReportItemDesign design) {
        ReportItemExecutor executor = this.executorFactory.createExecutor(design);
        if (executor != null) {
            if (parent instanceof ReportItemExecutor) {
                executor.setParent(parent);
            }
            executor.setModelObject(design);
        }
        return executor;
    }

    public ReportItemExecutor createExtendedExecutor(IReportItemExecutor parent, IReportItemExecutor executor) {
        ExtendedItemExecutor wrapper = (ExtendedItemExecutor)this.getItemExecutor(8);
        if (wrapper != null) {
            wrapper.setParent(parent);
            wrapper.executor = executor;
        }
        return wrapper;
    }

    public void releaseExecutor(int type, ReportItemExecutor itemExecutor) {
        if (type >= 0 && type < 17) {
            this.freeList[type].add(itemExecutor);
        }
    }

    private class ExecutorContext
    extends ReportContextImpl
    implements IExecutorContext {
        public ExecutorContext(ExecutionContext context) {
            super(context);
        }

        public IReportItemExecutor createExecutor(IReportItemExecutor parent, Object handle) {
            if (handle instanceof ReportElementHandle) {
                Report report = this.context.getReport();
                ReportElementHandle reportElementHandle = (ReportElementHandle)handle;
                ReportItemDesign design = report.findDesign(reportElementHandle);
                return ExecutorManager.this.createExecutor(parent, design);
            }
            return null;
        }

        public IBaseResultSet executeQuery(IBaseResultSet parent, IDataQueryDefinition query) {
            return this.executeQuery(parent, query, null);
        }

        public IBaseResultSet executeQuery(IBaseResultSet parent, IDataQueryDefinition query, Object handle) {
            IDataEngine dataEngine = this.context.getDataEngine();
            if (query != null) {
                ReportItemHandle referenceHandle;
                boolean useCache = false;
                if (handle instanceof ReportItemHandle && (referenceHandle = ((ReportItemHandle)handle).getDataBindingReference()) != null) {
                    useCache = true;
                }
                IBaseResultSet rset = dataEngine.execute(parent, query, useCache);
                this.context.setResultSet(rset);
                return rset;
            }
            return null;
        }

        public IReportContent getReportContent() {
            return this.context.getReportContent();
        }

        public ClassLoader getApplicationClassLoader() {
            return this.context.getApplicationClassLoader();
        }

        public IDataQueryDefinition[] getQueries(Object handle) {
            if (handle instanceof ReportElementHandle) {
                ReportElementHandle reportElementHandle = (ReportElementHandle)handle;
                Report report = this.context.getReport();
                return report.getQueryByReportHandle(reportElementHandle);
            }
            return null;
        }
    }

    class ExecutorFactory
    extends DefaultReportItemVisitorImpl {
        ExecutorFactory() {
        }

        public ReportItemExecutor createExecutor(ReportItemDesign design) {
            return (ReportItemExecutor)design.accept(this, null);
        }

        public Object visitAutoTextItem(AutoTextItemDesign autoText, Object value) {
            return ExecutorManager.this.getItemExecutor(10);
        }

        public Object visitCell(CellDesign cell, Object value) {
            return ExecutorManager.this.getItemExecutor(14);
        }

        public Object visitDataItem(DataItemDesign data, Object value) {
            return ExecutorManager.this.getItemExecutor(7);
        }

        public Object visitExtendedItem(ExtendedItemDesign item, Object value) {
            ExtendedItemExecutor extExecutor = (ExtendedItemExecutor)ExecutorManager.this.getItemExecutor(8);
            ExtendedItemHandle handle = (ExtendedItemHandle)item.getHandle();
            String tagName = handle.getExtensionName();
            IReportItemExecutor executor = ExtensionManager.getInstance().createReportItemExecutor(ExecutorManager.this, tagName);
            executor.setContext(ExecutorManager.this.executorContext);
            executor.setModelObject(handle);
            extExecutor.executor = executor;
            return extExecutor;
        }

        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            return null;
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            return ExecutorManager.this.getItemExecutor(0);
        }

        public Object visitImageItem(ImageItemDesign image, Object value) {
            return ExecutorManager.this.getItemExecutor(1);
        }

        public Object visitLabelItem(LabelItemDesign label, Object value) {
            return ExecutorManager.this.getItemExecutor(2);
        }

        public Object visitListBand(ListBandDesign band, Object value) {
            return ExecutorManager.this.getItemExecutor(11);
        }

        public Object visitListItem(ListItemDesign list, Object value) {
            return ExecutorManager.this.getItemExecutor(3);
        }

        public Object visitDynamicTextItem(DynamicTextItemDesign dynamicText, Object value) {
            return ExecutorManager.this.getItemExecutor(5);
        }

        public Object visitRow(RowDesign row, Object value) {
            return ExecutorManager.this.getItemExecutor(13);
        }

        public Object visitTableBand(TableBandDesign band, Object value) {
            return ExecutorManager.this.getItemExecutor(12);
        }

        public Object visitTableItem(TableItemDesign table, Object value) {
            return ExecutorManager.this.getItemExecutor(4);
        }

        public Object visitTemplate(TemplateDesign template, Object value) {
            return ExecutorManager.this.getItemExecutor(9);
        }

        public Object visitTextItem(TextItemDesign text, Object value) {
            return ExecutorManager.this.getItemExecutor(6);
        }

        public Object visitListGroup(ListGroupDesign group, Object value) {
            return ExecutorManager.this.getItemExecutor(15);
        }

        public Object visitTableGroup(TableGroupDesign group, Object value) {
            return ExecutorManager.this.getItemExecutor(16);
        }
    }
}

