/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.buffermgr;

import java.util.ArrayList;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.executor.buffermgr.Row;
import org.eclipse.birt.report.engine.layout.LayoutUtil;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.HTMLTableLayoutEmitter;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class TableContentLayout {
    Row[] rows;
    int rowCount;
    int colCount;
    int realColCount;
    int rowBufferSize;
    int colBufferSize;
    boolean isRowHidden;
    String format;
    ArrayList hiddenList = new ArrayList();
    protected UnresolvedRowHint rowHint;
    protected Row lastRow = null;
    protected boolean formalized = false;
    protected HTMLLayoutContext context;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.executor.buffermgr.TableContentLayout");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public TableContentLayout(ITableContent tableContent, String format, HTMLLayoutContext context) {
        this.format = format;
        this.context = context;
        this.colCount = tableContent.getColumnCount();
        int i = 0;
        while (i < this.colCount) {
            IColumn column = tableContent.getColumn(i);
            if (this.isColumnHidden(column)) {
                this.hiddenList.add(new Integer(i));
            }
            ++i;
        }
        this.realColCount = this.colCount - this.hiddenList.size();
    }

    public void setUnresolvedRowHint(UnresolvedRowHint rowHint) {
        this.rowHint = rowHint;
    }

    public void endRow(IRowContent rowContent) {
        if (this.isRowHidden) {
            return;
        }
        if (this.rowHint != null && !this.formalized && !LayoutUtil.isRepeatableRow(rowContent)) {
            Row row = this.rows[this.rowCount - 1];
            Cell[] cells = row.cells;
            int cellId = 0;
            while (cellId < this.realColCount) {
                Cell cell = cells[cellId];
                if (cell != null && (cell.status == 0 || cell.status == 1 && this.rowHint.isDropColumn(cellId))) {
                    Cell newCell;
                    IReportContent report = rowContent.getReportContent();
                    ICellContent cellContent = report.createCellContent();
                    this.rowHint.initUnresolvedCell(cellContent, rowContent.getInstanceID(), cellId);
                    cellContent.setParent(rowContent);
                    int rowSpan = cellContent.getRowSpan();
                    int colSpan = cellContent.getColSpan();
                    row.cells[cellId] = newCell = Cell.createCell(row.rowId, cellId, rowSpan, colSpan, new HTMLTableLayoutEmitter.CellContent(cellContent, null));
                    int i = cellId + 1;
                    while (i < cellId + colSpan) {
                        row.cells[i] = Cell.createSpanCell(row.rowId, i, newCell);
                        ++i;
                    }
                }
                ++cellId;
            }
            this.formalized = true;
            this.rowHint = null;
        }
    }

    public void reset() {
        this.fillEmptyCells(0, 0, this.rowBufferSize, this.colBufferSize);
        this.rowCount = 0;
        this.isRowHidden = false;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColCount() {
        return this.realColCount;
    }

    public Row createRow(Object rowContent, boolean isHidden) {
        if (!isHidden) {
            this.isRowHidden = false;
            this.ensureSize(this.rowCount + 1, this.realColCount);
            Row row = this.rows[this.rowCount];
            row.rowId = this.rowCount;
            row.content = rowContent;
            if (this.rowCount > 0) {
                Cell[] cells = row.cells;
                Cell[] lastCells = this.rows[this.rowCount - 1].cells;
                int cellId = 0;
                while (cellId < this.realColCount) {
                    Cell lastCell = lastCells[cellId];
                    if (lastCell.status == 2) {
                        lastCell = lastCell.getCell();
                    }
                    if (lastCell.status == 1 && (lastCell.rowSpan < 0 || lastCell.rowId + lastCell.rowSpan > this.rowCount)) {
                        cells[cellId] = Cell.createSpanCell(this.rowCount, cellId, lastCell);
                    }
                    ++cellId;
                }
            }
            ++this.rowCount;
            return row;
        }
        this.isRowHidden = true;
        if (this.rowCount > 0) {
            Cell[] lastCells = this.rows[this.rowCount - 1].cells;
            int cellId = 0;
            while (cellId < this.realColCount) {
                Cell lastCell = lastCells[cellId];
                if (lastCell.status == 2) {
                    lastCell = lastCell.getCell();
                }
                if (lastCell.status == 1 && lastCell.rowId + lastCell.rowSpan >= this.rowCount + 1) {
                    --lastCell.rowSpan;
                }
                ++cellId;
            }
        }
        return null;
    }

    public void createCell(int cellId, int rowSpan, int colSpan, Cell.Content content) {
        if (this.isRowHidden) {
            return;
        }
        int columnNumber = cellId;
        int columnSpan = colSpan;
        if (this.hiddenList.size() > 0) {
            int i = 0;
            while (i < this.hiddenList.size()) {
                int hCol = (Integer)this.hiddenList.get(i);
                if (hCol < cellId) {
                    --columnNumber;
                } else if (hCol >= cellId && hCol < colSpan + cellId) {
                    --columnSpan;
                }
                ++i;
            }
        }
        if (columnSpan < 1) {
            return;
        }
        if (!$assertionsDisabled && columnNumber < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && columnNumber + columnSpan > this.realColCount) {
            throw new AssertionError();
        }
        this.ensureSize(this.rowCount, columnNumber + columnSpan);
        Cell cell = this.rows[this.rowCount - 1].cells[columnNumber];
        int status = cell.getStatus();
        if (status == 0) {
            Cell newCell = Cell.createCell(this.rows[this.rowCount - 1].rowId, columnNumber, rowSpan, columnSpan, content);
            Cell[] cells = this.rows[this.rowCount - 1].cells;
            this.rows[this.rowCount - 1].cells[columnNumber] = newCell;
            int i = columnNumber + 1;
            while (i < columnNumber + columnSpan) {
                cells[i] = Cell.createSpanCell(this.rows[this.rowCount - 1].rowId, i, newCell);
                ++i;
            }
        }
    }

    public void resolveDropCells(boolean finished) {
        if (!finished) {
            this.keepUnresolvedCells();
        }
        if (this.rowCount <= 0) {
            return;
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        int cellId = 0;
        while (cellId < this.realColCount) {
            if (cells[cellId] != null) {
                if (cells[cellId].getRowSpan() != 1) {
                    Cell cell = cells[cellId].getCell();
                    cell.rowSpan = this.rows[this.rowCount - 1].rowId - cell.rowId + 1;
                }
                cellId = cellId + cells[cellId].getColSpan() - 1;
            }
            ++cellId;
        }
    }

    public void resolveDropCells(int bandId, boolean finished) {
        if (this.rowCount <= 0) {
            return;
        }
        if (!finished) {
            this.keepUnresolvedCells();
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        int cellId = 0;
        while (cellId < this.realColCount) {
            if (cells[cellId] != null) {
                Cell cell = cells[cellId].getCell();
                if (cell.getRowSpan() == bandId) {
                    cell.rowSpan = this.rows[this.rowCount - 1].rowId - cell.rowId + 1;
                }
                cellId = cellId + cells[cellId].getColSpan() - 1;
            }
            ++cellId;
        }
    }

    public boolean hasUnResolvedRow() {
        return this.rowHint != null;
    }

    public boolean hasDropCell() {
        if (this.rowCount <= 0) {
            return false;
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        int cellId = 0;
        while (cellId < this.realColCount) {
            int rowSpan;
            Cell cell = cells[cellId];
            if (cell != null && ((rowSpan = cell.getRowSpan()) < 0 || rowSpan > 1)) {
                return true;
            }
            ++cellId;
        }
        return false;
    }

    protected void ensureSize(int newRowBufferSize, int newColBufferSize) {
        if (newRowBufferSize > this.rowBufferSize) {
            Row[] newRows = new Row[newRowBufferSize];
            if (this.rows != null) {
                System.arraycopy(this.rows, 0, newRows, 0, this.rowCount);
            }
            int rowId = this.rowBufferSize;
            while (rowId < newRowBufferSize) {
                Row row = new Row(rowId);
                Cell[] cells = new Cell[this.colBufferSize];
                int colId = 0;
                while (colId < this.colBufferSize) {
                    cells[colId] = Cell.EMPTY_CELL;
                    ++colId;
                }
                row.cells = cells;
                newRows[rowId] = row;
                ++rowId;
            }
            this.rows = newRows;
            this.rowBufferSize = newRowBufferSize;
        }
        if (newColBufferSize > this.colBufferSize) {
            int rowId = 0;
            while (rowId < this.rowBufferSize) {
                Row row = this.rows[rowId];
                Cell[] newCells = new Cell[newColBufferSize];
                if (row.cells != null) {
                    System.arraycopy(row.cells, 0, newCells, 0, this.colBufferSize);
                }
                int colId = this.colBufferSize;
                while (colId < newColBufferSize) {
                    newCells[colId] = Cell.EMPTY_CELL;
                    ++colId;
                }
                row.cells = newCells;
                ++rowId;
            }
            this.colBufferSize = newColBufferSize;
        }
    }

    protected void fillEmptyCells(int rowId, int colId, int rowSize, int colSize) {
        int i;
        int lastRowId = rowId + rowSize;
        int lastColId = colId + colSize;
        if (lastRowId > this.rowCount) {
            lastRowId = this.rowCount;
        }
        if (lastColId > this.colCount) {
            lastColId = this.colCount;
        }
        if (lastRowId > 0 && this.rows[lastRowId - 1] != null) {
            this.lastRow = new Row(this.rows[lastRowId - 1].rowId);
            this.lastRow.content = this.rows[lastRowId - 1].content;
            this.lastRow.cells = new Cell[lastColId - colId];
            i = colId;
            while (i < lastColId) {
                this.lastRow.cells[i] = this.rows[lastRowId - 1].cells[i];
                ++i;
            }
        }
        i = rowId;
        while (i < lastRowId) {
            Cell[] cells = this.rows[i].cells;
            int j = colId;
            while (j < lastColId) {
                cells[j] = Cell.EMPTY_CELL;
                ++j;
            }
            ++i;
        }
    }

    protected void resizeCell(Cell cell, int newRowSpan, int newColSpan) {
        if (!$assertionsDisabled && cell.status != 1) {
            throw new AssertionError();
        }
        int rowId = cell.rowId;
        int colId = cell.colId;
        int rowSpan = cell.rowSpan;
        if (rowSpan <= 0) {
            rowSpan = this.rowCount - rowId;
        }
        int colSpan = cell.colSpan;
        if (!($assertionsDisabled || rowSpan >= newRowSpan && colSpan >= newColSpan)) {
            throw new AssertionError();
        }
        this.fillEmptyCells(rowId, colId + newColSpan, rowSpan, colSpan - newColSpan);
        this.fillEmptyCells(rowId + newRowSpan, colId, rowSpan - newRowSpan, newColSpan);
        cell.colSpan = newColSpan;
        cell.rowSpan = newRowSpan;
    }

    public Cell getCell(int rowIndex, int colIndex) {
        return this.rows[rowIndex].cells[colIndex];
    }

    public Row getRow(int index) {
        if (!($assertionsDisabled || index >= 0 && index < this.rowCount)) {
            throw new AssertionError();
        }
        return this.rows[index];
    }

    private boolean isColumnHidden(IColumn column) {
        String formats = column.getVisibleFormat();
        return formats != null && (formats.indexOf(this.format) >= 0 || formats.indexOf("all") >= 0);
    }

    public UnresolvedRowHint getUnresolvedRow() {
        return this.rowHint;
    }

    protected void keepUnresolvedCells() {
        if (this.rowHint == null) {
            Row row = null;
            if (this.rowCount > 0) {
                row = this.rows[this.rowCount - 1];
            } else if (this.lastRow != null) {
                row = this.lastRow;
            } else {
                return;
            }
            Cell[] cells = row.cells;
            IRowContent rowContent = (IRowContent)row.getContent();
            ITableContent table = rowContent.getTable();
            InstanceID tableId = table.getInstanceID();
            InstanceID rowId = rowContent.getInstanceID();
            UnresolvedRowHint hint = new UnresolvedRowHint(tableId.toUniqueString(), rowId.toUniqueString());
            int cellId = 0;
            while (cellId < this.realColCount) {
                if (cells[cellId] != null) {
                    ICellContent cc;
                    String style = null;
                    HTMLTableLayoutEmitter.CellContent cellContent = (HTMLTableLayoutEmitter.CellContent)cells[cellId].getContent();
                    if (cellContent != null && (cc = cellContent.getContent()) != null) {
                        style = cc.getStyle().getCssText();
                    }
                    hint.addUnresolvedCell(style, cells[cellId].getColId(), cells[cellId].getColSpan(), cells[cellId].getRowSpan());
                }
                ++cellId;
            }
            this.rowHint = hint;
        }
    }

    public int getCurrentRowID() {
        return this.rowCount - 1;
    }

    public boolean isVisible(ICellContent cell) {
        IElement parent = cell.getParent();
        if (parent instanceof IContent && LayoutUtil.isHidden((IContent)parent, this.format, this.context.getOutputDisplayNone())) {
            return false;
        }
        IColumn column = cell.getColumnInstance();
        if (column == null) {
            return false;
        }
        return !this.isColumnHidden(column);
    }

    protected class UnresolvedRow {
        Row row;
        boolean[] invalidFlags;

        public UnresolvedRow(Row row) {
            this.row = row;
            this.invalidFlags = new boolean[row.cells.length];
        }

        protected int getRowSpan(Row row, int originalRowSpan) {
            if (originalRowSpan > 0 && row.getContent() != this.row.getContent()) {
                return originalRowSpan - 1;
            }
            return originalRowSpan;
        }

        public Cell createCell(int colId, Row row) {
            Cell[] cells = this.row.cells;
            if (colId >= 0 && colId < cells.length && !this.invalidFlags[colId]) {
                this.invalidFlags[colId] = true;
                return Cell.createCell(row.rowId, colId, this.getRowSpan(row, cells[colId].getRowSpan()), cells[colId].getColSpan(), cells[colId].getContent());
            }
            return Cell.createCell(row.rowId, colId, 1, 1, cells[colId].getContent());
        }
    }
}

