/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;

public class DataItemExecutor
extends ReportItemExecutor {
    public DataItemExecutor(ExecutorManager manager) {
        super(manager, 7);
    }

    protected IContent doCreateContent() {
        return this.report.createDataContent();
    }

    protected void doExecute() throws Exception {
        String bindingColumn;
        DataItemDesign dataDesign = (DataItemDesign)this.design;
        IDataContent dataContent = (IDataContent)this.content;
        this.executeQuery();
        MapDesign map = this.design.getMap();
        if ((map == null || map.getRuleCount() == 0) && (bindingColumn = dataDesign.getBindingColumn()) != null) {
            IBaseResultSet rset = this.getResultSet();
            if (rset == null) {
                rset = this.restoreParentResultSet();
            }
            if (rset != null) {
                try {
                    Object value = null;
                    if (rset.getType() == 0) {
                        value = ((IQueryResultSet)rset).getValue(bindingColumn);
                    } else if (rset.getType() == 1) {
                        value = ((ICubeResultSet)rset).getCubeCursor().getObject(bindingColumn);
                    }
                    dataContent.setValue(value);
                }
                catch (Exception ex) {
                    this.context.addException(new EngineException("Retrieving binding data error", ex));
                }
            }
        }
    }

    public void close() {
        this.closeQuery();
        super.close();
    }
}

