/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class BundleVersionUtil {
    protected static Logger logger;
    private static String MANIFEST_PATH;
    private static String UNKNOWN_VERSION;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.internal.util.BundleVersionUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        MANIFEST_PATH = "/META-INF/MANIFEST.MF";
        UNKNOWN_VERSION = "version unknown";
    }

    public static String getBundleVersion(String bundleName) {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            return UNKNOWN_VERSION;
        }
        Path path = new Path(MANIFEST_PATH);
        URL bundleURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (bundleURL == null) {
            return UNKNOWN_VERSION;
        }
        String mainVersion = null;
        try {
            String version;
            Manifest mf = new Manifest(new BufferedInputStream(bundleURL.openStream()));
            if (mf == null) {
                mainVersion = UNKNOWN_VERSION;
            }
            if ((version = mf.getMainAttributes().getValue("Bundle-Version")) != null) {
                mainVersion = version.substring(0, version.lastIndexOf("."));
            }
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
            return UNKNOWN_VERSION;
        }
        return mainVersion;
    }
}

