/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class HTMLLayoutContext {
    protected String masterPage = null;
    protected boolean allowPageBreak = true;
    protected boolean finished;
    protected long pageNumber = 1L;
    protected HTMLReportLayoutEngine engine;
    protected HashMap layoutHint = new HashMap();
    protected ArrayList pageHints = new ArrayList();
    protected IPageBuffer bufferMgr;
    protected boolean needLayoutPageContent = true;
    protected boolean outputDisplayNone = false;
    boolean cancelFlag = false;
    protected ArrayList hints = new ArrayList();
    protected ArrayList currentHints = new ArrayList();

    public void setLayoutPageContent(boolean needLayoutPageContent) {
        this.needLayoutPageContent = needLayoutPageContent;
    }

    public boolean needLayoutPageContent() {
        return this.needLayoutPageContent;
    }

    public HTMLReportLayoutEngine getLayoutEngine() {
        return this.engine;
    }

    public void setPageBufferManager(IPageBuffer bufferMgr) {
        this.bufferMgr = bufferMgr;
    }

    public IPageBuffer getPageBufferManager() {
        return this.bufferMgr;
    }

    public void setPageHint(List hints) {
        this.pageHints.addAll(hints);
    }

    public ArrayList getPageHint() {
        ArrayList hints = new ArrayList();
        hints.addAll(this.pageHints);
        return hints;
    }

    public void reset() {
        this.layoutHint = new HashMap();
        this.finished = false;
        this.allowPageBreak = true;
        this.masterPage = null;
    }

    public void addLayoutHint(IContent content, boolean finished) {
        this.layoutHint.put(content, new Boolean(finished));
    }

    public boolean getLayoutHint(IContent content) {
        Object finished = this.layoutHint.get(content);
        if (finished != null && finished instanceof Boolean) {
            return (Boolean)finished;
        }
        return true;
    }

    public void removeLayoutHint() {
        this.layoutHint.clear();
    }

    public String getMasterPage() {
        return this.masterPage;
    }

    public void setMasterPage(String masterPage) {
        this.masterPage = masterPage;
    }

    public HTMLLayoutContext(HTMLReportLayoutEngine engine) {
        this.engine = engine;
    }

    public boolean allowPageBreak() {
        return this.allowPageBreak;
    }

    public void setAllowPageBreak(boolean allowPageBreak) {
        this.allowPageBreak = allowPageBreak;
    }

    public void setFinish(boolean finished) {
        this.finished = finished;
    }

    public boolean isFinished() {
        return this.finished;
    }

    void setCancelFlag(boolean flag) {
        this.cancelFlag = flag;
    }

    public boolean getCancelFlag() {
        return this.cancelFlag;
    }

    public List getUnresolvedRowHints() {
        return this.hints;
    }

    public UnresolvedRowHint getUnresolvedRowHint(ITableContent table) {
        if (this.hints.size() > 0) {
            String idStr = table.getInstanceID().toUniqueString();
            Iterator iter = this.hints.iterator();
            while (iter.hasNext()) {
                UnresolvedRowHint rowHint = (UnresolvedRowHint)iter.next();
                if (!idStr.equals(rowHint.getTableId())) continue;
                return rowHint;
            }
        }
        return null;
    }

    public void addUnresolvedRowHint(UnresolvedRowHint hint) {
        this.currentHints.add(hint);
    }

    public void clearPageHint() {
        this.pageHints.clear();
        this.hints.clear();
        this.hints.addAll(this.currentHints);
        this.currentHints.clear();
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setLayoutPageHint(IPageHint pageHint) {
        if (pageHint != null) {
            this.pageNumber = pageHint.getPageNumber();
            int count = pageHint.getUnresolvedRowCount();
            int i = 0;
            while (i < count) {
                this.hints.add(pageHint.getUnresolvedRowHint(i));
                ++i;
            }
        }
    }

    public void setOutputDisplayNone(boolean outputDisplayNone) {
        this.outputDisplayNone = outputDisplayNone;
    }

    public boolean getOutputDisplayNone() {
        return this.outputDisplayNone;
    }
}

