/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLGroupLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLeafItemLM;
import org.eclipse.birt.report.engine.layout.html.HTMLListLM;
import org.eclipse.birt.report.engine.layout.html.HTMLListingBandLM;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.html.HTMLRowLM;
import org.eclipse.birt.report.engine.layout.html.HTMLTableBandLM;
import org.eclipse.birt.report.engine.layout.html.HTMLTableLM;
import org.eclipse.birt.report.engine.util.FastPool;

public class HTMLLayoutManagerFactory {
    private HTMLReportLayoutEngine engine;
    FastPool freeLeaf = new FastPool();
    FastPool freeBlock = new FastPool();
    FastPool freeTable = new FastPool();
    FastPool freeTableBand = new FastPool();
    FastPool freeRow = new FastPool();
    FastPool freeList = new FastPool();
    FastPool freeGroup = new FastPool();
    FastPool freeListBand = new FastPool();
    private IContentVisitor visitor = new ContentVisitorAdapter(){

        public Object visit(IContent content, Object value) {
            return content.accept(this, value);
        }

        public Object visitContent(IContent content, Object value) {
            if (!HTMLLayoutManagerFactory.this.freeLeaf.isEmpty()) {
                return (HTMLLeafItemLM)HTMLLayoutManagerFactory.this.freeLeaf.remove();
            }
            return new HTMLLeafItemLM(HTMLLayoutManagerFactory.this);
        }

        public Object visitPage(IPageContent page, Object value) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        public Object visitContainer(IContainerContent container, Object value) {
            if (!HTMLLayoutManagerFactory.this.freeBlock.isEmpty()) {
                return (HTMLBlockStackingLM)HTMLLayoutManagerFactory.this.freeBlock.remove();
            }
            return new HTMLBlockStackingLM(HTMLLayoutManagerFactory.this);
        }

        public Object visitTable(ITableContent table, Object value) {
            if (!HTMLLayoutManagerFactory.this.freeTable.isEmpty()) {
                return (HTMLTableLM)HTMLLayoutManagerFactory.this.freeTable.remove();
            }
            return new HTMLTableLM(HTMLLayoutManagerFactory.this);
        }

        public Object visitTableGroup(ITableGroupContent group, Object value) {
            if (!HTMLLayoutManagerFactory.this.freeGroup.isEmpty()) {
                return (HTMLGroupLM)HTMLLayoutManagerFactory.this.freeGroup.remove();
            }
            return new HTMLGroupLM(HTMLLayoutManagerFactory.this);
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) {
            if (!HTMLLayoutManagerFactory.this.freeTableBand.isEmpty()) {
                return (HTMLTableBandLM)HTMLLayoutManagerFactory.this.freeTableBand.remove();
            }
            return new HTMLTableBandLM(HTMLLayoutManagerFactory.this);
        }

        public Object visitRow(IRowContent row, Object value) {
            if (!HTMLLayoutManagerFactory.this.freeRow.isEmpty()) {
                return (HTMLRowLM)HTMLLayoutManagerFactory.this.freeRow.remove();
            }
            return new HTMLRowLM(HTMLLayoutManagerFactory.this);
        }

        public Object visitList(IListContent list, Object value) {
            if (!HTMLLayoutManagerFactory.this.freeList.isEmpty()) {
                return (HTMLListLM)HTMLLayoutManagerFactory.this.freeList.remove();
            }
            return new HTMLListLM(HTMLLayoutManagerFactory.this);
        }

        public Object visitListGroup(IListGroupContent group, Object value) {
            if (!HTMLLayoutManagerFactory.this.freeGroup.isEmpty()) {
                return (HTMLGroupLM)HTMLLayoutManagerFactory.this.freeGroup.remove();
            }
            return new HTMLGroupLM(HTMLLayoutManagerFactory.this);
        }

        public Object visitListBand(IListBandContent listBand, Object value) {
            if (!HTMLLayoutManagerFactory.this.freeListBand.isEmpty()) {
                return (HTMLListingBandLM)HTMLLayoutManagerFactory.this.freeListBand.remove();
            }
            return new HTMLListingBandLM(HTMLLayoutManagerFactory.this);
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public HTMLLayoutManagerFactory(HTMLReportLayoutEngine engine) {
        this.engine = engine;
    }

    public HTMLReportLayoutEngine getLayoutEngine() {
        return this.engine;
    }

    public HTMLAbstractLM createLayoutManager(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) {
        HTMLAbstractLM layout = this.getLayoutManager(content);
        layout.initialize(parent, content, executor, emitter);
        return layout;
    }

    public void releaseLayoutManager(HTMLAbstractLM manager) {
        switch (manager.getType()) {
            case 0: {
                this.freeLeaf.add(manager);
                break;
            }
            case 1: {
                this.freeBlock.add(manager);
                break;
            }
            case 3: {
                this.freeTable.add(manager);
                break;
            }
            case 4: {
                this.freeTableBand.add(manager);
                break;
            }
            case 5: {
                this.freeRow.add(manager);
                break;
            }
            case 6: {
                this.freeList.add(manager);
                break;
            }
            case 8: {
                this.freeGroup.add(manager);
                break;
            }
            case 7: {
                this.freeListBand.add(manager);
            }
        }
    }

    private HTMLAbstractLM getLayoutManager(IContent content) {
        HTMLAbstractLM layoutManager = (HTMLAbstractLM)this.visitor.visit(content, null);
        return layoutManager;
    }
}

