/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import java.util.HashMap;
import java.util.Map;

public class CompositeFont {
    private static final int UNICODE_BLOCK_NUMBER = 154;
    private String name;
    private String defaultFont;
    private Map blockFontMapping;
    private static final int[] blockEdges;

    static {
        int[] nArray = new int[308];
        nArray[1] = 127;
        nArray[2] = 128;
        nArray[3] = 255;
        nArray[4] = 256;
        nArray[5] = 383;
        nArray[6] = 384;
        nArray[7] = 591;
        nArray[8] = 592;
        nArray[9] = 687;
        nArray[10] = 688;
        nArray[11] = 767;
        nArray[12] = 768;
        nArray[13] = 879;
        nArray[14] = 880;
        nArray[15] = 1023;
        nArray[16] = 1024;
        nArray[17] = 1279;
        nArray[18] = 1280;
        nArray[19] = 1327;
        nArray[20] = 1328;
        nArray[21] = 1423;
        nArray[22] = 1424;
        nArray[23] = 1535;
        nArray[24] = 1536;
        nArray[25] = 1791;
        nArray[26] = 1792;
        nArray[27] = 1871;
        nArray[28] = 1872;
        nArray[29] = 1919;
        nArray[30] = 1920;
        nArray[31] = 1983;
        nArray[32] = 1984;
        nArray[33] = 2047;
        nArray[34] = 2304;
        nArray[35] = 2431;
        nArray[36] = 2432;
        nArray[37] = 2559;
        nArray[38] = 2560;
        nArray[39] = 2687;
        nArray[40] = 2688;
        nArray[41] = 2815;
        nArray[42] = 2816;
        nArray[43] = 2943;
        nArray[44] = 2944;
        nArray[45] = 3071;
        nArray[46] = 3072;
        nArray[47] = 3199;
        nArray[48] = 3200;
        nArray[49] = 3327;
        nArray[50] = 3328;
        nArray[51] = 3455;
        nArray[52] = 3456;
        nArray[53] = 3583;
        nArray[54] = 3584;
        nArray[55] = 3711;
        nArray[56] = 3712;
        nArray[57] = 3839;
        nArray[58] = 3840;
        nArray[59] = 4095;
        nArray[60] = 4096;
        nArray[61] = 4255;
        nArray[62] = 4256;
        nArray[63] = 4351;
        nArray[64] = 4352;
        nArray[65] = 4607;
        nArray[66] = 4608;
        nArray[67] = 4991;
        nArray[68] = 4992;
        nArray[69] = 5023;
        nArray[70] = 5024;
        nArray[71] = 5119;
        nArray[72] = 5120;
        nArray[73] = 5759;
        nArray[74] = 5760;
        nArray[75] = 5791;
        nArray[76] = 5792;
        nArray[77] = 5887;
        nArray[78] = 5888;
        nArray[79] = 5919;
        nArray[80] = 5920;
        nArray[81] = 5951;
        nArray[82] = 5952;
        nArray[83] = 5983;
        nArray[84] = 5984;
        nArray[85] = 6015;
        nArray[86] = 6016;
        nArray[87] = 6143;
        nArray[88] = 6144;
        nArray[89] = 6319;
        nArray[90] = 6400;
        nArray[91] = 6479;
        nArray[92] = 6480;
        nArray[93] = 6527;
        nArray[94] = 6528;
        nArray[95] = 6623;
        nArray[96] = 6624;
        nArray[97] = 6655;
        nArray[98] = 6656;
        nArray[99] = 6687;
        nArray[100] = 6912;
        nArray[101] = 7039;
        nArray[102] = 7424;
        nArray[103] = 7551;
        nArray[104] = 7552;
        nArray[105] = 7615;
        nArray[106] = 7616;
        nArray[107] = 7679;
        nArray[108] = 7680;
        nArray[109] = 7935;
        nArray[110] = 7936;
        nArray[111] = 8191;
        nArray[112] = 8192;
        nArray[113] = 8303;
        nArray[114] = 8304;
        nArray[115] = 8351;
        nArray[116] = 8352;
        nArray[117] = 8399;
        nArray[118] = 8400;
        nArray[119] = 8447;
        nArray[120] = 8448;
        nArray[121] = 8527;
        nArray[122] = 8528;
        nArray[123] = 8591;
        nArray[124] = 8592;
        nArray[125] = 8703;
        nArray[126] = 8704;
        nArray[127] = 8959;
        nArray[128] = 8960;
        nArray[129] = 9215;
        nArray[130] = 9216;
        nArray[131] = 9279;
        nArray[132] = 9280;
        nArray[133] = 9311;
        nArray[134] = 9312;
        nArray[135] = 9471;
        nArray[136] = 9472;
        nArray[137] = 9599;
        nArray[138] = 9600;
        nArray[139] = 9631;
        nArray[140] = 9632;
        nArray[141] = 9727;
        nArray[142] = 9728;
        nArray[143] = 9983;
        nArray[144] = 9984;
        nArray[145] = 10175;
        nArray[146] = 10176;
        nArray[147] = 10223;
        nArray[148] = 10224;
        nArray[149] = 10239;
        nArray[150] = 10240;
        nArray[151] = 10495;
        nArray[152] = 10496;
        nArray[153] = 10623;
        nArray[154] = 10624;
        nArray[155] = 10751;
        nArray[156] = 10752;
        nArray[157] = 11007;
        nArray[158] = 11008;
        nArray[159] = 11263;
        nArray[160] = 11264;
        nArray[161] = 11359;
        nArray[162] = 11360;
        nArray[163] = 11391;
        nArray[164] = 11392;
        nArray[165] = 11519;
        nArray[166] = 11520;
        nArray[167] = 11567;
        nArray[168] = 11568;
        nArray[169] = 11647;
        nArray[170] = 11648;
        nArray[171] = 11743;
        nArray[172] = 11776;
        nArray[173] = 11903;
        nArray[174] = 11904;
        nArray[175] = 12031;
        nArray[176] = 12032;
        nArray[177] = 12255;
        nArray[178] = 12272;
        nArray[179] = 12287;
        nArray[180] = 12288;
        nArray[181] = 12351;
        nArray[182] = 12352;
        nArray[183] = 12447;
        nArray[184] = 12448;
        nArray[185] = 12543;
        nArray[186] = 12544;
        nArray[187] = 12591;
        nArray[188] = 12592;
        nArray[189] = 12687;
        nArray[190] = 12688;
        nArray[191] = 12703;
        nArray[192] = 12704;
        nArray[193] = 12735;
        nArray[194] = 12736;
        nArray[195] = 12783;
        nArray[196] = 12784;
        nArray[197] = 12799;
        nArray[198] = 12800;
        nArray[199] = 13055;
        nArray[200] = 13056;
        nArray[201] = 13311;
        nArray[202] = 13312;
        nArray[203] = 19903;
        nArray[204] = 19904;
        nArray[205] = 19967;
        nArray[206] = 19968;
        nArray[207] = 40959;
        nArray[208] = 40960;
        nArray[209] = 42127;
        nArray[210] = 42128;
        nArray[211] = 42191;
        nArray[212] = 42752;
        nArray[213] = 42783;
        nArray[214] = 42784;
        nArray[215] = 43007;
        nArray[216] = 43008;
        nArray[217] = 43055;
        nArray[218] = 43072;
        nArray[219] = 43135;
        nArray[220] = 44032;
        nArray[221] = 55215;
        nArray[222] = 55296;
        nArray[223] = 56191;
        nArray[224] = 56192;
        nArray[225] = 56319;
        nArray[226] = 56320;
        nArray[227] = 57343;
        nArray[228] = 57344;
        nArray[229] = 63743;
        nArray[230] = 63744;
        nArray[231] = 64255;
        nArray[232] = 64256;
        nArray[233] = 64335;
        nArray[234] = 64336;
        nArray[235] = 65023;
        nArray[236] = 65024;
        nArray[237] = 65039;
        nArray[238] = 65040;
        nArray[239] = 65055;
        nArray[240] = 65056;
        nArray[241] = 65071;
        nArray[242] = 65072;
        nArray[243] = 65103;
        nArray[244] = 65104;
        nArray[245] = 65135;
        nArray[246] = 65136;
        nArray[247] = 65279;
        nArray[248] = 65280;
        nArray[249] = 65519;
        nArray[250] = 65520;
        nArray[251] = 65535;
        nArray[252] = 65536;
        nArray[253] = 65663;
        nArray[254] = 65664;
        nArray[255] = 65791;
        nArray[256] = 65792;
        nArray[257] = 65855;
        nArray[258] = 65856;
        nArray[259] = 65935;
        nArray[260] = 66304;
        nArray[261] = 66351;
        nArray[262] = 66352;
        nArray[263] = 66383;
        nArray[264] = 66432;
        nArray[265] = 66463;
        nArray[266] = 66464;
        nArray[267] = 66527;
        nArray[268] = 66560;
        nArray[269] = 66639;
        nArray[270] = 66640;
        nArray[271] = 66687;
        nArray[272] = 66688;
        nArray[273] = 66735;
        nArray[274] = 67584;
        nArray[275] = 67647;
        nArray[276] = 67840;
        nArray[277] = 67871;
        nArray[278] = 68096;
        nArray[279] = 68191;
        nArray[280] = 73728;
        nArray[281] = 74751;
        nArray[282] = 74752;
        nArray[283] = 74879;
        nArray[284] = 118784;
        nArray[285] = 119039;
        nArray[286] = 119040;
        nArray[287] = 119295;
        nArray[288] = 119296;
        nArray[289] = 119375;
        nArray[290] = 119552;
        nArray[291] = 119647;
        nArray[292] = 119648;
        nArray[293] = 119679;
        nArray[294] = 119808;
        nArray[295] = 120831;
        nArray[296] = 131072;
        nArray[297] = 173791;
        nArray[298] = 194560;
        nArray[299] = 195103;
        nArray[300] = 917504;
        nArray[301] = 917631;
        nArray[302] = 917760;
        nArray[303] = 917999;
        nArray[304] = 983040;
        nArray[305] = 1048575;
        nArray[306] = 0x100000;
        nArray[307] = 0x10FFFF;
        blockEdges = nArray;
    }

    public CompositeFont(String name, String defaultFont) {
        this.name = name;
        this.defaultFont = defaultFont;
        this.blockFontMapping = new HashMap();
    }

    public CompositeFont(String name) {
        this(name, null);
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    public void setBlockFont(int blockIndex, String font) {
        Block block = this.getBlock(blockIndex);
        block.setFont(font);
    }

    public void setCharacterFont(char character, String font) {
        Block block = this.getBlock(character);
        block.addCharacterFont(character, font);
    }

    public String getCharacterFont(char character) {
        Block block = this.getBlock(character);
        String result = block.getCharacterFont(character);
        if (result == null) {
            result = this.defaultFont;
        }
        return result;
    }

    public int getBlockCount() {
        return this.blockFontMapping.size();
    }

    public String getBlockFont(int i) {
        Block block = (Block)this.blockFontMapping.get(new Integer(i));
        if (block != null) {
            return block.getFont();
        }
        return null;
    }

    private Block getBlock(char character) {
        int blockIndex = CompositeFont.getBlockIndex(character);
        Block block = this.getBlock(blockIndex);
        return block;
    }

    private Block getBlock(int blockIndex) {
        Integer blockKey = new Integer(blockIndex);
        Block block = (Block)this.blockFontMapping.get(blockKey);
        if (block == null) {
            block = new Block();
            this.blockFontMapping.put(blockKey, block);
        }
        return block;
    }

    public static int getBlockIndex(char c) {
        int low = 0;
        int high = 153;
        while (low <= high) {
            int mid = (low + high) / 2;
            int minVal = blockEdges[mid * 2];
            int maxVal = blockEdges[mid * 2 + 1];
            if (c < minVal) {
                high = mid - 1;
                continue;
            }
            if (c > maxVal) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static class Block {
        private String font;
        private Map characterFontMapping;

        public void setFont(String font) {
            this.font = font;
        }

        public String getFont() {
            return this.font;
        }

        public void addCharacterFont(char character, String font) {
            if (this.characterFontMapping == null) {
                this.characterFontMapping = new HashMap();
            }
            this.characterFontMapping.put(new Character(character), font);
        }

        String getCharacterFont(char character) {
            String result;
            if (this.characterFontMapping != null && (result = (String)this.characterFontMapping.get(new Character(character))) != null) {
                return result;
            }
            return this.font;
        }
    }
}

