/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.FontFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFont;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FontConfigReader {
    private static final int DEFAULT_BLOCK_INDEX = -1;
    private static final String TAG_COMPOSITE_FONT = "composite-font";
    private static final String TAG_ALL_FONTS = "all-fonts";
    private static final String TAG_BLOCK = "block";
    private static final String TAG_CHARACTER = "character";
    private static final String TAG_MAPPING = "mapping";
    private static final String TAG_PATH = "path";
    private static final String TAG_ENCODING = "encoding";
    private static final String TAG_FONT_MAPPINGS = "font-mappings";
    private static final String TAG_FONT_ALIASES = "font-aliases";
    private static final String PROP_BLOCK_INDEX = "index";
    private static final String PROP_NAME = "name";
    private static final String PROP_FONT_FAMILY = "font-family";
    private static final String PROP_ENCODING = "encoding";
    private static final String PROP_PATH = "path";
    private static final String DEFAULT_BLOCK = "default";
    private static final String CONFIG_FILE_PREFIX = "/fontsConfig";
    private static final String CONFIG_FILE_SUFFIX = ".xml";
    private static final String CONFIG_FILE_SEPERATOR = "_";
    private FontMappingManager fontMappingManager = new FontMappingManager();
    protected static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.font.FontConfigReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public void initialize() {
        String embededFontPath = this.getEmbededFontPath();
        if (embededFontPath != null) {
            FontFactory.registerDirectory((String)embededFontPath);
        }
        this.parseFormatUnrelatedConfigFile();
    }

    public void parseFormatUnrelatedConfigFile() {
        String defaultConfig = "/fontsConfig.xml";
        this.parseConfigFile(defaultConfig);
        String platformConfigPrefix = FontConfigReader.getPlatformConfig();
        String platformConfig = String.valueOf(platformConfigPrefix) + CONFIG_FILE_SUFFIX;
        this.parseConfigFile(platformConfig);
        Locale locale = Locale.getDefault();
        String languageConfigPrefix = String.valueOf(platformConfigPrefix) + CONFIG_FILE_SEPERATOR + locale.getLanguage();
        String languageConfig = String.valueOf(languageConfigPrefix) + CONFIG_FILE_SUFFIX;
        this.parseConfigFile(languageConfig);
        String countryConfig = String.valueOf(languageConfigPrefix) + CONFIG_FILE_SEPERATOR + locale.getCountry() + CONFIG_FILE_SUFFIX;
        this.parseConfigFile(countryConfig);
    }

    private static String getPlatformConfig() {
        return "/fontsConfig_" + FontConfigReader.getOsName();
    }

    private static String getOsName() {
        String osName = System.getProperty("os.name");
        osName = osName.replaceAll(" ", CONFIG_FILE_SEPERATOR);
        return osName;
    }

    public boolean parseFormatRelatedConfigFile(String format) {
        String configFile = "/fontsConfig_" + format + CONFIG_FILE_SUFFIX;
        boolean result = this.parseConfigFile(configFile);
        configFile = "/fontsConfig_" + format + CONFIG_FILE_SEPERATOR + FontConfigReader.getOsName() + CONFIG_FILE_SUFFIX;
        return result | this.parseConfigFile(configFile);
    }

    public boolean parseConfigFile(String configFile) throws FactoryConfigurationError {
        try {
            URL fileURL = this.getURL(configFile);
            return this.parseConfigFile(fileURL);
        }
        catch (Exception se) {
            logger.log(Level.WARNING, se.getMessage(), se);
            return false;
        }
    }

    protected URL getURL(String configFile) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.birt.report.engine.fonts");
        if (bundle == null) {
            return null;
        }
        URL fileURL = bundle.getEntry(configFile);
        return fileURL;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parseConfigFile(URL fileURL) throws IOException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        if (fileURL == null) {
            return false;
        }
        InputStream cfgFile = fileURL.openStream();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(cfgFile), Charset.forName("UTF-8"));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(reader));
            this.handleFontMappings(doc);
            this.handleCompositeFonts(doc);
            this.handleFontPaths(doc);
            this.handleFontEncodings(doc);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            cfgFile.close();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        cfgFile.close();
        return true;
    }

    public String getEmbededFontPath() {
        Path path;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.birt.report.engine.fonts");
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)(path = new Path("/fonts")), null);
        if (fileURL == null) {
            return null;
        }
        String fontPath = null;
        try {
            fontPath = FileLocator.toFileURL((URL)fileURL).getPath();
            if (fontPath != null && fontPath.length() >= 3 && fontPath.charAt(2) == ':') {
                return fontPath.substring(1);
            }
            return fontPath;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
            return null;
        }
    }

    public FontMappingManager getFontMappingManager() {
        return new FontMappingManager(this.fontMappingManager);
    }

    public void reset() {
        this.fontMappingManager.reset();
    }

    private void handleFontEncodings(Document doc) {
        HashMap<String, String> fontEncoding = new HashMap<String, String>();
        NodeList encodings = doc.getDocumentElement().getElementsByTagName("encoding");
        int i = 0;
        while (i < encodings.getLength()) {
            Node node = encodings.item(i);
            String fontFamily = this.getProperty(node, PROP_FONT_FAMILY);
            String encoding = this.getProperty(node, "encoding");
            if (this.notBlank(encoding) && this.notBlank(fontFamily)) {
                fontEncoding.put(fontFamily, encoding);
            }
            ++i;
        }
        this.fontMappingManager.addFontEncoding(fontEncoding);
    }

    private void handleFontPaths(Document doc) {
        NodeList paths = doc.getDocumentElement().getElementsByTagName("path");
        int i = 0;
        while (i < paths.getLength()) {
            Node node = paths.item(i);
            String path = this.getProperty(node, "path");
            if (this.notBlank(path)) {
                this.fontMappingManager.addFontPath(path);
            }
            ++i;
        }
    }

    private void handleFontMappings(Document doc) {
        Element documentElement = doc.getDocumentElement();
        this.processFontMappings(documentElement.getElementsByTagName(TAG_FONT_MAPPINGS));
        this.processFontMappings(documentElement.getElementsByTagName(TAG_FONT_ALIASES));
    }

    private void processFontMappings(NodeList fontMappings) {
        if (fontMappings == null || fontMappings.getLength() <= 0) {
            return;
        }
        Node fontMapping = fontMappings.item(0);
        NodeList childNodes = fontMapping.getChildNodes();
        HashMap<String, String> fontMappingResult = new HashMap<String, String>();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && TAG_MAPPING.equals(node.getNodeName())) {
                String name = this.getProperty(node, PROP_NAME);
                String fontFamily = this.getProperty(node, PROP_FONT_FAMILY);
                if (this.notBlank(name) && this.notBlank(fontFamily)) {
                    fontMappingResult.put(name, fontFamily);
                }
            }
            ++i;
        }
        this.fontMappingManager.addFontMapping(fontMappingResult);
    }

    private void handleCompositeFonts(Document doc) {
        this.handleAllFontsNode(doc);
        this.handleCompositeFontsNode(doc);
    }

    private void handleCompositeFontsNode(Document doc) {
        NodeList compositeFonts = doc.getDocumentElement().getElementsByTagName(TAG_COMPOSITE_FONT);
        int i = 0;
        while (i < compositeFonts.getLength()) {
            Node node = compositeFonts.item(i);
            CompositeFont compositeFont = this.parseComsiteFont(node);
            this.fontMappingManager.addCompositeFonts(compositeFont.getName(), compositeFont);
            ++i;
        }
    }

    private void handleAllFontsNode(Document doc) {
        NodeList allFonts = doc.getDocumentElement().getElementsByTagName(TAG_ALL_FONTS);
        if (allFonts.getLength() != 0) {
            Node node = allFonts.item(0);
            NodeList blocks = node.getChildNodes();
            int i = 0;
            while (i < blocks.getLength()) {
                Node blockNode = blocks.item(i);
                if (TAG_BLOCK.equalsIgnoreCase(blockNode.getNodeName())) {
                    String blockIndex = this.getProperty(blockNode, PROP_BLOCK_INDEX);
                    if (this.notBlank(blockIndex)) {
                        int index = Integer.parseInt(blockIndex);
                        this.processAllFontsMapping(blockNode, index);
                    } else {
                        String blockName = this.getProperty(blockNode, PROP_NAME);
                        if (DEFAULT_BLOCK.equalsIgnoreCase(blockName)) {
                            this.processAllFontsMapping(blockNode, -1);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void processAllFontsMapping(Node blockNode, int blockIndex) {
        boolean isDefault = blockIndex == -1;
        NodeList mappings = blockNode.getChildNodes();
        int j = 0;
        while (j < mappings.getLength()) {
            Node mapping = mappings.item(j);
            if (mapping.getNodeType() == 1) {
                String name = this.getProperty(mapping, PROP_NAME);
                String fontFamily = this.getProperty(mapping, PROP_FONT_FAMILY);
                if (this.notBlank(fontFamily)) {
                    if (isDefault) {
                        this.fontMappingManager.setDefaultFont(name, fontFamily);
                    } else {
                        this.fontMappingManager.addBlockToCompositeFont(name, blockIndex, fontFamily);
                    }
                }
            }
            ++j;
        }
    }

    private CompositeFont parseComsiteFont(Node node) {
        NodeList blocks = node.getChildNodes();
        String fontName = this.getProperty(node, PROP_NAME);
        String defaultFont = this.getProperty(node, PROP_FONT_FAMILY);
        CompositeFont compositeFont = new CompositeFont(fontName, defaultFont);
        int i = 0;
        while (i < blocks.getLength()) {
            String font;
            Node blockNode = blocks.item(i);
            String nodeName = blockNode.getNodeName();
            if (TAG_BLOCK.equalsIgnoreCase(nodeName)) {
                String blockIndex = this.getProperty(blockNode, PROP_BLOCK_INDEX);
                if (this.notBlank(blockIndex)) {
                    int index = Integer.parseInt(blockIndex);
                    font = this.getProperty(blockNode, PROP_FONT_FAMILY);
                    compositeFont.setBlockFont(index, font);
                } else {
                    String blockName = this.getProperty(blockNode, PROP_NAME);
                    if (DEFAULT_BLOCK.equalsIgnoreCase(blockName) && (font = this.getProperty(blockNode, PROP_FONT_FAMILY)) != null && compositeFont.getDefaultFont() == null) {
                        compositeFont.setDefaultFont(font);
                    }
                }
            } else if (TAG_CHARACTER.equalsIgnoreCase(nodeName)) {
                String character = this.getProperty(blockNode, "value");
                try {
                    char c = this.getChar(character);
                    font = this.getProperty(blockNode, PROP_FONT_FAMILY);
                    if (font != null) {
                        compositeFont.setCharacterFont(c, font);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            ++i;
        }
        return compositeFont;
    }

    private char getChar(String character) throws Exception {
        if (character.matches(".")) {
            return character.charAt(0);
        }
        if (character.matches("\\\\u\\p{XDigit}{4}")) {
            String unicode = character.substring(2);
            return (char)Integer.parseInt(unicode, 16);
        }
        throw new Exception("Unknow character value: " + character);
    }

    private boolean notBlank(String propertyName) {
        return propertyName != null && propertyName.length() != 0;
    }

    private String getProperty(Node node, String propertyName) {
        Node property;
        if (node == null) {
            return null;
        }
        NamedNodeMap atts = node.getAttributes();
        if (atts != null && (property = atts.getNamedItem(propertyName)) != null) {
            return property.getNodeValue();
        }
        return null;
    }
}

