/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFont;

public class FontMappingManager {
    private static final String SERIF = "serif";
    private static final String SANS_SERIF = "sans-serif";
    private static final String CURSIVE = "cursive";
    private static final String MONOSPACE = "monospace";
    private static final String FANTASY = "fantasy";
    private static final String DEFAULT_SERIF_FONT = "Times-Roman";
    private static final String DEFAULT_SANS_SERIF_FONT = "Helvetica";
    private static final String DEFAULT_CURSIVE_FONT = "ZapfDingbats";
    private static final String DEFAULT_MONOSPACE_FONT = "Courier";
    private static final String DEFAULT_FANTASY_FONT = "Times-Roman";
    public static final String FONT_NAME_ALL_FONTS = "all-fonts";
    public static final String DEFAULT_FONT = "Times-Roman";
    private static final String BLOCK_DEFAULT = "default";
    protected static Logger logger;
    private Map fontAliases = new HashMap();
    private Map fontEncodings = new HashMap();
    private Map compositeFonts = new HashMap();
    private Set fontPaths = new HashSet();
    private HashMap baseFonts = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    FontMappingManager() {
        this.initializeFontMapping();
        this.initializeFontEncoding();
    }

    FontMappingManager(FontMappingManager fontManager) {
        this.fontAliases.putAll(fontManager.fontAliases);
        this.fontEncodings.putAll(fontManager.fontEncodings);
        this.compositeFonts.putAll(fontManager.compositeFonts);
        this.fontPaths.addAll(fontManager.fontPaths);
    }

    public FontMappingManager merge(FontMappingManager fontManager) {
        FontMappingManager result = new FontMappingManager(this);
        result.fontAliases.putAll(fontManager.fontAliases);
        result.fontEncodings.putAll(fontManager.fontEncodings);
        result.compositeFonts.putAll(fontManager.compositeFonts);
        result.fontPaths.addAll(fontManager.fontPaths);
        return result;
    }

    protected void initializeFontMapping() {
        this.fontAliases.put(SERIF, "Times-Roman");
        this.fontAliases.put(SANS_SERIF, DEFAULT_SANS_SERIF_FONT);
        this.fontAliases.put(CURSIVE, DEFAULT_CURSIVE_FONT);
        this.fontAliases.put(MONOSPACE, DEFAULT_MONOSPACE_FONT);
        this.fontAliases.put(FANTASY, "Times-Roman");
    }

    protected void initializeFontEncoding() {
        this.fontEncodings.put("Times-Roman", "Cp1252");
        this.fontEncodings.put(DEFAULT_SANS_SERIF_FONT, "Cp1252");
        this.fontEncodings.put(DEFAULT_MONOSPACE_FONT, "Cp1252");
        this.fontEncodings.put("Symbol", "Cp1252");
        this.fontEncodings.put(DEFAULT_CURSIVE_FONT, "Cp1252");
        this.fontEncodings.put("Times", "Cp1252");
    }

    public String getDefaultPhysicalFont(char c) {
        return this.getPhysicalFont(c, FONT_NAME_ALL_FONTS, "Times-Roman");
    }

    public void addFontPath(String path) {
        File file = new File(path);
        if (file.exists()) {
            try {
                this.fontPaths.add(file.getCanonicalPath());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage());
            }
        }
    }

    public Set getFontPaths() {
        return this.fontPaths;
    }

    public String getPhysicalFont(char c, String logicalFont, String defaultFont) {
        CompositeFont compositeFont;
        String font;
        if (this.isCompositeFont(logicalFont) && (font = (compositeFont = (CompositeFont)this.compositeFonts.get(logicalFont)).getCharacterFont(c)) != null) {
            return font;
        }
        return defaultFont;
    }

    private boolean isCompositeFont(String logicalFont) {
        return this.compositeFonts.containsKey(logicalFont);
    }

    public String getLogicalFont(String fontFamilyName) {
        String fontName = this.getMappedFontName(fontFamilyName, this.fontAliases);
        return fontName == null ? fontFamilyName : fontName;
    }

    public void addCompositeFonts(String fontName, CompositeFont compositeFont) {
        this.compositeFonts.put(fontName, compositeFont);
    }

    public void addBlockToCompositeFont(String fontName, int blockIndex, String fontMappedTo) {
        CompositeFont compositeFont = this.getCompositFont(fontName);
        compositeFont.setBlockFont(blockIndex, fontMappedTo);
    }

    public void setDefaultFont(String fontName, String defaultFont) {
        CompositeFont compositeFont = this.getCompositFont(fontName);
        compositeFont.setDefaultFont(defaultFont);
    }

    private CompositeFont getCompositFont(String fontName) {
        CompositeFont compositeFont = (CompositeFont)this.compositeFonts.get(fontName);
        if (compositeFont == null) {
            compositeFont = new CompositeFont(fontName);
            this.compositeFonts.put(fontName, compositeFont);
        }
        return compositeFont;
    }

    public Map getFontAliases() {
        return this.fontAliases;
    }

    public void addFontEncoding(HashMap fontEncoding) {
        this.fontEncodings.putAll(fontEncoding);
    }

    public void addFontMapping(HashMap fontMapping) {
        this.fontAliases.putAll(fontMapping);
    }

    public Map getCompositeFonts() {
        return this.compositeFonts;
    }

    public Map getFontEncodings() {
        return this.fontEncodings;
    }

    public void reset() {
        this.fontAliases.clear();
        this.fontEncodings.clear();
        this.compositeFonts.clear();
        this.fontPaths.clear();
    }

    private String getMappedFontName(String fontFamilyName, Map fontMap) {
        return (String)fontMap.get(fontFamilyName);
    }

    public String getEncoding(String fontFamilyName) {
        String encoding = (String)this.fontEncodings.get(fontFamilyName);
        return encoding == null ? "Identity-H" : encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFont createFont(String ffn, int fontStyle) {
        String key = String.valueOf(ffn) + fontStyle;
        HashMap hashMap = this.baseFonts;
        synchronized (hashMap) {
            BaseFont font = (BaseFont)this.baseFonts.get(key);
            if (font == null) {
                String encoding = this.getEncoding(ffn);
                Font f = null;
                try {
                    f = FontFactory.getFont((String)ffn, (String)encoding, (boolean)false, (float)14.0f, (int)fontStyle);
                    font = f.getBaseFont();
                    if (font != null) {
                        this.baseFonts.put(key, font);
                    }
                }
                catch (Throwable de) {
                    logger.log(Level.WARNING, de.getLocalizedMessage());
                }
            }
            return font;
        }
    }

    public boolean isCharDefinedInFont(char c, String fontName, int fontStyle) {
        BaseFont bf = this.createFont(fontName, fontStyle);
        return bf != null && bf.charExists(c);
    }
}

