/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.ListValue;
import org.eclipse.birt.report.engine.css.engine.value.Value;

public abstract class StyleProcessor {
    private static Map tag2Style = new HashMap();

    static {
        tag2Style.put("code", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontFamily(style, IStyle.MONOSPACE_VALUE);
            }
        });
        tag2Style.put("em", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontStyle(style, IStyle.ITALIC_VALUE);
            }
        });
        tag2Style.put("h1", new StyleProcessor(){

            public void process(IStyle style) {
                this.setHStyle(style, 2.0f, 0.67f);
            }
        });
        tag2Style.put("h2", new StyleProcessor(){

            public void process(IStyle style) {
                this.setHStyle(style, 1.5f, 0.75f);
            }
        });
        tag2Style.put("h3", new StyleProcessor(){

            public void process(IStyle style) {
                this.setHStyle(style, 1.17f, 0.83f);
            }
        });
        tag2Style.put("h4", new StyleProcessor(){

            public void process(IStyle style) {
                this.setHStyle(style, 1.12f, 1.12f);
            }
        });
        tag2Style.put("h5", new StyleProcessor(){

            public void process(IStyle style) {
                this.setHStyle(style, 0.83f, 1.5f);
            }
        });
        tag2Style.put("h6", new StyleProcessor(){

            public void process(IStyle style) {
                this.setHStyle(style, 0.75f, 1.67f);
            }
        });
        tag2Style.put("pre", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontFamily(style, IStyle.MONOSPACE_VALUE);
                style.setProperty(40, IStyle.NOWRAP_VALUE);
            }
        });
        tag2Style.put("strong", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontWeight(style, IStyle.BOLD_VALUE);
            }
        });
        tag2Style.put("sub", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(30, IStyle.BOTTOM_VALUE);
                style.setProperty(38, 11.createPercentageValue(75.0f));
            }
        });
        tag2Style.put("sup", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(30, IStyle.TOP_VALUE);
                style.setProperty(38, 12.createPercentageValue(75.0f));
            }
        });
        tag2Style.put("tt", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontFamily(style, IStyle.MONOSPACE_VALUE);
            }
        });
        tag2Style.put("center", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(26, IStyle.CENTER_VALUE);
            }
        });
        tag2Style.put("i", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontStyle(style, IStyle.ITALIC_VALUE);
            }
        });
        tag2Style.put("address", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontStyle(style, IStyle.ITALIC_VALUE);
            }
        });
        tag2Style.put("b", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontWeight(style, IStyle.BOLD_VALUE);
            }
        });
        tag2Style.put("p", new StyleProcessor(){

            public void process(IStyle style) {
                this.setMarginTopAndBottom(style, 1.33f);
            }
        });
        tag2Style.put("u", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(8, IStyle.UNDERLINE_VALUE);
            }
        });
        tag2Style.put("del", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(16, IStyle.LINE_THROUGH_VALUE);
            }
        });
    }

    abstract void process(IStyle var1);

    protected void setHStyle(IStyle style, float fontSize, float margin) {
        this.setMarginTopAndBottom(style, margin);
        style.setProperty(38, StyleProcessor.createEmValue(fontSize));
        style.setProperty(27, IStyle.BOLD_VALUE);
        style.setProperty(51, IStyle.AVOID_VALUE);
    }

    protected void setMarginTopAndBottom(IStyle style, float margin) {
        style.setProperty(53, StyleProcessor.createEmValue(margin));
        style.setProperty(52, StyleProcessor.createEmValue(margin));
    }

    protected void setFontFamily(IStyle style, Value font) {
        ListValue fonts = new ListValue();
        fonts.append(font);
        style.setProperty(49, fonts);
    }

    protected void setFontStyle(IStyle style, Value fontStyle) {
        style.setProperty(39, fontStyle);
    }

    protected void setFontWeight(IStyle style, Value fontWeight) {
        style.setProperty(27, fontWeight);
    }

    public static StyleProcessor getStyleProcess(String tagName) {
        return (StyleProcessor)tag2Style.get(tagName);
    }

    public static FloatValue createEmValue(float value) {
        return StyleProcessor.createFloatValue((short)3, value);
    }

    public static FloatValue createPercentageValue(float value) {
        return StyleProcessor.createFloatValue((short)2, value);
    }

    private static FloatValue createFloatValue(short unitType, float value) {
        return new FloatValue(unitType, value);
    }
}

