/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.IModelOdaAdapter;
import org.eclipse.birt.report.model.adapter.oda.IODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.ODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.impl.DataSetParameterAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.DesignerStateAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.ResultSetsAdapter;
import org.eclipse.birt.report.model.adapter.oda.model.DesignValues;
import org.eclipse.birt.report.model.adapter.oda.model.ModelFactory;
import org.eclipse.birt.report.model.adapter.oda.model.util.SerializerImpl;
import org.eclipse.birt.report.model.adapter.oda.util.IdentifierUtility;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedPropertyHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.OdaDesignerStateHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.ExtendedProperty;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.PropertyValueValidationUtil;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ResultSets;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModelOdaAdapter
implements IModelOdaAdapter {
    private IODADesignFactory designFactory = ODADesignFactory.getFactory();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.adapter.oda.impl.ModelOdaAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DataSourceDesign createDataSourceDesign(OdaDataSourceHandle sourceHandle) {
        if (sourceHandle == null) {
            return null;
        }
        DataSourceDesign sourceDesign = this.designFactory.createDataSourceDesign();
        this.updateDataSourceDesign(sourceHandle, sourceDesign);
        return sourceDesign;
    }

    public DataSetDesign createDataSetDesign(OdaDataSetHandle setHandle) {
        if (setHandle == null) {
            return null;
        }
        DataSetDesign setDesign = this.designFactory.createDataSetDesign();
        this.updateDataSetDesign(setHandle, setDesign);
        return setDesign;
    }

    public OdaDataSetHandle createDataSetHandle(DataSetDesign setDesign, ModuleHandle module) throws SemanticException, IllegalStateException {
        if (setDesign == null) {
            return null;
        }
        DesignUtil.validateObject((EObject)setDesign);
        OdaDataSetHandle setHandle = module.getElementFactory().newOdaDataSet(setDesign.getName(), setDesign.getOdaExtensionDataSetId());
        if (setHandle == null) {
            return null;
        }
        this.adaptDataSetDesign(setDesign, setHandle);
        return setHandle;
    }

    private void adaptDataSetDesign(DataSetDesign setDesign, OdaDataSetHandle setHandle) throws SemanticException {
        Object value = null;
        value = setDesign.getName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"name", (Object)value);
        setHandle.getElement().setName(setDesign.getName());
        value = setDesign.getDisplayName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"displayName", (Object)value);
        setHandle.getElement().setProperty("displayName", (Object)setDesign.getDisplayName());
        value = this.newROMPrivateProperties(setDesign.getPrivateProperties());
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"privateDriverProperties", (Object)value);
        setHandle.getElement().setProperty("privateDriverProperties", value);
        this.updateROMPublicProperties(setDesign.getPublicProperties(), (ReportElementHandle)setHandle);
        DataSourceDesign sourceDesign = setDesign.getDataSourceDesign();
        if (sourceDesign != null) {
            String dataSourceName = sourceDesign.getName();
            setHandle.getElement().setProperty("dataSource", PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"dataSource", (Object)dataSourceName));
        } else {
            setHandle.getElement().clearProperty("dataSource");
        }
        setHandle.getElement().clearProperty("parameters");
        List dataSetParams = new DataSetParameterAdapter(setHandle, setDesign).newROMSetParams(null);
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"parameters", (Object)dataSetParams);
        setHandle.getElement().setProperty("parameters", (Object)dataSetParams);
        List resultRetColumns = new ResultSetsAdapter(setHandle, setDesign).newROMResultSets(null);
        ArrayList columns = null;
        ArrayList hints = null;
        if (resultRetColumns != null) {
            columns = new ArrayList();
            hints = new ArrayList();
            ResultSetsAdapter.ResultSetColumnInfo.updateResultSetColumnList(resultRetColumns, columns, hints);
            PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"resultSet", columns);
            PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"columnHints", hints);
        }
        setHandle.getElement().setProperty("columnHints", hints);
        setHandle.getElement().setProperty("resultSet", columns);
        String queryText = setDesign.getQueryText();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"queryText", (Object)queryText);
        setHandle.getElement().setProperty("queryText", (Object)queryText);
        String resultSetName = setDesign.getPrimaryResultSetName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"resultSetName", (Object)queryText);
        setHandle.getElement().setProperty("resultSetName", (Object)resultSetName);
        String odaValues = this.serializeOdaValues(setDesign);
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"designerValues", (Object)odaValues);
        setHandle.getElement().setProperty("designerValues", (Object)odaValues);
    }

    private String serializeOdaValues(DataSetDesign setDesign) {
        DataSetParameters params = setDesign.getParameters();
        ResultSets resultSets = setDesign.getResultSets();
        DesignValues values = ModelFactory.eINSTANCE.createDesignValues();
        values.setVersion("1.0");
        boolean hasData = false;
        if (params != null) {
            values.setDataSetParameters((DataSetParameters)EcoreUtil.copy((EObject)params));
            hasData = true;
        }
        if (resultSets != null) {
            values.setResultSets((ResultSets)EcoreUtil.copy((EObject)resultSets));
            hasData = true;
        }
        if (!hasData) {
            return "";
        }
        try {
            return SerializerImpl.instance().write(values);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void updateDataSetDesign(OdaDataSetHandle setHandle, DataSetDesign setDesign) {
        setDesign.setName(setHandle.getName());
        setDesign.setDisplayName(setHandle.getDisplayName());
        setDesign.setOdaExtensionDataSetId(setHandle.getExtensionID());
        setDesign.setPublicProperties(this.newOdaPublicProperties(setHandle.getExtensionPropertyDefinitionList(), (ReportElementHandle)setHandle));
        setDesign.setPrivateProperties(this.newOdaPrivateProperties(setHandle.privateDriverPropertiesIterator()));
        setDesign.setPrimaryResultSetName(setHandle.getResultSetName());
        setDesign.setQueryText(setHandle.getQueryText());
        OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)setHandle.getDataSource();
        if (sourceHandle != null) {
            setDesign.setDataSourceDesign(this.createDataSourceDesign(sourceHandle));
        }
        String strDesignValues = setHandle.getDesignerValues();
        DesignValues designerValues = null;
        try {
            if (strDesignValues != null) {
                designerValues = SerializerImpl.instance().read(strDesignValues);
            }
        }
        catch (IOException iOException) {}
        DataSetParameters cachedParams = null;
        if (designerValues != null) {
            cachedParams = designerValues.getDataSetParameters();
        }
        DataSetParameters designDefinedParams = null;
        if (cachedParams != null) {
            designDefinedParams = (DataSetParameters)EcoreUtil.copy((EObject)cachedParams);
            setDesign.setParameters(designDefinedParams);
        }
        if (designDefinedParams == null) {
            setDesign.setParameters(new DataSetParameterAdapter(setHandle, setDesign).newOdaDataSetParams(cachedParams));
        }
        setDesign.setPrimaryResultSet(new ResultSetsAdapter(setHandle, setDesign).newOdaResultSetDefinition());
    }

    public void updateDataSetDesign(OdaDataSetHandle setHandle, DataSetDesign setDesign, String propertyName) {
        if (setHandle == null || setDesign == null || propertyName == null) {
            return;
        }
        if ("name".equalsIgnoreCase(propertyName)) {
            setDesign.setName(setHandle.getName());
        } else if ("displayName".equalsIgnoreCase(propertyName)) {
            setDesign.setDisplayName(setHandle.getDisplayName());
        } else if ("extensionID".equalsIgnoreCase(propertyName)) {
            setDesign.setOdaExtensionDataSetId(setHandle.getExtensionID());
        } else if ("privateDriverProperties".equalsIgnoreCase(propertyName)) {
            setDesign.setPrivateProperties(this.newOdaPrivateProperties(setHandle.privateDriverPropertiesIterator()));
        } else if ("resultSetName".equalsIgnoreCase(propertyName)) {
            setDesign.setPrimaryResultSetName(setHandle.getResultSetName());
        } else if ("queryText".equalsIgnoreCase(propertyName)) {
            setDesign.setQueryText(setHandle.getQueryText());
        } else if ("dataSource".equalsIgnoreCase(propertyName)) {
            OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)setHandle.getDataSource();
            if (sourceHandle != null) {
                setDesign.setDataSourceDesign(this.createDataSourceDesign(sourceHandle));
            }
        } else if ("parameters".equalsIgnoreCase(propertyName)) {
            DataSetParameters dsParams = new DataSetParameterAdapter(setHandle, setDesign).newOdaDataSetParams(null);
            if (dsParams != null) {
                setDesign.setParameters(dsParams);
            } else {
                setDesign.setParameters(null);
            }
        } else if ("resultSet".equalsIgnoreCase(propertyName)) {
            setDesign.setPrimaryResultSet(new ResultSetsAdapter(setHandle, setDesign).newOdaResultSetDefinition());
        } else if ("columnHints".equalsIgnoreCase(propertyName)) {
            new ResultSetsAdapter(setHandle, setDesign).updateOdaColumnHints();
        }
    }

    public void updateDataSourceDesign(OdaDataSourceHandle sourceHandle, DataSourceDesign sourceDesign) {
        sourceDesign.setName(sourceHandle.getName());
        sourceDesign.setDisplayName(sourceHandle.getDisplayName());
        sourceDesign.setOdaExtensionId(sourceHandle.getExtensionID());
        sourceDesign.setPrivateProperties(this.newOdaPrivateProperties(sourceHandle.privateDriverPropertiesIterator()));
        sourceDesign.setPublicProperties(this.newOdaPublicProperties(sourceHandle.getExtensionPropertyDefinitionList(), (ReportElementHandle)sourceHandle));
    }

    private Properties newOdaPublicProperties(List propDefns, ReportElementHandle element) {
        if (propDefns == null) {
            return null;
        }
        Properties retProps = null;
        int i = 0;
        while (i < propDefns.size()) {
            if (retProps == null) {
                retProps = this.designFactory.createProperties();
            }
            IPropertyDefn propDefn = (IPropertyDefn)propDefns.get(i);
            String propName = propDefn.getName();
            String propValue = element.getStringProperty(propName);
            retProps.setProperty(propName, propValue);
            ++i;
        }
        return retProps;
    }

    private Properties newOdaPrivateProperties(Iterator props) {
        if (props == null || !props.hasNext()) {
            return null;
        }
        Properties retProps = this.designFactory.createProperties();
        while (props.hasNext()) {
            ExtendedPropertyHandle propHandle = (ExtendedPropertyHandle)props.next();
            retProps.setProperty(propHandle.getName(), propHandle.getValue());
        }
        return retProps;
    }

    public OdaDataSourceHandle createDataSourceHandle(DataSourceDesign sourceDesign, ModuleHandle module) throws SemanticException, IllegalStateException {
        if (sourceDesign == null) {
            return null;
        }
        DesignUtil.validateObject((EObject)sourceDesign);
        OdaDataSourceHandle sourceHandle = module.getElementFactory().newOdaDataSource(sourceDesign.getName(), sourceDesign.getOdaExtensionId());
        if (sourceHandle == null) {
            return null;
        }
        this.adaptDataSourceDesign(sourceDesign, sourceHandle);
        return sourceHandle;
    }

    public void updateDataSourceHandle(DataSourceDesign sourceDesign, OdaDataSourceHandle sourceHandle) throws SemanticException {
        if (sourceDesign == null || sourceHandle == null) {
            return;
        }
        DesignUtil.validateObject((EObject)sourceDesign);
        CommandStack stack = sourceHandle.getModuleHandle().getCommandStack();
        stack.startTrans(null);
        try {
            Property prop;
            int i;
            EList propList;
            sourceHandle.getElement().setProperty("extensionID", (Object)sourceDesign.getOdaExtensionId());
            sourceHandle.setName(sourceDesign.getName());
            sourceHandle.setDisplayName(sourceDesign.getDisplayName());
            Properties props = sourceDesign.getPublicProperties();
            if (props != null) {
                propList = props.getProperties();
                i = 0;
                while (i < propList.size()) {
                    prop = (Property)propList.get(i);
                    sourceHandle.setProperty(prop.getName(), (Object)prop.getValue());
                    ++i;
                }
            }
            if ((props = sourceDesign.getPrivateProperties()) != null) {
                propList = props.getProperties();
                i = 0;
                while (i < propList.size()) {
                    prop = (Property)propList.get(i);
                    sourceHandle.setPrivateDriverProperty(prop.getName(), prop.getValue());
                    ++i;
                }
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void adaptDataSourceDesign(DataSourceDesign sourceDesign, OdaDataSourceHandle sourceHandle) throws SemanticException {
        Object value = null;
        value = sourceDesign.getName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)"name", (Object)value);
        sourceHandle.getElement().setName(sourceDesign.getName());
        value = sourceDesign.getDisplayName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)"displayName", (Object)value);
        sourceHandle.getElement().setProperty("displayName", (Object)sourceDesign.getDisplayName());
        value = this.newROMPrivateProperties(sourceDesign.getPrivateProperties());
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)"privateDriverProperties", (Object)value);
        sourceHandle.getElement().setProperty("privateDriverProperties", value);
        this.updateROMPublicProperties(sourceDesign.getPublicProperties(), (ReportElementHandle)sourceHandle);
    }

    private void updateROMPublicProperties(Properties designProps, ReportElementHandle sourceHandle) throws SemanticException {
        if (designProps == null) {
            return;
        }
        EList publicProps = designProps.getProperties();
        int i = 0;
        while (i < publicProps.size()) {
            Property prop = (Property)publicProps.get(i);
            String propName = prop.getName();
            String propValue = prop.getValue();
            propValue = (String)PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)propName, (Object)propValue);
            sourceHandle.getElement().setProperty(propName, (Object)propValue);
            ++i;
        }
    }

    private List newROMPrivateProperties(Properties props) {
        if (props == null) {
            return null;
        }
        ArrayList<ExtendedProperty> list = new ArrayList<ExtendedProperty>();
        EList designProps = props.getProperties();
        int i = 0;
        while (i < designProps.size()) {
            Property prop = (Property)designProps.get(i);
            ExtendedProperty extendedProperty = StructureFactory.createExtendedProperty();
            extendedProperty.setName(prop.getName());
            extendedProperty.setValue(prop.getValue());
            list.add(extendedProperty);
            ++i;
        }
        return list;
    }

    public void updateDataSetHandle(DataSetDesign setDesign, OdaDataSetHandle setHandle, boolean isSourceChanged) throws SemanticException {
        if (setDesign == null || setHandle == null) {
            return;
        }
        DesignValues designerValues = null;
        try {
            designerValues = SerializerImpl.instance().read(setHandle.getDesignerValues());
        }
        catch (IOException iOException) {}
        DataSetParameters requestParameters = null;
        ResultSets requestResultSets = null;
        if (designerValues != null) {
            requestParameters = designerValues.getDataSetParameters();
            requestResultSets = designerValues.getResultSets();
        }
        this.updateDataSetHandle(setDesign, setHandle, isSourceChanged, requestParameters, requestResultSets);
    }

    private void updateDesignerValue(DataSetDesign setDesign, OdaDataSetHandle setHandle, DataSetParameters requestParameters, List userDefinedList, ResultSets requestResultSets) throws SemanticException {
        DesignValues designerValues = null;
        DataSetParameters setDefinedParams = setDesign.getParameters();
        if (setDefinedParams == null) {
            if (requestParameters != null) {
                designerValues = ModelFactory.eINSTANCE.createDesignValues();
                designerValues.setDataSetParameters(null);
            }
        } else {
            List resultList = DataSetParameterAdapter.getDriverDefinedParameters(setDefinedParams.getParameterDefinitions(), userDefinedList);
            if (resultList.size() > 0) {
                designerValues = ModelFactory.eINSTANCE.createDesignValues();
                DataSetParameters dsParams = designerValues.getDataSetParameters();
                if (dsParams == null) {
                    dsParams = this.designFactory.createDataSetParameters();
                    designerValues.setDataSetParameters(dsParams);
                }
                EList params = dsParams.getParameterDefinitions();
                params.clear();
                params.addAll((Collection)resultList);
            }
        }
        if (designerValues == null) {
            setHandle.setDesignerValues(null);
            return;
        }
        designerValues.setResultSets(requestResultSets);
        try {
            String dValue = SerializerImpl.instance().write(designerValues);
            setHandle.setDesignerValues(dValue);
        }
        catch (IOException iOException) {}
    }

    private void updateROMResultSets(OdaDataSetHandle setHandle, ResultSetsAdapter tmpAdapter, ResultSetDefinition cachedResultDefn) throws SemanticException {
        int i;
        List structList = tmpAdapter.newROMResultSets(cachedResultDefn);
        ArrayList columns = new ArrayList();
        ArrayList hints = new ArrayList();
        ResultSetsAdapter.ResultSetColumnInfo.updateResultSetColumnList(structList, columns, hints);
        PropertyHandle propHandle = setHandle.getPropertyHandle("resultSet");
        propHandle.setValue(new ArrayList());
        if (!columns.isEmpty()) {
            i = 0;
            while (i < columns.size()) {
                propHandle.addItem(columns.get(i));
                ++i;
            }
        }
        propHandle = setHandle.getPropertyHandle("columnHints");
        propHandle.setValue(new ArrayList());
        if (!hints.isEmpty()) {
            i = 0;
            while (i < hints.size()) {
                ColumnHint hint = (ColumnHint)hints.get(i);
                ColumnHintHandle oldHint = ResultSetsAdapter.findColumnHint((String)hint.getProperty(null, "columnName"), setHandle.columnHintsIterator());
                if (oldHint == null) {
                    propHandle.addItem(hints.get(i));
                } else {
                    oldHint.setDisplayName((String)hint.getProperty(null, "displayName"));
                    oldHint.setHelpText((String)hint.getProperty(null, "helpText"));
                    oldHint.setFormat((String)hint.getProperty(null, "format"));
                }
                ++i;
            }
        }
        List hints4ComputedColumn = tmpAdapter.getHintsForComputedColumn();
        int i2 = 0;
        while (i2 < hints4ComputedColumn.size()) {
            propHandle.addItem((IStructure)((ColumnHint)hints4ComputedColumn.get(i2)));
            ++i2;
        }
    }

    public DesignerState newOdaDesignerState(OdaDataSetHandle setHandle) {
        OdaDesignerStateHandle designerState = setHandle.getDesignerState();
        return DesignerStateAdapter.createOdaDesignState(designerState);
    }

    public void updateROMDesignerState(DesignerState designerState, OdaDataSetHandle setHandle) throws SemanticException {
        if (designerState == null || setHandle == null) {
            return;
        }
        DesignerStateAdapter.updateROMDesignerState(designerState, (ReportElementHandle)setHandle);
    }

    public DesignerState newOdaDesignerState(OdaDataSourceHandle sourceHandle) {
        OdaDesignerStateHandle designerState = sourceHandle.getDesignerState();
        return DesignerStateAdapter.createOdaDesignState(designerState);
    }

    public void updateROMDesignerState(DesignerState designerState, OdaDataSourceHandle sourceHandle) throws SemanticException {
        if (designerState == null || sourceHandle == null) {
            return;
        }
        DesignerStateAdapter.updateROMDesignerState(designerState, (ReportElementHandle)sourceHandle);
    }

    private void updateROMDataSetParams(DataSetParameterAdapter setParamAdapter, DataSetParameters cachedParameters) throws SemanticException {
        List newParams = setParamAdapter.newROMSetParams(cachedParameters);
        IdentifierUtility.updateParams2UniqueName(newParams);
        setParamAdapter.updateRomDataSetParamsWithNewParams(newParams);
    }

    public boolean isEqualDataSourceDesign(DataSourceDesign designFromHandle, DataSourceDesign design) {
        if (designFromHandle == null && design == null) {
            return true;
        }
        if (designFromHandle != null && design == null) {
            return false;
        }
        if (designFromHandle == null && design != null) {
            return false;
        }
        if (!$assertionsDisabled && designFromHandle == null) {
            throw new AssertionError();
        }
        Properties handleProps = designFromHandle.getPublicProperties();
        Properties props = design.getPublicProperties();
        if (handleProps == null && props == null) {
            return true;
        }
        if (handleProps != null && props == null) {
            return false;
        }
        if (handleProps == null && props != null) {
            return false;
        }
        if (!$assertionsDisabled && handleProps == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && props == null) {
            throw new AssertionError();
        }
        EList publicProps = handleProps.getProperties();
        int i = 0;
        while (i < publicProps.size()) {
            String value;
            Property prop = (Property)publicProps.get(i);
            String propValue = prop.getValue();
            String propName = prop.getName();
            if (propValue == null && (value = props.getProperty(propName)) != null && value.trim().equals("")) {
                prop.setNameValue(prop.getName(), "");
            }
            ++i;
        }
        return new EcoreUtil.EqualityHelper().equals((EObject)designFromHandle, (EObject)design);
    }

    public OdaDesignSession createOdaDesignSession(OdaDataSetHandle dataSetHandle) {
        OdaDesignSession session = this.designFactory.createOdaDesignSession();
        DataSetDesign setDesign = this.createDataSetDesign(dataSetHandle);
        DesignSessionRequest request = this.designFactory.createDesignSessionRequest();
        request.setNewDataAccessDesign(setDesign);
        request.setDesignerState(DesignerStateAdapter.createOdaDesignState(dataSetHandle.getDesignerState()));
        session.setRequest(request);
        return session;
    }

    public void updateDataSetHandle(OdaDataSetHandle dataSetHandle, OdaDesignSession completedSession) throws SemanticException {
        if (completedSession == null || dataSetHandle == null) {
            return;
        }
        DataSetDesign responseDesign = completedSession.getResponseDataSetDesign();
        DataSetDesign requestDesign = completedSession.getRequestDataSetDesign();
        this.updateDataSetHandle(responseDesign, dataSetHandle, false, requestDesign.getParameters(), requestDesign.getResultSets());
        DesignerStateAdapter.updateROMDesignerState(completedSession.getResponse().getDesignerState(), (ReportElementHandle)dataSetHandle);
    }

    private void updateDataSetHandle(DataSetDesign setDesign, OdaDataSetHandle setHandle, boolean isSourceChanged, DataSetParameters requestParameters, ResultSets requestResultSets) throws SemanticException {
        if (setDesign == null || setHandle == null) {
            return;
        }
        DesignUtil.validateObject((EObject)setDesign);
        CommandStack stack = setHandle.getModuleHandle().getCommandStack();
        stack.startTrans(null);
        try {
            Property prop;
            int i;
            EList propList;
            setHandle.getElement().setProperty("extensionID", (Object)setDesign.getOdaExtensionDataSetId());
            setHandle.setName(setDesign.getName());
            setHandle.setDisplayName(setDesign.getDisplayName());
            Properties props = setDesign.getPublicProperties();
            if (props != null) {
                propList = props.getProperties();
                i = 0;
                while (i < propList.size()) {
                    prop = (Property)propList.get(i);
                    setHandle.setProperty(prop.getName(), (Object)prop.getValue());
                    ++i;
                }
            }
            if ((props = setDesign.getPrivateProperties()) != null) {
                propList = props.getProperties();
                i = 0;
                while (i < propList.size()) {
                    prop = (Property)propList.get(i);
                    setHandle.setPrivateDriverProperty(prop.getName(), prop.getValue());
                    ++i;
                }
            }
            ResultSetDefinition cachedResultDefn = null;
            if (requestResultSets != null && !requestResultSets.getResultSetDefinitions().isEmpty()) {
                cachedResultDefn = (ResultSetDefinition)requestResultSets.getResultSetDefinitions().get(0);
            }
            ResultSetsAdapter tmpAdapter = new ResultSetsAdapter(setHandle, setDesign);
            this.updateROMResultSets(setHandle, tmpAdapter, cachedResultDefn);
            setHandle.setResultSetName(setDesign.getPrimaryResultSetName());
            setHandle.setQueryText(setDesign.getQueryText());
            DataSetParameterAdapter dataParamAdapter = new DataSetParameterAdapter(setHandle, setDesign);
            dataParamAdapter.updateUserDefinedParameter(requestParameters);
            this.updateROMDataSetParams(dataParamAdapter, requestParameters);
            DataSourceDesign sourceDesign = setDesign.getDataSourceDesign();
            if (sourceDesign != null) {
                OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)setHandle.getDataSource();
                if (isSourceChanged && sourceHandle != null && !sourceHandle.getModuleHandle().isReadOnly()) {
                    setHandle.setDataSource(sourceDesign.getName());
                    this.updateDataSourceHandle(sourceDesign, sourceHandle);
                }
                if (!(isSourceChanged || sourceHandle == null || sourceHandle.getModuleHandle().isReadOnly() || this.isEqualDataSourceDesign(this.createDataSourceDesign(sourceHandle), sourceDesign))) {
                    this.updateDataSourceHandle(sourceDesign, sourceHandle);
                }
            } else {
                setHandle.setDataSource(null);
            }
            this.updateDesignerValue(setDesign, setHandle, requestParameters, dataParamAdapter.getUserDefinedParams(), requestResultSets);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }
}

