/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.ProfileExtensionProvider;
import org.eclipse.datatools.connectivity.internal.security.ICipherProvider;
import org.eclipse.datatools.connectivity.internal.security.SecurityManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConnectionProfileMgmt {
    public static final String FILENAME = "ServerProfiles.dat";
    public static final String BACKUP_FILENAME = "ServerProfiles.bak";
    public static final String DEFAULTCP_FILENAME = "WorkSpaceServerConnectionProfiles.xml";
    private static final String ROOTNAME = "DataTools.ServerProfiles";
    private static final String CHILDNAME = "profile";
    private static final String PROFILENAME = "name";
    private static final String PROFILEDESC = "desc";
    private static final String PROFILEAUTOCONNECT = "autoconnect";
    private static final String PROFILEPARENT = "parent";
    private static final String PROVIDERID = "providerID";
    private static final String PROPKEYS = "keys";
    private static final String PROPPREFIX = "prop_";
    private static final String PROPDELIM = " ";
    private static final String LITERAL_YES = "Yes";
    private static final String LITERAL_NO = "No";
    private static final String PROFILEID = "id";
    private static final String PROPERTYTAG = "property";
    private static final String PROPERTYNAMEATTR = "name";
    private static final String PROPERTYVALUEATTR = "value";
    private static final String BASEPROPERTIESTAG = "baseproperties";
    private static final String VERSIONATTR = "version";
    private static final String VERSIONSTR = "1.0";
    private static final String DRIVERREFTAG = "driverreference";
    private static final String DRIVERNAMEATTR = "driverName";
    private static final String DRIVERTYPEIDATTR = "driverTypeID";
    private static IPath storageLocation = null;
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static DocumentBuilder documentBuilder = null;
    private static TransformerFactory transFactory = null;
    private static Transformer transformer = null;

    private static Properties keysToProperties(Element elem) {
        Properties props = new Properties();
        String keys = elem.getAttribute(PROPKEYS);
        StringTokenizer st = new StringTokenizer(keys, PROPDELIM);
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            String value = elem.getAttribute(PROPPREFIX + key);
            props.put(key, value);
        }
        return props;
    }

    public static void saveCPs(IConnectionProfile[] cps) throws CoreException {
        ConnectionProfileMgmt.saveCPs(cps, ConnectionProfileMgmt.getStorageLocation().append(FILENAME).toFile(), SecurityManager.getInstance().getDefaultCipherProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCPs(IConnectionProfile[] cps, File file, ICipherProvider isp) throws CoreException {
        try {
            Document document;
            DocumentBuilder builder;
            DocumentBuilder documentBuilder = builder = ConnectionProfileMgmt.getDocumentBuilder();
            synchronized (documentBuilder) {
                document = builder.newDocument();
            }
            Element rootElement = document.createElement(ROOTNAME);
            document.appendChild(rootElement);
            if (!file.exists()) {
                file.createNewFile();
            }
            OutputStream out = null;
            FileOutputStream outs = new FileOutputStream(file);
            Writer writer = null;
            try {
                Transformer transformer;
                out = isp != null ? new CipherOutputStream(outs, isp.createEncryptionCipher()) : outs;
                OutputStreamWriter outw = new OutputStreamWriter(out, "UTF-8");
                writer = new BufferedWriter(outw);
                ConnectionProfileMgmt.writeCPToXML1_0(cps, document, rootElement);
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(outw);
                Transformer transformer2 = transformer = ConnectionProfileMgmt.getTransformer();
                synchronized (transformer2) {
                    transformer.transform(source, result);
                    try {
                        writer.close();
                        writer = null;
                    }
                    catch (IOException e) {
                        writer = null;
                        throw e;
                    }
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (DOMException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.saveprofilesxml"), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.saveprofilesxml"), (Throwable)e));
        }
        catch (GeneralSecurityException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.saveprofilesxml"), (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.saveprofilesxml"), (Throwable)e));
        }
    }

    private static void writeCPToXML1_0(IConnectionProfile[] cps, Document document, Element rootElement) {
        rootElement.setAttribute(VERSIONATTR, VERSIONSTR);
        for (int i = 0; i < cps.length; ++i) {
            String value;
            String key;
            Properties props;
            String driverID;
            boolean hasDriverReference;
            Element child;
            IConnectionProfile cp;
            block14: {
                cp = cps[i];
                child = document.createElement(CHILDNAME);
                child.setAttribute("name", cp.getName());
                child.setAttribute(PROFILEDESC, cp.getDescription());
                child.setAttribute(PROFILEAUTOCONNECT, ((ConnectionProfile)cp).isAutoConnect() ? LITERAL_YES : LITERAL_NO);
                child.setAttribute(PROVIDERID, cp.getProviderId());
                child.setAttribute(PROFILEID, cp.getInstanceID());
                hasDriverReference = false;
                driverID = null;
                props = cp.getBaseProperties();
                try {
                    props = ((ConnectionProfileProvider)cp.getProvider()).getPropertiesPersistenceHook().getPersitentProperties(props);
                }
                catch (Exception e) {
                    if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block14;
                    System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookSaveError", new Object[]{cp.getName(), cp.getProviderId()}));
                    e.printStackTrace();
                }
            }
            Element baseProps = document.createElement(BASEPROPERTIESTAG);
            Enumeration<?> enu = props.propertyNames();
            while (enu.hasMoreElements()) {
                key = (String)enu.nextElement();
                value = props.getProperty(key);
                if (key.equals("org.eclipse.datatools.connectivity.driverDefinitionID")) {
                    driverID = value;
                    hasDriverReference = true;
                }
                ConnectionProfileMgmt.appendPropertyToElement(document, baseProps, key, value);
            }
            child.appendChild(baseProps);
            Iterator it = ((ConnectionProfile)cp).getPropertiesMap().entrySet().iterator();
            while (it.hasNext()) {
                Element extraChild;
                block15: {
                    Map.Entry me = it.next();
                    String type = (String)me.getKey();
                    if (type.equals(cp.getProviderId()) || type.equals(BASEPROPERTIESTAG) || type.equals(DRIVERREFTAG)) continue;
                    props = (Properties)me.getValue();
                    extraChild = document.createElement(type);
                    if (props == null) {
                        props = new Properties();
                    }
                    try {
                        ProfileExtensionProvider pep = (ProfileExtensionProvider)cp.getProfileExtensions().get(type);
                        if (pep != null) {
                            props = pep.getPropertiesPersistenceHook().getPersitentProperties(props);
                        }
                    }
                    catch (Exception e) {
                        if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block15;
                        System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookSaveError", new Object[]{cp.getName(), type}));
                        e.printStackTrace();
                    }
                }
                Enumeration<?> enu2 = props.propertyNames();
                while (enu2.hasMoreElements()) {
                    key = (String)enu2.nextElement();
                    value = props.getProperty(key);
                    if (key.equals("org.eclipse.datatools.connectivity.driverDefinitionID")) {
                        driverID = value;
                        hasDriverReference = true;
                    }
                    ConnectionProfileMgmt.appendPropertyToElement(document, extraChild, key, value);
                }
                child.appendChild(extraChild);
            }
            if (hasDriverReference && driverID != null) {
                Element driverElem = document.createElement(DRIVERREFTAG);
                DriverInstance di = DriverManager.getInstance().getDriverInstanceByID(driverID);
                String driverName = di.getName();
                if (di.getTemplate() != null) {
                    String driverType = di.getTemplate().getId();
                    ConnectionProfileMgmt.appendPropertyToElement(document, driverElem, DRIVERNAMEATTR, driverName);
                    ConnectionProfileMgmt.appendPropertyToElement(document, driverElem, DRIVERTYPEIDATTR, driverType);
                    child.appendChild(driverElem);
                }
            }
            rootElement.appendChild(child);
        }
    }

    private static void appendPropertyToElement(Document document, Element parent, String key, String value) {
        Element propElem = document.createElement(PROPERTYTAG);
        propElem.setAttribute("name", key);
        propElem.setAttribute(PROPERTYVALUEATTR, value);
        parent.appendChild(propElem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IConnectionProfile loadCP(String cpName) throws CoreException {
        try {
            Document document;
            DocumentBuilder builder;
            IPath path = ConnectionProfileMgmt.getStorageLocation();
            path = path.append(FILENAME);
            File file = path.toFile();
            if (!file.exists()) {
                return null;
            }
            FileInputStream is = new FileInputStream(file);
            InputSource source = new InputSource(is);
            source.setEncoding("UTF-8");
            DocumentBuilder documentBuilder = builder = ConnectionProfileMgmt.getDocumentBuilder();
            synchronized (documentBuilder) {
                document = builder.parse(source);
            }
            ConnectionProfile cp = null;
            NodeList nl = document.getElementsByTagName(CHILDNAME);
            for (int i = 0; i < nl.getLength(); ++i) {
                Element elem;
                Node node = nl.item(i);
                if (!(node instanceof Element) || !(elem = (Element)node).getAttribute("name").equals(cpName) || (cp = new ConnectionProfile(elem.getAttribute("name"), elem.getAttribute(PROFILEDESC), elem.getAttribute(PROVIDERID), elem.getAttribute(PROFILEPARENT), LITERAL_YES.equals(elem.getAttribute(PROFILEAUTOCONNECT)), elem.getAttribute(PROFILEID))).getProvider() == null) continue;
                cp.setBaseProperties(ConnectionProfileMgmt.keysToProperties(elem));
                if (cp.getProfileExtensions().size() == 0) break;
                Iterator it = cp.getProfileExtensions().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    String type = (String)me.getKey();
                    Node xmlExtraChild = elem.getFirstChild();
                    if (xmlExtraChild == null || !elem.getTagName().equals(type)) continue;
                    cp.setProperties(type, ConnectionProfileMgmt.keysToProperties((Element)xmlExtraChild));
                }
                break;
            }
            cp.setCreated();
            return cp;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
    }

    public static IConnectionProfile[] loadCPs(File file) throws CoreException {
        try {
            byte[] bytes = new byte[5];
            char[] xml = new char[]{'<', '?', 'x', 'm', 'l'};
            FileInputStream fis = new FileInputStream(file);
            fis.read(bytes);
            fis.close();
            boolean isXML = true;
            for (int i = 0; isXML && i < 5; ++i) {
                isXML = bytes[i] == xml[i];
            }
            if (isXML) {
                return ConnectionProfileMgmt.loadCPs(file, null);
            }
            return ConnectionProfileMgmt.loadCPs(file, SecurityManager.getInstance().getDefaultCipherProvider());
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
    }

    private static Properties keysElementsToProperties(Element elem) {
        Properties props = new Properties();
        NodeList nl = elem.getElementsByTagName(PROPERTYTAG);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element property = (Element)node;
            String key = property.getAttribute("name");
            String value = property.getAttribute(PROPERTYVALUEATTR);
            props.put(key, value);
        }
        return props;
    }

    private static boolean readCPsFromXML1_0(ArrayList cps, Document document) {
        if (cps == null) {
            cps = new ArrayList<ConnectionProfile>();
        }
        boolean updatedIDs = false;
        NodeList nl = document.getElementsByTagName(CHILDNAME);
        for (int i = 0; i < nl.getLength(); ++i) {
            Element elem;
            ConnectionProfile cp;
            Node node = nl.item(i);
            if (!(node instanceof Element) || (cp = new ConnectionProfile((elem = (Element)node).getAttribute("name"), elem.getAttribute(PROFILEDESC), elem.getAttribute(PROVIDERID), elem.getAttribute(PROFILEPARENT), LITERAL_YES.equals(elem.getAttribute(PROFILEAUTOCONNECT)), elem.getAttribute(PROFILEID))).getProvider() == null) continue;
            NodeList nl2 = elem.getElementsByTagName(BASEPROPERTIESTAG);
            if (nl.getLength() > 0) {
                Element baseProps = null;
                for (int j = 0; j < nl2.getLength(); ++j) {
                    Element el;
                    Node testnode = nl2.item(j);
                    if (!(testnode instanceof Element) || !(el = (Element)testnode).getTagName().equals(BASEPROPERTIESTAG)) continue;
                    baseProps = el;
                    break;
                }
                if (baseProps != null) {
                    Properties props;
                    block12: {
                        props = ConnectionProfileMgmt.keysElementsToProperties(baseProps);
                        try {
                            props = ((ConnectionProfileProvider)cp.getProvider()).getPropertiesPersistenceHook().populateTransientProperties(props);
                        }
                        catch (Exception e) {
                            if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block12;
                            System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookLoadError", new Object[]{cp.getName(), cp.getProviderId()}));
                            e.printStackTrace();
                        }
                    }
                    cp.setBaseProperties(props);
                }
            }
            NodeList extElements = elem.getChildNodes();
            int extCount = extElements.getLength();
            for (int extIndex = 0; extIndex < extCount; ++extIndex) {
                Properties props;
                String type;
                block13: {
                    Node extNode = extElements.item(extIndex);
                    if (extNode.getNodeType() != 1 || (type = extNode.getNodeName()).equals(BASEPROPERTIESTAG)) continue;
                    if (type.equals(DRIVERREFTAG)) {
                        props = ConnectionProfileMgmt.keysElementsToProperties((Element)extNode);
                        String driverName = props.getProperty(DRIVERNAMEATTR);
                        String driverTypeID = props.getProperty(DRIVERTYPEIDATTR);
                        if (DriverManager.getInstance().getDriverInstanceByName(driverName) != null) continue;
                        DriverInstance di = DriverManager.getInstance().createNewDriverInstance(driverTypeID, driverName, new String());
                        String driverID = di.getId();
                        cp.getBaseProperties().setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", driverID);
                        updatedIDs = true;
                        continue;
                    }
                    props = ConnectionProfileMgmt.keysElementsToProperties((Element)extNode);
                    try {
                        ProfileExtensionProvider pep = (ProfileExtensionProvider)cp.getProfileExtensions().get(type);
                        if (pep != null) {
                            props = pep.getPropertiesPersistenceHook().populateTransientProperties(props);
                        }
                    }
                    catch (Exception e) {
                        if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block13;
                        System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookLoadError", new Object[]{cp.getName(), type}));
                        e.printStackTrace();
                    }
                }
                cp.setProperties(type, props);
            }
            cp.setCreated();
            cps.add(cp);
            updatedIDs = elem.getAttribute(PROFILEID) == null || updatedIDs;
        }
        return updatedIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IConnectionProfile[] loadCPs(File file, ICipherProvider isp) throws CoreException {
        boolean updatedIDs;
        ArrayList<ConnectionProfile> cps;
        InputStream is;
        IConnectionProfile[] retVal;
        block28: {
            IConnectionProfile[] iConnectionProfileArray;
            block27: {
                retVal = null;
                is = null;
                try {
                    try {
                        if (!file.exists()) {
                            iConnectionProfileArray = new IConnectionProfile[]{};
                            Object var23_8 = null;
                            if (is == null) return iConnectionProfileArray;
                            break block27;
                        }
                        FileInputStream fis = new FileInputStream(file);
                        is = isp != null ? new CipherInputStream(fis, isp.createDecryptionCipher()) : fis;
                        InputSource source = new InputSource(is);
                        source.setEncoding("UTF-8");
                        Document document = null;
                        try {
                            DocumentBuilder builder;
                            DocumentBuilder documentBuilder = builder = ConnectionProfileMgmt.getDocumentBuilder();
                            synchronized (documentBuilder) {
                                document = builder.parse(source);
                            }
                        }
                        catch (SAXException e) {
                            try {
                                DocumentBuilder builder;
                                DocumentBuilder documentBuilder = builder = ConnectionProfileMgmt.getDocumentBuilder(true);
                                synchronized (documentBuilder) {
                                    document = builder.parse(source);
                                }
                            }
                            catch (SAXException e2) {
                                throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
                            }
                        }
                        cps = new ArrayList<ConnectionProfile>();
                        updatedIDs = false;
                        String version = document.getDocumentElement().getAttribute(VERSIONATTR);
                        if (version != null && version.equals(VERSIONSTR)) {
                            updatedIDs = ConnectionProfileMgmt.readCPsFromXML1_0(cps, document);
                            break block28;
                        }
                        NodeList nl = document.getElementsByTagName(CHILDNAME);
                        for (int i = 0; i < nl.getLength(); ++i) {
                            Properties props;
                            Element elem;
                            ConnectionProfile cp;
                            block29: {
                                Node node = nl.item(i);
                                if (!(node instanceof Element) || (cp = new ConnectionProfile((elem = (Element)node).getAttribute("name"), elem.getAttribute(PROFILEDESC), elem.getAttribute(PROVIDERID), elem.getAttribute(PROFILEPARENT), LITERAL_YES.equals(elem.getAttribute(PROFILEAUTOCONNECT)), elem.getAttribute(PROFILEID))).getProvider() == null) continue;
                                props = ConnectionProfileMgmt.keysToProperties(elem);
                                try {
                                    props = ((ConnectionProfileProvider)cp.getProvider()).getPropertiesPersistenceHook().populateTransientProperties(props);
                                }
                                catch (Exception e) {
                                    if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block29;
                                    System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookLoadError", new Object[]{cp.getName(), cp.getProviderId()}));
                                    e.printStackTrace();
                                }
                            }
                            cp.setBaseProperties(props);
                            NodeList extElements = elem.getChildNodes();
                            int extCount = extElements.getLength();
                            for (int extIndex = 0; extIndex < extCount; ++extIndex) {
                                String type;
                                block30: {
                                    Node extNode = extElements.item(extIndex);
                                    if (extNode.getNodeType() != 1) continue;
                                    type = extNode.getNodeName();
                                    props = ConnectionProfileMgmt.keysToProperties((Element)extNode);
                                    try {
                                        ProfileExtensionProvider pep = (ProfileExtensionProvider)cp.getProfileExtensions().get(type);
                                        if (pep != null) {
                                            props = pep.getPropertiesPersistenceHook().populateTransientProperties(props);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block30;
                                        System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookLoadError", new Object[]{cp.getName(), type}));
                                        e.printStackTrace();
                                    }
                                }
                                cp.setProperties(type, props);
                            }
                            cp.setCreated();
                            cps.add(cp);
                            updatedIDs = elem.getAttribute(PROFILEID) == null || updatedIDs;
                        }
                        break block28;
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
                    }
                    catch (GeneralSecurityException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    Object var23_10 = null;
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
                    }
                }
            }
            try {}
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
            }
            is.close();
            return iConnectionProfileArray;
        }
        retVal = cps.toArray(new IConnectionProfile[cps.size()]);
        if (updatedIDs) {
            ConnectionProfileMgmt.saveCPs(retVal, file, isp);
        }
        Object var23_9 = null;
        if (is == null) return retVal;
        try {}
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        is.close();
        return retVal;
    }

    public static IPath getStorageLocation() {
        if (storageLocation == null) {
            return ConnectivityPlugin.getDefault().getStateLocation();
        }
        return storageLocation;
    }

    public static void setStorageLocation(IPath location) {
        storageLocation = location;
    }

    private static DocumentBuilder getDocumentBuilder() {
        return ConnectionProfileMgmt.getDocumentBuilder(false);
    }

    private static DocumentBuilder getDocumentBuilder(boolean reset) {
        if (documentBuilder == null || reset) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return documentBuilder;
    }

    private static Transformer getTransformer() {
        if (transformer == null) {
            transFactory = TransformerFactory.newInstance();
            try {
                transformer = transFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return transformer;
    }
}

