/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.HashMap;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;
import org.eclipse.datatools.enablement.oda.xml.util.ThreshHoldInfo;

class NestedColumnUtil {
    private HashMap nestedXMLColumns;
    private RelationInformation relationInfo;
    private String tableName;
    static final /* synthetic */ boolean $assertionsDisabled;

    NestedColumnUtil(RelationInformation relationInfo, String tableName, boolean isSimple) {
        this.relationInfo = relationInfo;
        this.tableName = tableName == null ? "" : tableName.trim();
        String[] namesOfNestedColumns = isSimple ? relationInfo.getTableSimpleNestedXMLColumnNames(this.tableName) : relationInfo.getTableComplexNestedXMLColumnNames(this.tableName);
        this.nestedXMLColumns = new HashMap();
        for (int i = 0; i < namesOfNestedColumns.length; ++i) {
            int backRefNumber = relationInfo.getTableNestedColumnBackRefNumber(tableName, namesOfNestedColumns[i]);
            int forwardRefNumber = relationInfo.getTableColumnForwardRefNumber(tableName, namesOfNestedColumns[i]);
            this.nestedXMLColumns.put(namesOfNestedColumns[i], new ThreshHoldInfo(backRefNumber, forwardRefNumber, isSimple));
        }
    }

    String getNestedColumnValue(String columnName, String currentRootPath) {
        ThreshHoldInfo thInfo = (ThreshHoldInfo)this.nestedXMLColumns.get(columnName);
        if (!$assertionsDisabled && columnName == null) {
            throw new AssertionError();
        }
        return thInfo.getValue(currentRootPath);
    }

    void update(String columnName, String path, String value) {
        String columnPath = this.relationInfo.getTableColumnPath(this.tableName, columnName);
        if (SaxParserUtil.isSamePath(columnPath, path)) {
            ((ThreshHoldInfo)this.nestedXMLColumns.get(columnName)).addInfo(path, value);
        }
    }

    static {
        $assertionsDisabled = !NestedColumnUtil.class.desiredAssertionStatus();
    }
}

