/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.date;

import com.ibm.icu.util.ULocale;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.util.date.DateFormatFactory;
import org.eclipse.datatools.enablement.oda.xml.util.date.DateFormatISO8601;

public final class DateUtil {
    private static ULocale DEFAULT_LOCALE = ULocale.US;
    private static int DEFAULT_DATE_STYLE = 2;
    public static long count = 0L;

    public static Date toDate(Object source) throws OdaException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return new Date(((Date)source).getTime());
        }
        if (source instanceof String) {
            return DateUtil.toDate((String)source);
        }
        throw new OdaException(Messages.getString("dateUtil.ConvertFails") + source.toString());
    }

    public static Time toSqlTime(Object source) throws OdaException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return DateUtil.toSqlTime((Date)source);
        }
        if (source instanceof String) {
            try {
                return DateUtil.toSqlTime(DateUtil.toDate((String)source));
            }
            catch (Exception e) {
                try {
                    return Time.valueOf((String)source);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw new OdaException(Messages.getString("dateUtil.ConvertFails") + source.toString());
    }

    private static Time toSqlTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(14, 0);
        return new Time(calendar.getTimeInMillis());
    }

    public static java.sql.Date toSqlDate(Object source) throws OdaException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return DateUtil.toSqlDate((Date)source);
        }
        if (source instanceof String) {
            try {
                return DateUtil.toSqlDate(DateUtil.toDate((String)source));
            }
            catch (Exception e) {
                try {
                    return java.sql.Date.valueOf((String)source);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw new OdaException(Messages.getString("dateUtil.ConvertFails") + source.toString());
    }

    private static java.sql.Date toSqlDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new java.sql.Date(calendar.getTimeInMillis());
    }

    public static Date toDate(String source, Locale locale) throws OdaException {
        return DateUtil.toDate(source, ULocale.forLocale((Locale)locale));
    }

    public static Date toDate(String source, ULocale locale) throws OdaException {
        if (source == null) {
            return null;
        }
        DateFormat dateFormat = null;
        Date resultDate = null;
        boolean existTime = source.matches(".*[0-9]+:[0-9]+:[0-9]+.*") || source.matches(".*[0-9]+:[0-9]+.*");
        for (int i = DEFAULT_DATE_STYLE; i <= 3; ++i) {
            for (int j = DEFAULT_DATE_STYLE; j <= 3; ++j) {
                dateFormat = DateFormatFactory.getDateTimeInstance(i, j, locale);
                try {
                    resultDate = dateFormat.parse(source);
                    return resultDate;
                }
                catch (ParseException e1) {
                    continue;
                }
            }
            if (existTime) continue;
            dateFormat = DateFormatFactory.getDateInstance(i, locale);
            try {
                resultDate = dateFormat.parse(source);
                return resultDate;
            }
            catch (ParseException e1) {
                // empty catch block
            }
        }
        if (resultDate == null) {
            throw new OdaException(Messages.getString("dateUtil.ConvertFails") + source.toString());
        }
        return resultDate;
    }

    private static Date toDate(String source) throws OdaException {
        try {
            return DateUtil.toDateISO8601(source);
        }
        catch (OdaException e) {
            try {
                return DateUtil.toDate(source, ULocale.getDefault());
            }
            catch (OdaException use) {
                return DateUtil.toDate(source, DEFAULT_LOCALE);
            }
        }
    }

    private static Date toDateISO8601(String source) throws OdaException {
        Date resultDate = null;
        try {
            resultDate = DateFormatISO8601.parse(source);
            return resultDate;
        }
        catch (ParseException e1) {
            throw new OdaException(Messages.getString("dateUtil.ConvertFails") + source.toString());
        }
    }
}

