/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringWriter;
import javax.swing.JLabel;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.gvt.font.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class BaseScope
extends ImporterTopLevel {
    protected static final Log logger = LogFactory.getLog(BaseScope.class);
    protected boolean sealedStdLib = false;
    boolean initialized;
    protected String basePath;
    protected String systemPath;

    public void init(Context cx) {
        this.initStandardObjects(cx, this.sealedStdLib);
        String[] names = new String[]{"print", "load", "lib", "_loadSvg", "_xmlToString", "getTextLenCGG", "getTextHeightCGG"};
        this.defineFunctionProperties(names, BaseScope.class, 2);
        this.initialized = true;
    }

    public static Object print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (Object arg : args) {
            String s = Context.toString((Object)arg);
            logger.info((Object)s);
        }
        return Context.getUndefinedValue();
    }

    public static Object load(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String file = args[0] instanceof NativeJavaObject ? ((NativeJavaObject)args[0]).unwrap().toString() : args[0].toString();
        try {
            BaseScope scope = (BaseScope)thisObj;
            cx.evaluateReader((Scriptable)scope, (Reader)new FileReader(scope.basePath + "/" + file), file, 1, null);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return Context.toBoolean((Object)false);
        }
        return Context.toBoolean((Object)true);
    }

    public static Object getTextLenCGG(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String text = Context.toString((Object)args[0]);
        String fontFamily = Context.toString((Object)args[1]);
        String fontSize = Context.toString((Object)args[2]).trim();
        String fontStyle = "normal";
        String fontWeight = "normal";
        if (args.length > 3) {
            fontStyle = Context.toString((Object)args[3]);
            if (args.length > 4) {
                fontWeight = Context.toString((Object)args[4]);
            }
        }
        Font ffont = BaseScope.getFont(fontFamily, fontSize, fontStyle, fontWeight);
        JLabel label = new JLabel();
        FontMetrics fMetric = label.getFontMetrics(ffont);
        int width = fMetric.stringWidth(text);
        return Context.toNumber((Object)width);
    }

    public static Object getTextHeightCGG(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String fontFamily = Context.toString((Object)args[1]);
        String fontSize = Context.toString((Object)args[2]).trim();
        String fontStyle = "normal";
        String fontWeight = "normal";
        if (args.length > 3) {
            fontStyle = Context.toString((Object)args[3]);
            if (args.length > 4) {
                fontWeight = Context.toString((Object)args[4]);
            }
        }
        Font ffont = BaseScope.getFont(fontFamily, fontSize, fontStyle, fontWeight);
        JLabel label = new JLabel();
        FontMetrics fMetric = label.getFontMetrics(ffont);
        int height = fMetric.getHeight();
        return Context.toNumber((Object)height);
    }

    private static Font getFont(String fontFamily, String fontSize, String fontStyle, String fontWeight) {
        boolean convert = false;
        if (fontSize.endsWith("px")) {
            fontSize = fontSize.substring(0, fontSize.length() - 2);
        } else if (fontSize.endsWith("pt")) {
            fontSize = fontSize.substring(0, fontSize.length() - 2);
        }
        float size = 15.0f;
        try {
            size = Integer.parseInt(fontSize);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        int isize = Math.round(size);
        if (convert) {
            size = 0.75f * size;
            int screenDpi = Toolkit.getDefaultToolkit().getScreenResolution();
            isize = Math.round(size * (float)screenDpi / 72.0f);
        }
        int javaFontStyle = BaseScope.parseCssFontStyleAndWeight(fontStyle, fontWeight);
        return BaseScope.decodeFont(fontFamily, javaFontStyle, isize);
    }

    private static int parseCssFontStyleAndWeight(String fontStyle, String fontWeight) {
        boolean isItalic = false;
        boolean isBold = false;
        if (fontStyle != null && ((fontStyle = fontStyle.toLowerCase()).equals("italic") || fontStyle.equals("oblique"))) {
            isItalic = true;
        }
        if (fontWeight != null && ((fontWeight = fontWeight.toLowerCase()).equals("bold") || fontWeight.equals("bolder") || fontWeight.equals("700") || fontWeight.equals("800") || fontWeight.equals("900"))) {
            isBold = true;
        }
        if (isItalic) {
            return isBold ? 3 : 2;
        }
        return isBold ? 1 : 0;
    }

    private static Font decodeFont(String fontFamily, int fontStyle, int isize) {
        String fontStyleText = "";
        switch (fontStyle) {
            case 1: {
                fontStyleText = "BOLD ";
                break;
            }
            case 2: {
                fontStyleText = "ITALIC ";
                break;
            }
            case 3: {
                fontStyleText = "BOLDITALIC ";
            }
        }
        String capFontFamily = fontFamily.substring(0, 1).toUpperCase() + fontFamily.substring(1, fontFamily.length());
        Font ffont = Font.decode(capFontFamily + " " + fontStyleText + isize);
        if (ffont.getFamily().equals("Dialog") && !fontFamily.equals("dialog")) {
            GVTFontFamily awtFamily = FontFamilyResolver.resolve((String)fontFamily);
            if (awtFamily == null) {
                awtFamily = FontFamilyResolver.defaultFont;
            }
            ffont = new Font(awtFamily.getFamilyName(), fontStyle, isize);
        }
        return ffont;
    }

    public static Object _loadSvg(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String file = args[0].toString();
        try {
            BaseScope scope = (BaseScope)thisObj;
            String parser = "org.apache.xerces.parsers.SAXParser";
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
            String uri = "file:" + scope.basePath + "/" + file;
            Document doc = factory.createDocument(uri);
            SVGDOMImplementation impl = (SVGDOMImplementation)SVGDOMImplementation.getDOMImplementation();
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            CSSEngine eng = impl.createCSSEngine((AbstractStylableDocument)((SVGOMDocument)doc), (CSSContext)ctx);
            ((SVGOMDocument)doc).setCSSEngine(eng);
            return Context.javaToJS((Object)doc, (Scriptable)scope);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
            return Context.getUndefinedValue();
        }
    }

    public static Object lib(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String file = args[0].toString();
        try {
            BaseScope scope = (BaseScope)thisObj;
            cx.evaluateReader((Scriptable)scope, (Reader)new FileReader(scope.systemPath + "/" + file), file, 1, null);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return Context.toBoolean((Object)false);
        }
        return Context.toBoolean((Object)true);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setSystemPath(String systemPath) {
        this.systemPath = systemPath;
    }

    public static Object _xmlToString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Node node = (Node)((NativeJavaObject)args[0]).unwrap();
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
            BaseScope scope = (BaseScope)thisObj;
            return Context.javaToJS((Object)stringWriter.getBuffer().toString(), (Scriptable)scope);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }
}

