/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import pt.webdetails.cgg.datasources.DatasourceFactory;
import pt.webdetails.cgg.scripts.BaseScope;
import pt.webdetails.cgg.scripts.Script;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseScript
implements Script {
    protected static final Log logger = LogFactory.getLog(BaseScript.class);
    protected String source;
    protected String rootPath;
    protected Scriptable scope;

    BaseScript() {
    }

    BaseScript(String source) {
        this.source = source.replaceAll("\\\\", "/").replaceAll("/+", "/");
        this.rootPath = this.source.replaceAll("(.*/).*", "$1");
    }

    public void initializeObjects() {
        ContextFactory.getGlobal().enter();
        Object wrappedFactory = Context.javaToJS((Object)new DatasourceFactory(), (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"datasourceFactory", (Object)wrappedFactory);
    }

    @Override
    public void setScope(Scriptable scope) {
        this.scope = scope;
        if (scope instanceof BaseScope) {
            ((BaseScope)scope).setBasePath(this.rootPath);
        }
        this.initializeObjects();
    }

    protected void executeScript(Map<String, Object> params) {
        Context cx = Context.getCurrentContext();
        cx.setOptimizationLevel(-1);
        cx.setLanguageVersion(170);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Object wrappedParams = params != null ? Context.javaToJS(params, (Scriptable)this.scope) : Context.javaToJS(new HashMap(), (Scriptable)this.scope);
        ScriptableObject.defineProperty((Scriptable)this.scope, (String)"params", (Object)wrappedParams, (int)0);
        try {
            cx.evaluateReader(this.scope, (Reader)new FileReader(this.source), this.source.replaceAll("(.*/)(.*)", "$2"), 1, null);
        }
        catch (IOException ex) {
            logger.error((Object)("Failed to read " + this.source + ": " + ex.toString()));
        }
    }
}

