/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.awt.image.BufferedImage;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import pt.webdetails.cgg.charts.Chart;
import pt.webdetails.cgg.charts.Java2DChart;
import pt.webdetails.cgg.scripts.BaseScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Java2DScript
extends BaseScript {
    private static final Log logger = LogFactory.getLog(Java2DScript.class);
    private Map<String, String> params;
    private String source;
    private BufferedImage imageBuffer;
    private String[] dependencies;
    private long width;
    private long height;

    Java2DScript() {
    }

    Java2DScript(String source, long width, long height) {
        super(source);
        this.width = width;
        this.height = height;
    }

    @Override
    public Chart execute() {
        return this.execute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chart execute(Map<String, Object> params) {
        Context cx = ContextFactory.getGlobal().enter();
        try {
            this.getGraphics();
            this.executeScript(params);
            Java2DChart java2DChart = new Java2DChart(this.imageBuffer);
            return java2DChart;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (Context.getCurrentContext() != null) {
                Context.exit();
            }
        }
        return null;
    }

    private void getGraphics() {
        this.imageBuffer = new BufferedImage((int)this.width, (int)this.height, 6);
        Object wrappedGraphics = Context.javaToJS((Object)this.imageBuffer.createGraphics(), (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"graphics", (Object)wrappedGraphics);
    }
}

