/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.cli;

import java.io.File;
import java.io.OutputStream;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.render.awt.viewer.Renderable;

public class InputHandler
implements ErrorListener,
Renderable {
    private File sourcefile = null;
    private File stylesheet = null;
    private Vector xsltParams = null;
    protected Log log = LogFactory.getLog((Class)(class$org$apache$fop$cli$InputHandler == null ? (class$org$apache$fop$cli$InputHandler = InputHandler.class$("org.apache.fop.cli.InputHandler")) : class$org$apache$fop$cli$InputHandler));
    static /* synthetic */ Class class$org$apache$fop$cli$InputHandler;

    public InputHandler(File xmlfile, File xsltfile, Vector params) {
        this.sourcefile = xmlfile;
        this.stylesheet = xsltfile;
        this.xsltParams = params;
    }

    public InputHandler(File fofile) {
        this.sourcefile = fofile;
    }

    public void renderTo(FOUserAgent userAgent, String outputFormat, OutputStream out) throws FOPException {
        FopFactory factory = userAgent.getFactory();
        Fop fop = out != null ? factory.newFop(outputFormat, userAgent, out) : factory.newFop(outputFormat, userAgent);
        if (fop.getUserAgent().getBaseURL() == null) {
            String baseURL = null;
            try {
                baseURL = new File(this.sourcefile.getAbsolutePath()).getParentFile().toURL().toExternalForm();
            }
            catch (Exception e) {
                baseURL = "";
            }
            fop.getUserAgent().setBaseURL(baseURL);
        }
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        this.transformTo(res);
    }

    public void renderTo(FOUserAgent userAgent, String outputFormat) throws FOPException {
        this.renderTo(userAgent, outputFormat, null);
    }

    public void transformTo(OutputStream out) throws FOPException {
        StreamResult res = new StreamResult(out);
        this.transformTo(res);
    }

    protected void transformTo(Result result) throws FOPException {
        try {
            Transformer transformer;
            TransformerFactory factory = TransformerFactory.newInstance();
            if (this.stylesheet == null) {
                transformer = factory.newTransformer();
            } else {
                transformer = factory.newTransformer(new StreamSource(this.stylesheet));
                if (this.xsltParams != null) {
                    for (int i = 0; i < this.xsltParams.size(); i += 2) {
                        transformer.setParameter((String)this.xsltParams.elementAt(i), (String)this.xsltParams.elementAt(i + 1));
                    }
                }
            }
            transformer.setErrorListener(this);
            StreamSource src = new StreamSource(this.sourcefile);
            transformer.transform(src, result);
        }
        catch (Exception e) {
            throw new FOPException(e);
        }
    }

    public void warning(TransformerException exc) {
        this.log.warn((Object)exc.toString());
    }

    public void error(TransformerException exc) {
        this.log.error((Object)exc.toString());
    }

    public void fatalError(TransformerException exc) throws TransformerException {
        throw exc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

