/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.table.CollapsingBorderModelEyeCatching;
import org.apache.fop.layoutmgr.table.GridUnit;

public abstract class CollapsingBorderModel {
    protected static final int BEFORE = 0;
    protected static final int AFTER = 1;
    protected static final int START = 2;
    protected static final int END = 3;
    public static final int VERTICAL_START_END_OF_TABLE = 1;
    private static CollapsingBorderModel collapse = null;
    private static CollapsingBorderModel collapseWithPrecedence = null;

    public static CollapsingBorderModel getBorderModelFor(int borderCollapse) {
        switch (borderCollapse) {
            case 26: {
                if (collapse == null) {
                    collapse = new CollapsingBorderModelEyeCatching();
                }
                return collapse;
            }
            case 27: {
                if (collapseWithPrecedence == null) {
                    // empty if block
                }
                return collapseWithPrecedence;
            }
        }
        throw new IllegalArgumentException("Illegal border-collapse mode.");
    }

    public static int getOtherSide(int side) {
        switch (side) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Illegal parameter: side");
    }

    protected boolean isVerticalRelation(int side) {
        return side == 0 || side == 1;
    }

    public int getPreferenceValue(int style) {
        switch (style) {
            case 37: {
                return 0;
            }
            case 133: {
                return -1;
            }
            case 31: {
                return -2;
            }
            case 36: {
                return -3;
            }
            case 119: {
                return -4;
            }
            case 101: {
                return -5;
            }
            case 55: {
                return -6;
            }
            case 67: {
                return -7;
            }
        }
        throw new IllegalStateException("Illegal border style: " + style);
    }

    public abstract CommonBorderPaddingBackground.BorderInfo determineWinner(GridUnit var1, GridUnit var2, int var3, int var4);
}

