/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;

public class GridUnit {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$table$GridUnit == null ? (class$org$apache$fop$layoutmgr$table$GridUnit = GridUnit.class$("org.apache.fop.layoutmgr.table.GridUnit")) : class$org$apache$fop$layoutmgr$table$GridUnit));
    public static final int IN_FIRST_COLUMN = 0;
    public static final int IN_LAST_COLUMN = 1;
    public static final int FIRST_IN_TABLE = 2;
    public static final int FIRST_IN_PART = 3;
    public static final int LAST_IN_PART = 4;
    public static final int LAST_IN_TABLE = 5;
    public static final int KEEP_WITH_NEXT_PENDING = 6;
    public static final int KEEP_WITH_PREVIOUS_PENDING = 7;
    private PrimaryGridUnit primary;
    private TableCell cell;
    private TableRow row;
    private TableColumn column;
    private int startCol;
    private int colSpanIndex;
    private int rowSpanIndex;
    private CommonBorderPaddingBackground effectiveBorders;
    private byte flags = 0;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$GridUnit;

    public GridUnit(TableCell cell, TableColumn column, int startCol, int colSpanIndex) {
        this(null, cell, column, startCol, colSpanIndex);
    }

    public GridUnit(PrimaryGridUnit primary, TableColumn column, int startCol, int colSpanIndex) {
        this(primary, primary.getCell(), column, startCol, colSpanIndex);
    }

    protected GridUnit(PrimaryGridUnit primary, TableCell cell, TableColumn column, int startCol, int colSpanIndex) {
        this.primary = primary;
        this.cell = cell;
        this.column = column;
        this.startCol = startCol;
        this.colSpanIndex = colSpanIndex;
    }

    public TableCell getCell() {
        return this.cell;
    }

    public TableColumn getColumn() {
        return this.column;
    }

    public TableRow getRow() {
        if (this.row != null) {
            return this.row;
        }
        if (this.getCell().getParent() instanceof TableRow) {
            return (TableRow)this.getCell().getParent();
        }
        return null;
    }

    public void setRow(TableRow row) {
        this.row = row;
    }

    public TableBody getBody() {
        FONode node;
        for (node = this.getCell(); node != null && !(node instanceof TableBody); node = node.getParent()) {
        }
        return (TableBody)node;
    }

    public Table getTable() {
        FONode node;
        for (node = this.getBody(); node != null && !(node instanceof Table); node = node.getParent()) {
        }
        if (node == null && this.getColumn() != null) {
            node = this.getColumn().getParent();
        }
        return (Table)node;
    }

    public PrimaryGridUnit getPrimary() {
        return this.isPrimary() ? (PrimaryGridUnit)this : this.primary;
    }

    public boolean isPrimary() {
        return false;
    }

    public boolean isEmpty() {
        return this.cell == null;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public boolean isLastGridUnitColSpan() {
        if (this.cell != null) {
            return this.colSpanIndex == this.cell.getNumberColumnsSpanned() - 1;
        }
        return true;
    }

    public boolean isLastGridUnitRowSpan() {
        if (this.cell != null) {
            return this.rowSpanIndex == this.cell.getNumberRowsSpanned() - 1;
        }
        return true;
    }

    public int getRowSpanIndex() {
        return this.rowSpanIndex;
    }

    public int getColSpanIndex() {
        return this.colSpanIndex;
    }

    public CommonBorderPaddingBackground.BorderInfo getOriginalBorderInfoForCell(int side) {
        if (this.cell != null) {
            return this.cell.getCommonBorderPaddingBackground().getBorderInfo(side);
        }
        return null;
    }

    public CommonBorderPaddingBackground getBorders() {
        return this.effectiveBorders;
    }

    public boolean hasBorders() {
        return this.getBorders() != null && this.getBorders().hasBorder();
    }

    public void assignBorderForSeparateBorderModel() {
        if (this.cell != null) {
            this.effectiveBorders = this.cell.getCommonBorderPaddingBackground();
        }
    }

    public void resolveBorder(GridUnit other, int side) {
        this.resolveBorder(other, side, 0);
    }

    public void resolveBorder(GridUnit other, int side, int resFlags) {
        CollapsingBorderModel borderModel = CollapsingBorderModel.getBorderModelFor(this.getTable().getBorderCollapse());
        if (this.effectiveBorders == null) {
            this.effectiveBorders = new CommonBorderPaddingBackground();
        }
        this.effectiveBorders.setBorderInfo(borderModel.determineWinner(this, other, side, resFlags), side);
        if (this.cell != null) {
            this.effectiveBorders.setPadding(this.cell.getCommonBorderPaddingBackground());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " resolved borders: " + "before=" + this.effectiveBorders.getBorderBeforeWidth(false) + ", " + "after=" + this.effectiveBorders.getBorderAfterWidth(false) + ", " + "start=" + this.effectiveBorders.getBorderStartWidth(false) + ", " + "end=" + this.effectiveBorders.getBorderEndWidth(false)));
        }
    }

    public boolean getFlag(int which) {
        return (this.flags & 1 << which) != 0;
    }

    public void setFlag(int which, boolean value) {
        this.flags = value ? (byte)(this.flags | 1 << which) : (byte)(this.flags & ~(1 << which));
    }

    public GridUnit createNextRowSpanningGridUnit() {
        if (this.isLastGridUnitRowSpan()) {
            return null;
        }
        GridUnit gu = new GridUnit(this.getPrimary(), this.getColumn(), this.startCol, this.colSpanIndex);
        gu.rowSpanIndex = this.rowSpanIndex + 1;
        return gu;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isEmpty()) {
            buffer.append("EMPTY");
        } else if (this.isPrimary()) {
            buffer.append("Primary");
        }
        buffer.append("GridUnit:");
        if (this.colSpanIndex > 0) {
            buffer.append(" colSpan=").append(this.colSpanIndex);
            if (this.isLastGridUnitColSpan()) {
                buffer.append("(last)");
            }
        }
        if (this.rowSpanIndex > 0) {
            buffer.append(" rowSpan=").append(this.rowSpanIndex);
            if (this.isLastGridUnitRowSpan()) {
                buffer.append("(last)");
            }
        }
        buffer.append(" startCol=").append(this.startCol);
        if (!this.isPrimary() && this.getPrimary() != null) {
            buffer.append(" primary=").append(this.getPrimary().getStartRow());
            buffer.append("/").append(this.getPrimary().getStartCol());
            if (this.getPrimary().getCell() != null) {
                buffer.append(" id=" + this.getPrimary().getCell().getId());
            }
        }
        buffer.append(" flags=").append(Integer.toBinaryString(this.flags));
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

