/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.metadata.service;

import flexjson.JSONDeserializer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.common.ui.messages.Messages;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.Alignment;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.FieldType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.thin.Condition;
import org.pentaho.metadata.model.thin.Element;
import org.pentaho.metadata.model.thin.Model;
import org.pentaho.metadata.model.thin.ModelInfo;
import org.pentaho.metadata.query.model.CombinationType;
import org.pentaho.metadata.query.model.Constraint;
import org.pentaho.metadata.query.model.Order;
import org.pentaho.metadata.query.model.Parameter;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.pms.core.exception.PentahoMetadataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataServiceUtil2
extends PentahoBase {
    private static final long serialVersionUID = -123835493828427853L;
    private Log logger = LogFactory.getLog(MetadataServiceUtil2.class);
    private Domain domain;

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    protected String getLocale() {
        String locale = LocaleHelper.getClosestLocale((String)LocaleHelper.getLocale().toString(), (String[])this.domain.getLocaleCodes());
        return locale;
    }

    public Model createThinModel(LogicalModel m, String domainId) {
        Model model = new Model();
        model.setName(m.getName(this.getLocale()));
        model.setModelId(m.getId());
        model.setGroupId(domainId);
        model.setDescription(m.getDescription(this.getLocale()));
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Category cat : m.getCategories()) {
            this.createCategory(m, cat, elements);
        }
        model.setElements(elements.toArray(new Element[elements.size()]));
        return model;
    }

    private void createCategory(LogicalModel m, Category c, List<Element> elements) {
        Element cat = new Element();
        cat.setName(c.getName(this.getLocale()));
        cat.setId(c.getId());
        cat.setDescription(c.getDescription(this.getLocale()));
        if (cat.getId().equals(cat.getDescription())) {
            cat.setDescription(null);
        }
        cat.setIsQueryElement(false);
        elements.add(cat);
        for (LogicalColumn col : c.getLogicalColumns()) {
            elements.add(this.createColumn(m, col, c, cat));
        }
    }

    private Element createColumn(LogicalModel m, LogicalColumn c, Category category, Element cat) {
        Boolean hidden;
        Element col = new Element();
        col.setName(c.getName(this.getLocale()));
        col.setId(c.getId());
        col.setDescription(c.getDescription(this.getLocale()));
        col.setParentId(cat.getId());
        if (col.getId().equals(col.getDescription())) {
            col.setDescription(null);
        }
        if (c.getFieldType() != null) {
            col.setElementType(c.getFieldType().name());
        } else {
            col.setElementType("UNKNOWN");
        }
        col.setDataType(c.getDataType().getName().toUpperCase());
        col.setParentId(category.getId());
        List possibleAggs = c.getAggregationList();
        ArrayList<String> aggTypes = new ArrayList<String>();
        if (possibleAggs != null) {
            for (AggregationType agg : possibleAggs) {
                aggTypes.add(agg.name());
            }
        }
        AggregationType defaultAggType = AggregationType.NONE;
        if (c.getAggregationType() != null) {
            defaultAggType = c.getAggregationType();
        }
        if (!aggTypes.contains(defaultAggType.name())) {
            aggTypes.add(defaultAggType.name());
        }
        col.setAvailableAggregations(aggTypes.toArray(new String[aggTypes.size()]));
        col.setDefaultAggregation(defaultAggType.name());
        col.setSelectedAggregation(defaultAggType.name());
        DataType dataType = c.getDataType();
        FieldType fieldType = c.getFieldType();
        Object obj = c.getProperty("alignment");
        if (obj instanceof Alignment) {
            if (obj == Alignment.LEFT) {
                col.setHorizontalAlignment(Alignment.LEFT.toString());
            } else if (obj == Alignment.RIGHT) {
                col.setHorizontalAlignment(Alignment.RIGHT.toString());
            } else if (obj == Alignment.CENTERED) {
                col.setHorizontalAlignment(Alignment.CENTERED.toString());
            }
        } else if (fieldType == FieldType.FACT) {
            col.setHorizontalAlignment(Alignment.RIGHT.toString());
        } else if (fieldType == FieldType.OTHER && dataType == DataType.NUMERIC) {
            col.setHorizontalAlignment(Alignment.RIGHT.toString());
        } else {
            col.setHorizontalAlignment(Alignment.LEFT.toString());
        }
        obj = c.getProperty("mask");
        if (obj != null) {
            col.setFormatMask((String)obj);
        }
        if ((hidden = (Boolean)c.getProperty("hidden")) != null) {
            col.setHiddenForUser(hidden.booleanValue());
        }
        return col;
    }

    public String createCdaJson(IPentahoResultSet resultSet, String locale) throws JSONException {
        if (resultSet == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        JSONArray metadataArray = new JSONArray();
        int columnCount = resultSet.getColumnCount();
        int rowCount = resultSet.getRowCount();
        for (int i = 0; i < columnCount; ++i) {
            JSONObject info = new JSONObject();
            info.put("colIndex", i);
            info.put("colName", resultSet.getMetaData().getColumnHeaders()[0][i]);
            DataType type = (DataType)resultSet.getMetaData().getAttribute(0, i, "datatype");
            info.put("colType", (Object)type.getName().toUpperCase());
            LocalizedString name = (LocalizedString)resultSet.getMetaData().getAttribute(0, i, Concept.NAME_PROPERTY);
            if (name != null && locale != null) {
                info.put("colLabel", (Object)name.getString(locale));
            }
            metadataArray.put((Object)info);
        }
        json.put("metadata", (Object)metadataArray);
        JSONArray valuesArray = new JSONArray();
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            JSONArray rowArray = new JSONArray();
            valuesArray.put((Object)rowArray);
            for (int colIdx = 0; colIdx < columnCount; ++colIdx) {
                rowArray.put(resultSet.getValueAt(rowIdx, colIdx));
            }
        }
        json.put("resultset", (Object)valuesArray);
        return json.toString();
    }

    public Domain getDomainObject(String query) throws PentahoMetadataException {
        QueryXmlHelper helper = new QueryXmlHelper();
        IMetadataDomainRepository domainRepository = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
        Query fatQuery = helper.fromXML(domainRepository, query);
        return fatQuery.getDomain();
    }

    public Query convertQuery(org.pentaho.metadata.model.thin.Query src, ModelInfo info) {
        Order.Type type;
        IMetadataDomainRepository domainRepository = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
        Domain fullDomain = domainRepository.getDomain(info.getGroupId());
        LogicalModel logicalModel = fullDomain.findLogicalModel(info.getModelId());
        Query dest = new Query(fullDomain, logicalModel);
        List selections = dest.getSelections();
        for (Element column : src.getElements()) {
            LogicalColumn logicalColumn = logicalModel.findLogicalColumn(column.getId());
            Category category = this.getCategory(column.getId(), logicalModel);
            AggregationType aggregationType = AggregationType.valueOf((String)column.getSelectedAggregation());
            Selection selection = new Selection(category, logicalColumn, aggregationType);
            selections.add(selection);
        }
        List constraints = dest.getConstraints();
        for (Condition condition : src.getConditions()) {
            CombinationType combinationType = CombinationType.valueOf((String)condition.getCombinationType());
            LogicalColumn logicalColumn = logicalModel.findLogicalColumn(condition.getElementId());
            String paramName = condition.isParameterized() ? condition.getValue()[0] : null;
            String formula = condition.getCondition(logicalColumn.getDataType().name(), paramName);
            Constraint constraint = new Constraint(combinationType, formula);
            constraints.add(constraint);
        }
        if (src.getDisableDistinct() != null) {
            dest.setDisableDistinct(src.getDisableDistinct().booleanValue());
        }
        List orders = dest.getOrders();
        for (org.pentaho.metadata.model.thin.Order order : src.getOrders()) {
            for (Selection selection : selections) {
                if (!selection.getLogicalColumn().getId().equals(order.getElementId())) continue;
                type = Order.Type.valueOf((String)order.getOrderType());
                Order fullOrder = new Order(selection, type);
                orders.add(fullOrder);
            }
        }
        List parameters = dest.getParameters();
        for (org.pentaho.metadata.model.thin.Parameter parameter : src.getParameters()) {
            LogicalColumn logicalColumn = logicalModel.findLogicalColumn(parameter.getElementId());
            type = logicalColumn.getDataType();
            String[] value = parameter.getValue();
            String name = parameter.getName() != null ? parameter.getName() : parameter.getElementId();
            Parameter fullParam = new Parameter(name, (DataType)type, (Object)value[0]);
            parameters.add(fullParam);
        }
        return dest;
    }

    protected Category getCategory(String columnId, LogicalModel logicalModel) {
        for (Category category : logicalModel.getCategories()) {
            if (category.findLogicalColumn(columnId) == null) continue;
            return category;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.pentaho.metadata.model.thin.Query deserializeJsonQuery(String json) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            org.pentaho.metadata.model.thin.Query query = (org.pentaho.metadata.model.thin.Query)new JSONDeserializer().deserialize(json);
            Thread.currentThread().setContextClassLoader(oldLoader);
            return query;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(oldLoader);
                throw throwable;
            }
            catch (Exception e) {
                this.error(Messages.getErrorString("MetadataService.ERROR_0007_BAD_JSON", json), e);
                return null;
            }
        }
    }

    public Log getLogger() {
        return this.logger;
    }
}

