/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.services;

import java.util.ResourceBundle;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class LocalizationService {
    public static final String SETTINGS_FILE = "common-ui/settings.xml";

    private ResourceBundle getBundle(String name) {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        ResourceBundle bundle = resLoader.getResourceBundle(LocalizationService.class, name);
        String cache = PentahoSystem.getSystemSetting((String)SETTINGS_FILE, (String)"cache-messages", (String)"false");
        if (cache != null && cache.equals("false")) {
            ResourceBundle.clearCache();
        }
        return bundle;
    }

    public ResourceBundle getBundle() {
        return this.getBundle("resources/messages/messages");
    }

    public ResourceBundle getHelpBundle() {
        return this.getBundle("resources/help/messages");
    }

    public String getJSONBundle() {
        try {
            return this.getJsonForBundle(this.getBundle());
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    private String getJsonForBundle(ResourceBundle bundle) throws JSONException {
        JSONObject cat = new JSONObject();
        for (String key : bundle.keySet()) {
            cat.put(key, (Object)bundle.getString(key));
        }
        return cat.toString();
    }

    public String getHelpJSONBundle() {
        try {
            return this.getJsonForBundle(this.getHelpBundle());
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }
}

