/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.services;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.common.ui.messages.Messages;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SimpleContentGenerator;

public class SolutionRepoSaveContentGenerator
extends SimpleContentGenerator {
    private static final long serialVersionUID = 8445693289282403228L;

    public void createContent(OutputStream out) throws Exception {
        int ret;
        String basePath;
        IContentInfo contentInfo;
        IPluginManager pluginManager;
        IParameterProvider request = (IParameterProvider)this.parameterProviders.get("request");
        String fullPath = request.getStringParameter("filepath", null);
        if (fullPath == null) {
            this.errorMessage(Messages.getErrorString("SolutionRepo.ERROR_0001_NO_FILEPATH"), out);
            return;
        }
        String state = request.getStringParameter("state", null);
        if (state == null) {
            this.errorMessage(Messages.getErrorString("SolutionRepo.ERROR_0002_NO_STATE"), out);
            return;
        }
        String type = request.getStringParameter("type", null);
        if (type == null) {
            this.errorMessage(Messages.getErrorString("SolutionRepo.ERROR_0007_NO_TYPE"), out);
            return;
        }
        boolean replace = request.getStringParameter("replace", "false").toLowerCase().equals("true");
        ActionInfo info = ActionInfo.parseActionString((String)fullPath);
        if (info == null) {
            this.errorMessage(Messages.getErrorString("SolutionRepo.ERROR_0003_BAD_PATH", fullPath), out);
            return;
        }
        ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.userSession);
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("state-file");
        Element documentation = root.addElement("documentation");
        documentation.addElement("author").addCDATA(this.userSession.getName());
        root.addElement("state").addCDATA(state);
        String title = request.getStringParameter("title", "");
        documentation.addElement("title").addCDATA(title);
        String description = request.getStringParameter("description", "");
        documentation.addElement("description").addCDATA(description);
        String fileName = info.getActionName();
        if (!fileName.endsWith('.' + type)) {
            fileName = fileName + '.' + type;
        }
        if ((pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)this.userSession)) != null && (contentInfo = pluginManager.getContentInfoFromExtension(type, this.userSession)) != null) {
            String icon = contentInfo.getIconUrl();
            documentation.addElement("icon").addCDATA(icon);
        }
        if (!(basePath = PentahoSystem.getApplicationContext().getSolutionRootPath()).endsWith("/")) {
            basePath = basePath + '/';
        }
        if ((ret = repo.addSolutionFile(basePath, info.getSolutionName() + '/' + info.getPath(), fileName, doc.asXML().getBytes(), replace)) == 1) {
            this.errorMessage(Messages.getErrorString("SolutionRepo.ERROR_0004_CANNOT_REPLACE"), out);
            return;
        }
        if (ret == 5) {
            this.errorMessage(Messages.getErrorString("SolutionRepo.ERROR_0005_CREDENTIALS"), out);
            return;
        }
        if (ret != 3) {
            this.errorMessage(Messages.getErrorString("SolutionRepo.ERROR_0006_SAVE_FAILED"), out);
            return;
        }
        out.write(Messages.getString("SolutionRepo.USER_FILE_SAVE").getBytes());
    }

    protected void errorMessage(String message, OutputStream out) throws IOException {
        out.write(message.getBytes());
        this.error(message);
    }

    public Log getLogger() {
        return LogFactory.getLog(SolutionRepoSaveContentGenerator.class);
    }

    public String getMimeType() {
        return "text/text";
    }
}

