/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler;

import java.util.Collection;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.AvailableItemCollection;
import org.pentaho.agilebi.modeler.nodes.AvailableTable;
import org.pentaho.agilebi.modeler.nodes.IAvailableItem;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class ColResolverController
extends AbstractXulEventHandler {
    private ModelerWorkspace workspace;
    private XulDialog dialog;
    private ColumnBackedNode node;
    private Binding fieldListBinding;
    private Binding selectedFieldsBinding;
    private IAvailableItem[] selectedFields = new IAvailableItem[0];
    private AvailableItemCollection items = new AvailableItemCollection();
    BindingFactory bf;

    public void show(ModelerWorkspace workspace, ColumnBackedNode node, AvailableTable restrictedToTable) {
        this.workspace = workspace;
        this.items.clear();
        if (restrictedToTable != null) {
            this.items.add(restrictedToTable);
        } else {
            this.items.addAll((Collection)((Object)workspace.getAvailableTables()));
        }
        this.node = node;
        this.dialog.show();
    }

    public void show(ModelerWorkspace workspace, ColumnBackedNode node) {
        this.workspace = workspace;
        this.items.clear();
        this.items.addAll((Collection)((Object)workspace.getAvailableTables()));
        this.node = node;
        this.dialog.show();
    }

    public void init() {
        this.bf.setDocument(this.document);
        this.dialog = (XulDialog)this.document.getElementById("resolveColumnsDialog");
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.fieldListBinding = this.bf.createBinding((Object)this.items, "children", "resolveColumnsTree", "elements", new BindingConvertor[0]);
        this.selectedFieldsBinding = this.bf.createBinding("resolveColumnsTree", "selectedItem", (Object)this, "selectedFieldsChanged", new BindingConvertor[0]);
    }

    @Bindable
    public void done() {
        if (this.selectedFields.length == 1) {
            ColumnBackedNode cnode = this.workspace.createColumnBackedNode((AvailableField)this.selectedFields[0], this.workspace.getCurrentModelerPerspective());
            LogicalColumn lCol = cnode.getLogicalColumn();
            this.node.setLogicalColumn(lCol);
            this.workspace.setDirty(true);
            this.dialog.hide();
        }
    }

    @Bindable
    public void cancel() {
        this.dialog.hide();
    }

    public String getName() {
        return "colResolver";
    }

    @Bindable
    public void setSelectedFieldsChanged(Object selected) {
        if (selected != null && selected instanceof AvailableField) {
            this.selectedFields = new IAvailableItem[]{(IAvailableItem)selected};
        }
    }

    public BindingFactory getBindingFactory() {
        return this.bf;
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }
}

